package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.PlayerAnimLibMod;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4013;

/**
 * Cache class for holding loaded {@link Animation Animations}
 */
public class PlayerAnimResources implements class_4013 {
	public static final class_2960 KEY = PlayerAnimLibMod.id("animation");
	private static final Map<class_2960, Animation> ANIMATIONS = new Object2ObjectOpenHashMap<>();

	/**
	 * Get an animation from the registry, using Identifier(mod_id, animation_name) as the key.
	 * @return animation, <code>null</code> if no animation
	 */
	public static @Nullable Animation getAnimation(class_2960 id) {
		return ANIMATIONS.get(id);
	}

	/**
	 * Get Optional animation from registry
	 * @param identifier identifier
	 * @return Optional animation
	 */
	@NotNull
	public static Optional<Animation> getAnimationOptional(@NotNull class_2960 identifier) {
		return Optional.ofNullable(getAnimation(identifier));
	}

	/**
	 * @return an unmodifiable map of all the animations
	 */
	public static Map<class_2960, Animation> getAnimations() {
		return Collections.unmodifiableMap(ANIMATIONS);
	}

	/**
	 * Returns the animations of a specific mod/namespace
	 * @param modid namespace (assets/modid)
	 * @return map of path and animations
	 */
	@NotNull
	public static Map<String, Animation> getModAnimations(@NotNull String modid) {
		HashMap<String, Animation> map = new HashMap<>();
		for (Map.Entry<class_2960, Animation> entry: ANIMATIONS.entrySet()) {
			if (entry.getKey().method_12836().equals(modid)) {
				map.put(entry.getKey().method_12832(), entry.getValue());
			}
		}
		return map;
	}

	/**
	 * @param id ID of the desired animation.
	 * @return Returns true if that animation is available.
	 */
	public static boolean hasAnimation(class_2960 id) {
		return ANIMATIONS.containsKey(id);
	}

	/**
	 * Load animations using ResourceManager
	 * Internal use only!
	 */
	@Override
	public void method_14491(class_3300 manager) {
		ANIMATIONS.clear();

		for (var resource : manager.method_14488("player_animations", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet()) {
			String namespace = resource.getKey().method_12836();
			try (InputStream is = resource.getValue().method_14482()) {
				for (var entry : UniversalAnimLoader.loadAnimations(is).entrySet()) {
					ANIMATIONS.put(class_2960.method_60655(namespace, entry.getKey()), entry.getValue());
				}
			} catch (Exception e) {
				PlayerAnimLib.LOGGER.error("Player Animation Library failed to load animation {} because:", resource.getKey(), e);
			}
		}
	}

	@Override
	public @NotNull CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
		return CompletableFuture.runAsync(() -> method_14491(resourceManager), backgroundExecutor).thenCompose(preparationBarrier::method_18352);
	}
}
