/*
 * MIT License
 *
 * Copyright (c) 2022 KosmX
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.zigythebird.playeranim.mixin.firstPerson;

import com.zigythebird.playeranim.accessors.IAnimatedPlayer;
import com.zigythebird.playeranim.animation.PlayerAnimManager;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_572;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_970.class, priority = 2000)
@SuppressWarnings("rawtypes")
public abstract class HumanoidArmorLayerMixin<T extends class_1309, A extends class_572<T>> {
    @Inject(method = "setPartVisibility", at = @At("HEAD"), cancellable = true)
    private void modifyArmorVisibility(A humanoidModel, class_1304 equipmentSlot, CallbackInfo ci) {
        PlayerAnimManager emote = ((IAnimatedPlayer) class_310.method_1551().field_1724).playerAnimLib$getAnimManager();
        if (emote.isActive() && emote.getFirstPersonMode() == FirstPersonMode.THIRD_PERSON_MODEL && FirstPersonMode.isFirstPersonPass()) {
            humanoidModel.method_2805(false);
            if (equipmentSlot == class_1304.field_6174 && emote.getFirstPersonConfiguration().isShowArmor()) {
                humanoidModel.field_3401.field_3665 = emote.getFirstPersonConfiguration().isShowRightArm();
                humanoidModel.field_27433.field_3665 = emote.getFirstPersonConfiguration().isShowLeftArm();
            }
            ci.cancel();
        }
    }
}
