/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class NoisiumConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean noiseChunkGenerator = true;
    public boolean generationShapeConfig = true;
    public boolean chunkSection = true;
    public boolean chainedBlockSource = true;
    public boolean chunkNoiseSamplerInterpolation = true;
    public boolean useGuiGraphics = true;
    private static NoisiumConfig INSTANCE = new NoisiumConfig();

    public static NoisiumConfig get() {
        return INSTANCE;
    }

    public static void loadFromResource(Logger logger) {
        try (InputStream in = NoisiumConfig.class.getResourceAsStream("/noisium-config.json");){
            if (in == null) {
                logger.debug("Noisium config resource not found, using defaults.");
                return;
            }
            try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
                INSTANCE = (NoisiumConfig)GSON.fromJson((Reader)r, NoisiumConfig.class);
                logger.info("Loaded Noisium config from resource");
            }
        }
        catch (Exception e) {
            logger.warn("Failed to load Noisium config, using defaults", (Throwable)e);
        }
    }

    private static void loadFromResourceInternal() {
        block13: {
            try (InputStream in = NoisiumConfig.class.getResourceAsStream("/noisium-config.json");){
                if (in == null) break block13;
                try (InputStreamReader r = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    INSTANCE = (NoisiumConfig)GSON.fromJson((Reader)r, NoisiumConfig.class);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void update(boolean noiseChunkGenerator, boolean generationShapeConfig, boolean chunkSection, boolean chainedBlockSource, boolean chunkNoiseSamplerInterpolation, boolean useGuiGraphics) {
        this.noiseChunkGenerator = noiseChunkGenerator;
        this.generationShapeConfig = generationShapeConfig;
        this.chunkSection = chunkSection;
        this.chainedBlockSource = chainedBlockSource;
        this.chunkNoiseSamplerInterpolation = chunkNoiseSamplerInterpolation;
        this.useGuiGraphics = useGuiGraphics;
    }

    static {
        NoisiumConfig.loadFromResourceInternal();
    }
}

