/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.mixin;

import io.github.steveplays28.noisium.Noisium;
import io.github.steveplays28.noisium.config.NoisiumConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.levelgen.NoiseChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseChunk.class})
public abstract class ChunkNoiseSamplerMixin {
    @Shadow
    private List<?> interpolators;
    @Unique
    private static boolean noisium$loggingEnabled = false;
    @Unique
    private static boolean noisium$optimizationEnabled = true;
    @Unique
    private static long noisium$interpolateXCalls = 0L;
    @Unique
    private static long noisium$interpolateYCalls = 0L;
    @Unique
    private static long noisium$interpolateZCalls = 0L;
    @Unique
    private static long noisium$quarterStepCount = 0L;
    @Unique
    private static long noisium$optimizedCallCount = 0L;
    @Unique
    private static long noisium$nonOptimizedCallCount = 0L;

    @Inject(method={"updateForX(ID)V"}, at={@At(value="HEAD")})
    public void noisium$logInterpolateX(int blockX, double deltaX, CallbackInfo ci) {
        if (noisium$loggingEnabled && ++noisium$interpolateXCalls % 1000L == 0L) {
            Noisium.LOGGER.info("interpolateX called {} times (blockX={}, deltaX={})", new Object[]{noisium$interpolateXCalls, blockX, deltaX});
        }
    }

    @Inject(method={"updateForY(ID)V"}, at={@At(value="HEAD")})
    public void noisium$logInterpolateY(int blockY, double deltaY, CallbackInfo ci) {
        if (noisium$loggingEnabled && ++noisium$interpolateYCalls % 1000L == 0L) {
            Noisium.LOGGER.info("interpolateY called {} times (blockY={}, deltaY={})", new Object[]{noisium$interpolateYCalls, blockY, deltaY});
        }
    }

    @Inject(method={"updateForZ(ID)V"}, at={@At(value="HEAD")})
    public void noisium$logInterpolateZ(int blockZ, double deltaZ, CallbackInfo ci) {
        ++noisium$interpolateZCalls;
        if (deltaZ == 0.0 || deltaZ == 0.25 || deltaZ == 0.5 || deltaZ == 0.75 || deltaZ == 1.0) {
            ++noisium$quarterStepCount;
        }
        if (noisium$loggingEnabled && noisium$interpolateZCalls % 1000L == 0L) {
            Noisium.LOGGER.info("interpolateZ called {} times (blockZ={}, deltaZ={}, quarter-steps: {})", new Object[]{noisium$interpolateZCalls, blockZ, deltaZ, noisium$quarterStepCount});
        }
    }

    @Inject(method={"updateForZ(ID)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void noisium$optimizeQuarterStepZ(int blockZ, double deltaZ, CallbackInfo ci) {
        ++noisium$interpolateZCalls;
        if (deltaZ == 0.0 || deltaZ == 0.25 || deltaZ == 0.5 || deltaZ == 0.75 || deltaZ == 1.0) {
            ++noisium$quarterStepCount;
        }
        if (noisium$loggingEnabled && noisium$interpolateZCalls % 1000L == 0L) {
            Noisium.LOGGER.info("[OPTIMIZED] interpolateZ called {} times (blockZ={}, deltaZ={}, quarter-steps: {})", new Object[]{noisium$interpolateZCalls, blockZ, deltaZ, noisium$quarterStepCount});
        }
        if (noisium$optimizationEnabled && deltaZ == 0.0) {
            if (noisium$loggingEnabled && (++noisium$optimizedCallCount <= 10L || noisium$optimizedCallCount % 1000L == 0L)) {
                Noisium.LOGGER.info("ChunkNoiseSampler optimization: Skipping interpolateZ for deltaZ=0.0 (call #{})", (Object)noisium$optimizedCallCount);
            }
            ci.cancel();
        }
    }

    @Unique
    private static double noisium$optimizedLerp(double delta, double start, double end) {
        int deltaInt = (int)(delta * 4.0 + 0.5);
        switch (deltaInt) {
            case 0: {
                return start;
            }
            case 1: {
                return start * 0.75 + end * 0.25;
            }
            case 2: {
                return start * 0.5 + end * 0.5;
            }
            case 3: {
                return start * 0.25 + end * 0.75;
            }
            case 4: {
                return end;
            }
        }
        return Math.fma(delta, end - start, start);
    }

    @Inject(method={"updateForZ(ID)V"}, at={@At(value="RETURN")})
    public void noisium$debugInterpolatorStructure(int blockZ, double deltaZ, CallbackInfo ci) {
        if (noisium$loggingEnabled && noisium$interpolateZCalls % 10000L == 0L && this.interpolators != null && !this.interpolators.isEmpty()) {
            Object firstInterpolator = this.interpolators.get(0);
            Noisium.LOGGER.info("ChunkNoiseSampler has {} interpolators. First interpolator type: {} (methods: {})", new Object[]{this.interpolators.size(), firstInterpolator.getClass().getSimpleName(), Arrays.toString(firstInterpolator.getClass().getMethods())});
        }
    }

    @Unique
    private static void noisium$logInterpolationStats() {
        Noisium.LOGGER.info("=== ChunkNoiseSampler Interpolation Statistics ===");
        Noisium.LOGGER.info("interpolateX calls: {}", (Object)noisium$interpolateXCalls);
        Noisium.LOGGER.info("interpolateY calls: {}", (Object)noisium$interpolateYCalls);
        Noisium.LOGGER.info("interpolateZ calls: {} (quarter-steps: {})", (Object)noisium$interpolateZCalls, (Object)noisium$quarterStepCount);
        Noisium.LOGGER.info("Total interpolation calls: {}", (Object)(noisium$interpolateXCalls + noisium$interpolateYCalls + noisium$interpolateZCalls));
        if (noisium$interpolateZCalls > 0L) {
            double quarterStepPercentage = (double)noisium$quarterStepCount / (double)noisium$interpolateZCalls * 100.0;
            Noisium.LOGGER.info("Quarter-step optimization potential: {:.1f}%", (Object)quarterStepPercentage);
        }
    }

    static {
        noisium$optimizationEnabled = NoisiumConfig.get().chunkNoiseSamplerInterpolation;
        Noisium.LOGGER.info("ChunkNoiseSampler interpolation optimization loaded - using @Inject for interpolateZ (enabled: {})", (Object)noisium$optimizationEnabled);
        noisium$loggingEnabled = Boolean.getBoolean("noisium.debug.interpolation");
        if (noisium$loggingEnabled) {
            Noisium.LOGGER.warn("ChunkNoiseSampler detailed interpolation logging is ENABLED - this might impact performance!");
        }
    }
}

