/*
 * Decompiled with CFR 0.152.
 */
package de.tontito.coolnightsky;

import de.tontito.coolnightsky.utils.Metrics;
import de.tontito.coolnightsky.utils.MyBukkit;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class CoolNightSky
extends JavaPlugin {
    private MyBukkit mybukkit;
    private Object generalTask;
    public final String VERSION = this.getDescription().getVersion();
    private Random rand = new Random();

    public void onEnable() {
        String version = Bukkit.getServer().getName().toUpperCase();
        this.mybukkit = new MyBukkit(this);
        this.startMetrics();
        this.mybukkit.UpdateChecker(true);
        this.generalTask = this.mybukkit.runTaskTimer(null, null, null, () -> this.manageSkyObjects(), 200L, 20L);
        this.getLogger().info("Version " + this.VERSION + " enabled on " + version + "!");
    }

    public void onDisable() {
        if (this.generalTask != null) {
            this.mybukkit.cancelTask(this.generalTask);
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 26452);
        }
        catch (Exception e) {
            this.getLogger().info(ChatColor.RED + " Failed to register into Bstats");
        }
    }

    public void manageSkyObjects() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location location = player.getLocation();
            World world = location.getWorld();
            String myWorld = world.getName();
            if (myWorld.endsWith("_nether") || myWorld.endsWith("_end")) continue;
            double size = this.rand.nextDouble() * 10000.0;
            int dia = (int)(world.getFullTime() / 24000L % 365L);
            if (size < 9980.0 && (world.getTime() < 13000L || world.getTime() > 23000L) || size < 8000.0 && world.hasStorm()) continue;
            long moonPhase = world.getFullTime() / 24000L % 8L;
            if (size < 1500.0 && (moonPhase < 2L || moonPhase > 6L)) continue;
            double w = 100.0 * Math.sqrt(this.rand.nextDouble());
            double angle = Math.PI * 2 * this.rand.nextDouble();
            double x = w * Math.cos(angle);
            double range = Math.max(0, 100);
            double z = w * Math.sin(angle);
            double y = size > 9500.0 ? Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 30.0) : (dia == 348 || dia == 321 || dia == 294 || dia == 224 || dia == 125 ? Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 30.0) : (dia > 318 || dia < 334 ? Math.max(this.rand.nextDouble() * range + 100.0, location.getY() + 40.0) : Math.max(this.rand.nextDouble() * range + 120.0, location.getY() + 50.0)));
            if (size > 9980.0) {
                y -= 10.0;
            }
            Location startLocation = new Location(world, location.getX() + x, y, location.getZ() + z);
            Vector direction = new Vector(this.rand.nextDouble() * 2.2 - 1.0, this.rand.nextDouble() * -0.7, this.rand.nextDouble() * 2.2 - 1.0);
            direction.normalize();
            double speed = this.rand.nextDouble() * 2.0 + 0.8;
            if (y > location.getY() + 50.0 && size < 9800.0) {
                this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.FIREWORK, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 1L);
            }
            if (dia == 321 || dia == 224 || size >= 9800.0) {
                this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.LAVA, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 100L);
            }
            if (dia != 348 && dia != 321 && dia != 294 && dia != 224 && dia != 125) continue;
            this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.FLAME, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 40L);
        }
    }
}

