/*
 * Decompiled with CFR 0.152.
 */
package de.tontito.coolnightsky;

import de.tontito.coolnightsky.Events.Events;
import de.tontito.coolnightsky.utils.Metrics;
import de.tontito.coolnightsky.utils.MyBukkit;
import java.util.Hashtable;
import java.util.Random;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class CoolNightSky
extends JavaPlugin {
    private MyBukkit mybukkit;
    private Object generalTask;
    public final String VERSION = this.getDescription().getVersion();
    private PluginManager pm = Bukkit.getPluginManager();
    private Random rand = new Random();
    private Hashtable<UUID, Object[]> playerObjects = new Hashtable();
    private int seconds = 0;

    public void onEnable() {
        String version = Bukkit.getServer().getName().toUpperCase();
        this.mybukkit = new MyBukkit(this);
        this.pm.registerEvents((Listener)new Events(this), (Plugin)this);
        this.startMetrics();
        this.mybukkit.UpdateChecker(true);
        this.generalTask = this.mybukkit.runTaskTimer(null, null, null, () -> this.manageSkyObjects(), 100L, 20L);
        this.getLogger().info("Version " + this.VERSION + " enabled on " + version + "!");
    }

    public void onDisable() {
        if (this.generalTask != null) {
            this.mybukkit.cancelTask(this.generalTask);
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 26452);
        }
        catch (Exception e) {
            this.getLogger().info(ChatColor.RED + " Failed to register into Bstats");
        }
    }

    public synchronized void addPlayerObjects(Player player) {
        this.playerObjects.put(player.getUniqueId(), new Object[14]);
    }

    public synchronized void removePlayerObjects(Player player) {
        this.playerObjects.remove(player.getUniqueId());
    }

    public void manageSkyObjects() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        ++this.seconds;
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean night;
            Location location = player.getLocation();
            World world = location.getWorld();
            String myWorld = world.getName();
            if (world.getHighestBlockYAt(location) > location.getBlockY() + 10) {
                return;
            }
            boolean bl = night = world.getTime() >= 13000L && world.getTime() <= 23000L;
            if (myWorld.endsWith("_nether") || myWorld.endsWith("_end")) continue;
            if (night && !world.hasStorm() && player.getViewDistance() < 16) {
                player.setViewDistance(16);
            } else if ((!night || world.hasStorm()) && player.getViewDistance() == 16) {
                player.setViewDistance(8);
            }
            double size = this.rand.nextDouble() * 10000.0;
            int dia = (int)(world.getFullTime() / 24000L % 365L);
            long moonPhase = world.getFullTime() / 24000L % 8L;
            if (night) {
                this.Constelations(world, player, location, dia, moonPhase);
            }
            double event = this.MeteorShowerEvent(world, player, dia);
            if (size < 9980.0 && !night || size < 8000.0 && world.hasStorm()) continue;
            this.MeteorShower(world, player, location, size, event, moonPhase);
        }
    }

    private double MeteorShowerEvent(World world, Player player, int dia) {
        double eventDay = 0.0;
        String appendText = "!";
        if (dia == 348) {
            appendText = " It's Geminids peak";
            eventDay = 1.0;
        } else if (dia == 321) {
            appendText = " It's Leonids peak";
            eventDay = 2.0;
        } else if (dia == 294) {
            appendText = " It's Orionids peak";
            eventDay = 3.0;
        } else if (dia == 224) {
            appendText = " It's Perseids peak";
            eventDay = 4.0;
        } else if (dia == 212) {
            appendText = " It's Delta Aquariids and Alpha Capricornids peak";
            eventDay = 5.0;
        } else if (dia == 125) {
            appendText = " It's Eta Aquariids peak";
            eventDay = 6.0;
        } else if (dia == 113) {
            appendText = " It's Lyrids peak";
            eventDay = 7.0;
        } else if (dia == 4) {
            appendText = " It's Quadrantids peak";
            eventDay = 8.0;
        } else if (dia >= 344 && dia < 352) {
            appendText = " It's Geminids period";
            eventDay = 1.5;
        } else if (dia >= 220 && dia < 230) {
            appendText = " It's Perseids period";
            eventDay = 4.5;
        } else if (dia >= 1 && dia < 8) {
            appendText = " It's Quadrantids period";
            eventDay = 8.5;
        }
        if (world.getTime() >= 12960L && world.getTime() <= 13040L) {
            if (world.hasStorm()) {
                appendText = ", but the Weather sucks..";
            }
            this.mybukkit.sendActionBar(player, "Starting night of #" + dia + "." + appendText);
        }
        return eventDay;
    }

    private void MeteorShower(World world, Player player, Location location, double size, double event, long moonPhase) {
        double y = 0.0;
        double w = 100.0 * Math.sqrt(this.rand.nextDouble());
        double angle = Math.PI * 2 * this.rand.nextDouble();
        double x = w * Math.cos(angle);
        double range = Math.max(0, 90);
        double z = w * Math.sin(angle);
        if (size > 9500.0) {
            y = Math.max(this.rand.nextDouble() * range + 70.0, location.getY() + 50.0);
        } else if (event == 0.0) {
            y = Math.max(this.rand.nextDouble() * range + 90.0, location.getY() + 50.0);
        } else if ((double)((int)event) != event) {
            size += 1000.0;
            y = Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 50.0);
        } else if ((double)((int)event) == event) {
            size += 2000.0;
            y = Math.max(this.rand.nextDouble() * range + 70.0, location.getY() + 50.0);
        }
        y = Math.min(y, location.getY() + 80.0);
        if (z > player.getLocation().getZ() + 100.0) {
            z -= 50.0;
        } else if (z < player.getLocation().getZ() - 100.0) {
            z += 50.0;
        }
        if (x > player.getLocation().getX() + 100.0) {
            x -= 50.0;
        } else if (x < player.getLocation().getX() - 100.0) {
            x += 50.0;
        }
        if (size < 7000.0 && (moonPhase < 2L || moonPhase > 5L)) {
            return;
        }
        if (size < 2000.0) {
            return;
        }
        Location startLocation = new Location(world, location.getX() + x, y, location.getZ() + z);
        Vector direction = new Vector(this.rand.nextDouble() * 2.2 - 1.0, -0.4, this.rand.nextDouble() * 2.2 - 1.0);
        direction.normalize();
        double speed = this.rand.nextDouble() * 1.6 + 1.2 * (y / 80.0);
        int random = (int)(8.0 * this.rand.nextDouble() % 8.0);
        if (random == 4 || random == 5 || random == 6 || random == 8) {
            world.spawnParticle(Particle.FIREWORK, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 1 || random == 2) {
            world.spawnParticle(Particle.LAVA, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 0 || random == 3) {
            world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 7) {
            world.spawnParticle(Particle.CHERRY_LEAVES, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if ((int)event == 1) {
            if (random == 0) {
                world.spawnParticle(Particle.END_ROD, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 4) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
            if (random == 0) {
                world.spawnParticle(Particle.TOTEM_OF_UNDYING, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
            if (random == 3) {
                world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 5) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 6) {
            startLocation.add(0.0, -15.0, 0.0);
            if (random == 0) {
                world.spawnParticle(Particle.END_ROD, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 8) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed * 2.0, null, true);
            }
            if (random == 3 || random == 4) {
                world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        }
    }

    private void MoonEfects(World world, Player player, Location location, int dia, long moonPhase) {
    }

    private void Constelations(World world, Player player, Location location, int dia, long moonPhase) {
        int posicaoLua = (int)((double)(world.getTime() - 18000L) / 10000.0 * 180.0);
        double x = location.getX() - (double)posicaoLua;
        double y = location.getY() - -60.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0);
        double z = location.getZ();
        Location startLocation = new Location(world, x, y, z);
        Object[] playerMainObject = this.playerObjects.get(player.getUniqueId());
        this.constelationOrion(world, player, startLocation, moonPhase, playerMainObject);
    }

    private void constelationOrion(World world, Player player, Location location, long moonPhase, Object[] playerMainObject) {
        Location loc = location.clone();
        loc.add(0.0, 10.0, 220.0);
        Location oldLocation = null;
        Object[][] Orion = (Object[][])playerMainObject[0];
        if (Orion == null) {
            playerMainObject[0] = Orion = new Object[15][2];
        }
        if (Orion[0][0] != null) {
            oldLocation = (Location)Orion[0][1];
        }
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        this.DrawStar(world, player, Orion, loc, 2, 1, 0);
        loc.add(-22.0, 22.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 4, 0, 1);
        loc.add(32.0, 4.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 2);
        loc.add(-2.0, 5.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 3);
        loc.add(-1.0, 6.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 4);
        loc.add(36.0, 8.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 4, 4, 5);
        loc.add(-8.0, 20.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 1, 1, 6);
        loc.add(-11.0, -4.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 2, 1, 7);
    }

    private void constelationTaurus(World world, Player player, Location location, long moonPhase, Object[] playerMainObject) {
        Location loc = location.clone();
        Location oldLocation = null;
        Object[][] Orion = (Object[][])playerMainObject[0];
        if (Orion == null) {
            playerMainObject[0] = Orion = new Object[15][2];
        }
        if (Orion[0][0] != null) {
            oldLocation = (Location)Orion[0][1];
        }
        loc.set(96.0, 62.0, 200.0).add(location);
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        this.DrawStar(world, player, Orion, loc, 2, 1, 0);
        loc.set(62.0, 105.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 0, 1);
        loc.set(158.0, 90.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 3, 1, 2);
        loc.set(49.0, 79.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 3, 1, 3);
        loc.set(109.0, 60.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 3, 3, 4);
        loc.set(55.0, 86.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 4, 3, 5);
        loc.set(99.0, 59.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 1, 4, 6);
        loc.set(80.0, 42.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 4, 7);
        loc.set(161.0, 90.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 4, 8);
        loc.set(120.0, 59.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 5, 9);
        loc.set(163.0, 90.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 5, 10);
        loc.set(147.0, 92.0, 200.0).add(location);
        this.DrawStar(world, player, Orion, loc, 2, 5, 11);
    }

    private void DrawStar(World world, Player player, Object[][] constelation, Location newlocation, int size, int colourComposition, int pos) {
        Location oldLocation;
        Object myblock;
        Location location = newlocation.clone();
        if (constelation[pos][0] != null) {
            myblock = (BlockData)constelation[pos][0];
            oldLocation = (Location)constelation[pos][1];
        } else {
            myblock = colourComposition == 0 ? Material.SEA_LANTERN.createBlockData() : (colourComposition == 1 ? Material.VERDANT_FROGLIGHT.createBlockData() : (colourComposition == 2 ? Material.PEARLESCENT_FROGLIGHT.createBlockData() : (colourComposition == 3 ? Material.OCHRE_FROGLIGHT.createBlockData() : (colourComposition == 4 ? Material.SHROOMLIGHT.createBlockData() : (colourComposition == 5 ? Material.LAVA.createBlockData() : null)))));
            constelation[pos][0] = myblock;
            oldLocation = null;
        }
        Location finalOldLocation = oldLocation;
        this.mybukkit.runTaskLater(player, null, null, () -> CoolNightSky.lambda$DrawStar$1(finalOldLocation, player, location, world, (BlockData)myblock), 1L);
        constelation[pos][1] = location;
    }

    private static /* synthetic */ void lambda$DrawStar$1(Location finalOldLocation, Player player, Location location, World world, BlockData myblock) {
        if (finalOldLocation != null) {
            player.sendBlockChange(finalOldLocation, finalOldLocation.getBlock().getBlockData());
        }
        if (location.getY() < player.getLocation().getY() || world.hasStorm()) {
            return;
        }
        player.sendBlockChange(location, myblock);
    }
}

