/*
 * Decompiled with CFR 0.152.
 */
package de.tontito.coolnightsky;

import de.tontito.coolnightsky.utils.Metrics;
import de.tontito.coolnightsky.utils.MyBukkit;
import java.util.Hashtable;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class CoolNightSky
extends JavaPlugin {
    private MyBukkit mybukkit;
    private Object generalTask;
    public final String VERSION = this.getDescription().getVersion();
    private Random rand = new Random();
    private Hashtable playerObjects = new Hashtable();
    private int seconds = 0;

    public void onEnable() {
        String version = Bukkit.getServer().getName().toUpperCase();
        this.mybukkit = new MyBukkit(this);
        this.startMetrics();
        this.mybukkit.UpdateChecker(true);
        this.generalTask = this.mybukkit.runTaskTimer(null, null, null, () -> this.manageSkyObjects(), 100L, 20L);
        this.getLogger().info("Version " + this.VERSION + " enabled on " + version + "!");
    }

    public void onDisable() {
        if (this.generalTask != null) {
            this.mybukkit.cancelTask(this.generalTask);
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 26452);
        }
        catch (Exception e) {
            this.getLogger().info(ChatColor.RED + " Failed to register into Bstats");
        }
    }

    public void manageSkyObjects() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        ++this.seconds;
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean night;
            Location location = player.getLocation();
            World world = location.getWorld();
            String myWorld = world.getName();
            if (world.getHighestBlockYAt(location) > location.getBlockY() + 10) {
                return;
            }
            boolean bl = night = world.getTime() >= 13000L && world.getTime() <= 23000L;
            if (myWorld.endsWith("_nether") || myWorld.endsWith("_end")) continue;
            if (night && !world.hasStorm() && player.getViewDistance() < 16) {
                player.setViewDistance(16);
            } else if ((!night || world.hasStorm()) && player.getViewDistance() == 16) {
                player.setViewDistance(8);
            }
            double size = this.rand.nextDouble() * 10000.0;
            int dia = (int)(world.getFullTime() / 24000L % 365L);
            long moonPhase = world.getFullTime() / 24000L % 8L;
            if (night) {
                this.Constelations(world, player, location, dia, moonPhase);
            }
            if (size < 9980.0 && !night || size < 8000.0 && world.hasStorm()) continue;
            this.MeteorShower(world, location, size, dia, moonPhase);
        }
    }

    private void MeteorShower(World world, Location location, double size, int dia, long moonPhase) {
        double y;
        double w = 100.0 * Math.sqrt(this.rand.nextDouble());
        double angle = Math.PI * 2 * this.rand.nextDouble();
        double x = w * Math.cos(angle);
        double range = Math.max(0, 100);
        double z = w * Math.sin(angle);
        if (size > 9500.0) {
            y = Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 30.0);
        } else if (dia == 348 || dia == 321 || dia == 294 || dia == 224 || dia == 125) {
            size += 4000.0;
            y = Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 30.0);
        } else if (dia > 318 || dia < 334) {
            size += 2000.0;
            y = Math.max(this.rand.nextDouble() * range + 100.0, location.getY() + 40.0);
        } else {
            y = Math.max(this.rand.nextDouble() * range + 120.0, location.getY() + 50.0);
        }
        if (size > 9980.0) {
            y -= 10.0;
        }
        if (size < 7000.0 && (moonPhase < 2L || moonPhase > 5L)) {
            return;
        }
        if (size < 2000.0) {
            return;
        }
        Location startLocation = new Location(world, location.getX() + x, y, location.getZ() + z);
        Vector direction = new Vector(this.rand.nextDouble() * 2.2 - 1.0, this.rand.nextDouble() * -0.7, this.rand.nextDouble() * 2.2 - 1.0);
        direction.normalize();
        double speed = this.rand.nextDouble() * 2.0 + 0.8;
        if (y > location.getY() + 50.0 && size < 9800.0) {
            this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.FIREWORK, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 1L);
        }
        if (dia == 321 || dia == 224 || size >= 9800.0) {
            this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.LAVA, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 100L);
        }
        if (dia == 348 || dia == 321 || dia == 294 || dia == 224 || dia == 125) {
            this.mybukkit.runTaskLater(null, startLocation, null, () -> world.spawnParticle(Particle.FLAME, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true), 40L);
        }
    }

    private void MoonEfects(World world, Player player, Location location, int dia, long moonPhase) {
    }

    private void Constelations(World world, Player player, Location location, int dia, long moonPhase) {
        int posicaoLua = (int)((double)(world.getTime() - 18000L) / 10000.0 * 180.0);
        double x = location.getX() - (double)posicaoLua;
        double y = location.getY() - -60.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0);
        double z = location.getZ();
        Location startLocation = new Location(world, x, y, z);
        this.constelationOrion(world, player, startLocation, moonPhase);
    }

    private void constelationOrion(World world, Player player, Location location, long moonPhase) {
        Object[][] Orion;
        Location loc = location.clone();
        loc.add(0.0, 10.0, 220.0);
        Location oldLocation = null;
        if (this.playerObjects.get(player) == null) {
            Orion = new Object[15][2];
            this.playerObjects.put(player, Orion);
        } else {
            Orion = (Object[][])this.playerObjects.get(player);
        }
        if (Orion[0][0] != null) {
            oldLocation = (Location)Orion[0][1];
        }
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        int difX = location.getBlockX() - loc.getBlockX();
        int difZ = location.getBlockZ() - loc.getBlockZ();
        this.DrawStar(world, player, loc, 2, 1, 0);
        loc.add(-22.0, 22.0, 0.0);
        this.DrawStar(world, player, loc, 4, 0, 1);
        loc.add(32.0, 4.0, 0.0);
        this.DrawStar(world, player, loc, 3, 1, 2);
        loc.add(-2.0, 5.0, 0.0);
        this.DrawStar(world, player, loc, 3, 1, 3);
        loc.add(-1.0, 6.0, 0.0);
        this.DrawStar(world, player, loc, 3, 1, 4);
        loc.add(36.0, 8.0, 0.0);
        this.DrawStar(world, player, loc, 4, 4, 5);
        loc.add(-8.0, 20.0, 0.0);
        this.DrawStar(world, player, loc, 1, 1, 6);
        loc.add(-11.0, -4.0, 0.0);
        this.DrawStar(world, player, loc, 2, 1, 7);
    }

    private void DrawStar(World world, Player player, Location newlocation, int size, int colourComposition, int pos) {
        Location oldLocation;
        Object myblock;
        Object[][] Orion;
        Location location = newlocation.clone();
        if (this.playerObjects.get(player) == null) {
            Orion = new Object[15][2];
            this.playerObjects.put(player, Orion);
        } else {
            Orion = (Object[][])this.playerObjects.get(player);
        }
        if (Orion[pos][0] != null) {
            myblock = (BlockData)Orion[pos][0];
            oldLocation = (Location)Orion[pos][1];
        } else {
            myblock = colourComposition == 0 ? Material.SEA_LANTERN.createBlockData() : (colourComposition == 1 ? Material.VERDANT_FROGLIGHT.createBlockData() : (colourComposition == 2 ? Material.PEARLESCENT_FROGLIGHT.createBlockData() : (colourComposition == 3 ? Material.OCHRE_FROGLIGHT.createBlockData() : (colourComposition == 4 ? Material.SHROOMLIGHT.createBlockData() : (colourComposition == 5 ? Material.LAVA.createBlockData() : null)))));
            Orion[pos][0] = myblock;
            oldLocation = null;
        }
        Location finalOldLocation = oldLocation;
        this.mybukkit.runTaskLater(player, null, null, () -> CoolNightSky.lambda$DrawStar$4(finalOldLocation, player, location, world, (BlockData)myblock), 1L);
        Orion[pos][1] = location;
    }

    private static /* synthetic */ void lambda$DrawStar$4(Location finalOldLocation, Player player, Location location, World world, BlockData myblock) {
        if (finalOldLocation != null) {
            player.sendBlockChange(finalOldLocation, finalOldLocation.getBlock().getBlockData());
        }
        if (location.getY() < player.getLocation().getY() || world.hasStorm()) {
            return;
        }
        player.sendBlockChange(location, myblock);
    }
}

