/*
 * Decompiled with CFR 0.152.
 */
package de.tontito.coolnightsky.utils;

import de.tontito.coolnightsky.CoolNightSky;
import de.tontito.coolnightsky.utils.compatibility.MyBukkitPaper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.kyori.adventure.text.format.NamedTextColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;

public class MyBukkit {
    private CoolNightSky main;
    private boolean isFoliaBased;
    private boolean isPaperBased;
    private boolean isInformed = false;
    private boolean starting = true;
    private MyBukkitPaper myBukkitPaper;

    public MyBukkit(CoolNightSky main) {
        this.main = main;
        Class<?> classCheck = null;
        try {
            classCheck = Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
        }
        catch (Exception e) {
            classCheck = null;
        }
        this.isFoliaBased = classCheck != null;
        try {
            classCheck = Class.forName("io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorageAccess");
        }
        catch (Exception e) {
            classCheck = null;
        }
        boolean bl = this.isPaperBased = classCheck != null;
        if (this.isPaperBased) {
            this.myBukkitPaper = new MyBukkitPaper();
        }
    }

    public boolean isFolia() {
        return this.isFoliaBased;
    }

    public boolean isPaper() {
        return this.isPaperBased;
    }

    public Object runTask(Player player, Location local, Entity entity, Runnable myrun) {
        if (this.isFoliaBased) {
            if (player != null) {
                return player.getScheduler().run((Plugin)this.main, st -> myrun.run(), null);
            }
            if (local != null) {
                return Bukkit.getServer().getRegionScheduler().run((Plugin)this.main, local, st -> myrun.run());
            }
            if (entity != null) {
                return entity.getScheduler().run((Plugin)this.main, st -> myrun.run(), null);
            }
            return Bukkit.getServer().getGlobalRegionScheduler().run((Plugin)this.main, st -> myrun.run());
        }
        return Bukkit.getScheduler().runTask((Plugin)this.main, myrun);
    }

    public Object runTaskLater(Player player, Location local, Entity entity, Runnable myrun, long delay) {
        if (this.isFoliaBased) {
            if (player != null) {
                return player.getScheduler().runDelayed((Plugin)this.main, st -> myrun.run(), null, delay);
            }
            if (local != null) {
                return Bukkit.getServer().getRegionScheduler().runDelayed((Plugin)this.main, local, st -> myrun.run(), delay);
            }
            if (entity != null) {
                return entity.getScheduler().runDelayed((Plugin)this.main, st -> myrun.run(), null, delay);
            }
            return Bukkit.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.main, st -> myrun.run(), delay);
        }
        return Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.main, myrun, delay);
    }

    public Object runTaskTimer(Player player, Location local, Entity entity, Runnable myrun, long delay, long period) {
        if (this.isFoliaBased) {
            if (player != null) {
                return player.getScheduler().runAtFixedRate((Plugin)this.main, st -> myrun.run(), null, delay, period);
            }
            if (local != null) {
                return Bukkit.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.main, local, st -> myrun.run(), delay, period);
            }
            if (entity != null) {
                return entity.getScheduler().runAtFixedRate((Plugin)this.main, st -> myrun.run(), null, delay, period);
            }
            return Bukkit.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.main, st -> myrun.run(), delay, period);
        }
        return Bukkit.getServer().getScheduler().runTaskTimer((Plugin)this.main, myrun, delay, period);
    }

    public void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        if (this.isFoliaBased) {
            ((ScheduledTask)task).cancel();
        } else {
            ((BukkitTask)task).cancel();
        }
    }

    public boolean isCancelled(Object task) {
        if (task == null) {
            return true;
        }
        if (this.isFoliaBased) {
            return ((ScheduledTask)task).isCancelled();
        }
        return ((BukkitTask)task).isCancelled();
    }

    public boolean isOwnedby(Entity entity, Location local, Block block) {
        if (this.isFoliaBased) {
            if (entity != null) {
                return Bukkit.isOwnedByCurrentRegion((Entity)entity);
            }
            if (local != null) {
                return Bukkit.isOwnedByCurrentRegion((Location)local);
            }
            if (block != null) {
                return Bukkit.isOwnedByCurrentRegion((Block)block);
            }
        }
        return true;
    }

    public static ArmorStand startLabel(Location location) {
        Location loc = location.clone();
        ArmorStand hologram = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        hologram.setVisible(false);
        hologram.setCustomNameVisible(true);
        hologram.setGravity(false);
        loc.add(0.0, 2.0, 0.0);
        return hologram;
    }

    public void showArenaLabel(ArmorStand armor1, Location location, String message, boolean visible, boolean shutdown) {
        if (armor1 == null && visible) {
            Location myLocation = location.clone();
            ArmorStand[] armor = new ArmorStand[]{armor1};
            this.runTaskLater(null, myLocation, null, () -> {
                armor[0] = (ArmorStand)myLocation.getWorld().spawnEntity(myLocation, EntityType.ARMOR_STAND);
                armor[0].setVisible(false);
                AttributeInstance instance = armor[0].getAttribute(Attribute.SCALE);
                if (instance != null) {
                    instance.setBaseValue(2.0);
                }
                if (this.isPaperBased) {
                    this.myBukkitPaper.hologramCustomName(armor[0], message);
                } else {
                    armor[0].setCustomName(message);
                }
                armor[0].setCustomNameVisible(true);
            }, 100L);
            return;
        }
        if (visible) {
            if (this.isPaperBased) {
                this.myBukkitPaper.hologramCustomName(armor1, message);
            } else {
                armor1.setCustomName(message);
            }
            armor1.setCustomNameVisible(true);
        } else if (armor1 != null) {
            if (shutdown) {
                armor1.remove();
            } else {
                ArmorStand finalA = armor1;
                this.runTaskLater(null, null, (Entity)armor1, () -> finalA.remove(), 1L);
            }
            armor1 = null;
        }
    }

    public void setMeta(ItemMeta meta, String text) {
        if (this.isPaperBased) {
            this.myBukkitPaper.metaDisplayName(meta, text);
        } else {
            meta.setDisplayName(text);
        }
    }

    public void setPlayerListName(Player player, String text) {
        if (this.isPaperBased) {
            this.myBukkitPaper.playerListName(player, text);
        } else {
            player.setPlayerListName(String.valueOf(ChatColor.WHITE) + player.getName());
        }
    }

    public void sendActionBar(Player player, String text) {
        if (this.isPaperBased) {
            this.myBukkitPaper.playerSendActionBar(player, text);
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)text));
        }
    }

    public void consoleSendMessage(String text, String textComponent, String color) {
        if (this.isPaper()) {
            this.myBukkitPaper.consoleSendMessage(text, textComponent, MyBukkit.getNamedTextColorFromString(color));
        } else {
            Bukkit.getConsoleSender().sendMessage(text + String.valueOf(ChatColor.valueOf((String)color)) + textComponent);
        }
    }

    public void teamAddEntity(Team myTeam, Player player) {
        if (this.isPaperBased) {
            myTeam.addEntity((Entity)player);
        } else {
            myTeam.addPlayer((OfflinePlayer)player);
        }
    }

    public void playerTeleport(Entity player, Location loc) {
        if (this.isPaperBased) {
            this.runTaskLater(null, null, player, () -> player.teleportAsync(loc), 5L);
        } else {
            player.teleport(loc);
        }
    }

    public void playerSetResourcePack(Player player, String resourse, String hash) {
        if (this.isPaperBased) {
            this.runTaskLater(player, null, null, () -> player.setResourcePack(resourse, hash), 40L);
        } else {
            player.setResourcePack(resourse);
        }
    }

    public void setRotation(Entity entity, float yaw) {
        if (this.isPaperBased) {
            entity.setRotation(entity.getLocation().getPitch(), entity.getLocation().getYaw() + yaw);
        } else {
            Location loc = entity.getLocation();
            loc.setYaw(loc.getYaw() + yaw);
            entity.teleport(loc);
        }
    }

    public void UpdateChecker(boolean loop) {
        String projectName = this.main.getDescription().getName();
        if (loop) {
            this.runTaskTimer(null, null, null, () -> this.runCheck(projectName), 5L, 288000L);
        } else {
            this.runTaskLater(null, null, null, () -> this.runCheck(projectName), 20L);
        }
    }

    private void runCheck(String projectName) {
        try {
            StringBuilder page = this.makeAsyncGetRequest("https://cld.pt/dl/download/51c19f75-8900-49f2-8e1b-a92256bf2d4a/bukkit.txt?download=true/");
            if (page != null && page.length() > 10) {
                String pagina = page.toString();
                int pointer = pagina.indexOf("project-file-name-container-" + projectName);
                pagina = pagina.substring(pointer);
                String tmp = pagina.substring(pagina.indexOf("https://cdn.modrinth.com/"));
                String version = tmp.substring(tmp.indexOf("data-name=\"") + 11).split("\"")[0];
                String url = tmp.split("\"")[0];
                String features = tmp.substring(tmp.indexOf("features=\"") + 10).split("\"")[0];
                this.promptUpdate(version, url, projectName, features);
            }
        }
        catch (Exception e) {
            String versionMessage = "[" + projectName + "] Connection exception: " + e.getMessage();
            String intColor = "RED";
            this.consoleSendMessage("[" + projectName + "]", versionMessage, intColor);
        }
    }

    private StringBuilder makeAsyncGetRequest(String url) {
        StringBuilder response = new StringBuilder();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.connect();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    response.append(line);
                    line = reader.readLine();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private void promptUpdate(String serverVersion, String Url, String projectName, String features) {
        Object versionMessage;
        String currentVersion;
        int versionStatus;
        String intColor = "GRAY";
        if (serverVersion == null) {
            String versionMessage2 = " Unknown error checking version";
            intColor = "RED";
            this.consoleSendMessage("[" + projectName + "]", versionMessage2, intColor);
            return;
        }
        String tmpServerVersion = null;
        if (serverVersion.split(" v").length > 1) {
            tmpServerVersion = serverVersion.split(" v")[1];
        }
        if (tmpServerVersion == null) {
            tmpServerVersion = serverVersion.split(" ")[1];
        }
        if ((versionStatus = this.checkGreater(serverVersion = tmpServerVersion, currentVersion = this.main.getDescription().getVersion())) == -1) {
            features = ((String)features).length() > 1 ? "\nFeaturing: " + ((String)features).replace("<br>", "\n") + "\n" : "";
            versionMessage = "[" + projectName + "]  NEW VERSION: " + serverVersion + (String)features + "Available at: " + Url;
            if (!this.isInformed) {
                for (Player myPlayer : this.main.getServer().getOnlinePlayers()) {
                    if (!myPlayer.isOp()) continue;
                    myPlayer.sendMessage(String.valueOf(ChatColor.GREEN) + (String)versionMessage);
                    this.isInformed = true;
                }
            }
            versionMessage = " THERE IS A NEW UPDATE AVAILABLE Version: " + serverVersion + " at: " + Url + "   " + (String)features;
            intColor = "GREEN";
        } else if (versionStatus == 0) {
            if (!this.starting) {
                return;
            }
            versionMessage = " You have the latest released version";
            intColor = "GREEN";
        } else if (versionStatus == 1) {
            if (!this.starting) {
                return;
            }
            versionMessage = " Congrats, you are testing a new version!";
            intColor = "YELLOW";
        } else {
            if (!this.starting) {
                return;
            }
            versionMessage = " Unknown error checking version (" + versionStatus + ")" + serverVersion + "   " + currentVersion;
            intColor = "RED";
        }
        this.consoleSendMessage("[" + projectName + "]", (String)versionMessage, intColor);
        this.starting = false;
    }

    public int checkGreater(String v1, String v2) {
        int counter = ((String)v1).split("\\.").length;
        if (counter > ((String)v2).split("\\.").length) {
            v2 = (String)v2 + ".0";
        }
        if (counter < ((String)v2).split("\\.").length) {
            v1 = (String)v1 + ".0";
            ++counter;
        }
        for (int k = 0; k < counter; ++k) {
            try {
                if (Integer.parseInt(((String)v1).split("\\.")[k]) > Integer.parseInt(((String)v2).split("\\.")[k])) {
                    return -1;
                }
                if (Integer.parseInt(((String)v1).split("\\.")[k]) >= Integer.parseInt(((String)v2).split("\\.")[k])) continue;
                return 1;
            }
            catch (Exception e) {
                return -2;
            }
        }
        return 0;
    }

    public static NamedTextColor getNamedTextColorFromString(String colorName) {
        switch (colorName.toLowerCase()) {
            case "black": {
                return NamedTextColor.BLACK;
            }
            case "dark_blue": {
                return NamedTextColor.DARK_BLUE;
            }
            case "dark_green": {
                return NamedTextColor.DARK_GREEN;
            }
            case "dark_aqua": {
                return NamedTextColor.DARK_AQUA;
            }
            case "dark_red": {
                return NamedTextColor.DARK_RED;
            }
            case "dark_purple": {
                return NamedTextColor.DARK_PURPLE;
            }
            case "gold": {
                return NamedTextColor.GOLD;
            }
            case "gray": {
                return NamedTextColor.GRAY;
            }
            case "dark_gray": {
                return NamedTextColor.DARK_GRAY;
            }
            case "blue": {
                return NamedTextColor.BLUE;
            }
            case "green": {
                return NamedTextColor.GREEN;
            }
            case "aqua": {
                return NamedTextColor.AQUA;
            }
            case "red": {
                return NamedTextColor.RED;
            }
            case "light_purple": {
                return NamedTextColor.LIGHT_PURPLE;
            }
            case "yellow": {
                return NamedTextColor.YELLOW;
            }
            case "white": {
                return NamedTextColor.WHITE;
            }
        }
        System.out.println("Invalid color name, defaulting to WHITE.");
        return NamedTextColor.WHITE;
    }

    public void setFullTime(World world, int inc) {
        if (this.isFoliaBased) {
            this.runTask(null, null, null, () -> world.setFullTime(world.getFullTime() + (long)inc));
        } else {
            world.setFullTime(world.getFullTime() + (long)inc);
        }
    }

    public void setTime(World world, int inc) {
        if (this.isFoliaBased) {
            this.runTask(null, null, null, () -> world.setTime((long)inc));
        } else {
            world.setTime((long)inc);
        }
    }
}

