/*
 * Decompiled with CFR 0.152.
 */
package de.tontito.coolnightsky;

import de.tontito.coolnightsky.Events.Events;
import de.tontito.coolnightsky.utils.Metrics;
import de.tontito.coolnightsky.utils.MyBukkit;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class CoolNightSky
extends JavaPlugin {
    private MyBukkit mybukkit;
    private Object generalTask;
    public final String VERSION = this.getDescription().getVersion();
    private PluginManager pm = Bukkit.getPluginManager();
    private Hashtable<UUID, Object[]> playerObjects = new Hashtable();
    private Hashtable<Entity, Object> fallingStarHash = new Hashtable();
    private Random rand = new Random();
    private int seconds = 0;

    public void onEnable() {
        if (this.playerObjects == null) {
            this.playerObjects = new Hashtable();
        }
        String version = Bukkit.getServer().getName().toUpperCase();
        this.mybukkit = new MyBukkit(this);
        Events ev = new Events(this);
        this.pm.registerEvents((Listener)ev, (Plugin)this);
        this.startMetrics();
        this.mybukkit.UpdateChecker(true);
        this.generalTask = this.mybukkit.runTaskTimer(null, null, null, () -> this.manageSkyObjects(), 100L, 20L);
        this.getLogger().info("Version " + this.VERSION + " enabled on " + version + "!");
    }

    public void onDisable() {
        if (this.generalTask != null) {
            this.mybukkit.cancelTask(this.generalTask);
        }
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 26452);
        }
        catch (Exception e) {
            this.getLogger().info(ChatColor.RED + " Failed to register into Bstats");
        }
    }

    public synchronized void addPlayerObjects(Player player) {
        Object[] playerMainObject;
        if (this.playerObjects == null) {
            this.playerObjects = new Hashtable();
        }
        if ((playerMainObject = this.playerObjects.get(player.getUniqueId())) == null) {
            this.playerObjects.put(player.getUniqueId(), new Object[14]);
        }
    }

    public synchronized void removePlayerObjects(Player player) {
        this.playerObjects.remove(player.getUniqueId());
    }

    public void manageSkyObjects() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        ++this.seconds;
        AtomicBoolean night = new AtomicBoolean(false);
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location location = player.getLocation();
            World world = location.getWorld();
            String myWorld = world.getName();
            this.mybukkit.runTaskLater(null, location, null, () -> {
                if (world.getHighestBlockYAt(location) > location.getBlockY() + 10) {
                    return;
                }
                night.set(world.getTime() >= 13000L && world.getTime() <= 23000L);
                if (myWorld.endsWith("_nether") || myWorld.endsWith("_end")) {
                    return;
                }
                if (night.get() && !world.hasStorm() && player.getViewDistance() < 16) {
                    player.setViewDistance(16);
                } else if ((!night.get() || world.hasStorm()) && player.getViewDistance() == 16) {
                    player.setViewDistance(8);
                }
                double size = this.rand.nextDouble() * 10000.0;
                int dia = (int)(world.getFullTime() / 24000L % 365L);
                long moonPhase = world.getFullTime() / 24000L % 8L;
                if (night.get()) {
                    this.Constelations(world, player, location, dia, moonPhase);
                }
                double event = this.MeteorShowerEvent(world, player, dia, false);
                if (size < 9980.0 && !night.get()) {
                    return;
                }
                if (size < 8000.0 && world.hasStorm()) {
                    return;
                }
                this.MeteorShower(world, player, location, size, event, moonPhase);
            }, 1L);
        }
    }

    public double MeteorShowerEvent(World world, Player player, int dia, boolean show) {
        double eventDay = 0.0;
        String appendText = "!";
        if (dia == 348) {
            appendText = " It's Geminids peak";
            eventDay = 1.0;
        } else if (dia == 321) {
            appendText = " It's Leonids peak";
            eventDay = 2.0;
        } else if (dia == 294) {
            appendText = " It's Orionids peak";
            eventDay = 3.0;
        } else if (dia == 224) {
            appendText = " It's Perseids peak";
            eventDay = 4.0;
        } else if (dia == 212) {
            appendText = " It's Delta Aquariids and Alpha Capricornids peak";
            eventDay = 5.0;
        } else if (dia == 125) {
            appendText = " It's Eta Aquariids peak";
            eventDay = 6.0;
        } else if (dia == 113) {
            appendText = " It's Lyrids peak";
            eventDay = 7.0;
        } else if (dia == 4) {
            appendText = " It's Quadrantids peak";
            eventDay = 8.0;
        } else if (dia >= 344 && dia < 352) {
            appendText = " It's Geminids period";
            eventDay = 1.5;
        } else if (dia >= 220 && dia < 230) {
            appendText = " It's Perseids period";
            eventDay = 4.5;
        } else if (dia >= 1 && dia < 8) {
            appendText = " It's Quadrantids period";
            eventDay = 8.5;
        }
        int nmonth = dia / 30 % 12 + 1;
        Month month = Month.of(nmonth);
        String monthName = month.getDisplayName(TextStyle.FULL, Locale.UK);
        if (world.getTime() >= 12960L && world.getTime() <= 13040L || show && world.getTime() >= 13050L && world.getTime() <= 23000L) {
            if (world.hasStorm() && !appendText.equals("!")) {
                appendText = " and the Weather sucks.. :(";
            }
            this.mybukkit.sendActionBar(player, world.getFullTime() / 24000L + " Starting night of #" + dia + " of month " + monthName + appendText);
        }
        return eventDay;
    }

    private void MeteorShower(World world, Player player, Location location, double size, double event, long moonPhase) {
        double y = 0.0;
        double w = 100.0 * Math.sqrt(this.rand.nextDouble());
        double angle = Math.PI * 2 * this.rand.nextDouble();
        double x = w * Math.cos(angle);
        double range = Math.max(0, 90);
        double z = w * Math.sin(angle);
        if (size > 9500.0) {
            y = Math.max(this.rand.nextDouble() * range + 70.0, location.getY() + 50.0);
        } else if (event == 0.0) {
            y = Math.max(this.rand.nextDouble() * range + 90.0, location.getY() + 50.0);
        } else if ((double)((int)event) != event) {
            size += 1000.0;
            y = Math.max(this.rand.nextDouble() * range + 80.0, location.getY() + 50.0);
        } else if ((double)((int)event) == event) {
            size += 2000.0;
            y = Math.max(this.rand.nextDouble() * range + 70.0, location.getY() + 50.0);
        }
        y = Math.min(y, location.getY() + 80.0);
        if (size > 9980.0) {
            if (z > player.getLocation().getZ() + 100.0) {
                z -= 50.0;
            } else if (z < player.getLocation().getZ() - 100.0) {
                z += 50.0;
            }
            if (x > player.getLocation().getX() + 100.0) {
                x -= 50.0;
            } else if (x < player.getLocation().getX() - 100.0) {
                x += 50.0;
            }
        }
        if (size < 7000.0 && (moonPhase < 2L || moonPhase > 5L)) {
            return;
        }
        if (size < 2000.0) {
            return;
        }
        Location startLocation = new Location(world, location.getX() + x, y, location.getZ() + z);
        Vector direction = new Vector(this.rand.nextDouble() * 2.2 - 1.0, -0.4, this.rand.nextDouble() * 2.2 - 1.0);
        int random = (int)(8.0 * this.rand.nextDouble() % 8.0);
        if ((int)event == 1 || (int)event == 2 || (int)event == 3) {
            if (random == 0 || random == 1 || random == 3 || random == 4 || random == 5) {
                direction = new Vector(-1.0, -0.4, 0.0);
                int posicaoLua = (int)((double)(world.getTime() - 18000L) / 10000.0 * 180.0);
                x = location.getX() - (double)posicaoLua;
                y = location.getY() + 60.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0) - 20.0;
                z = location.getZ() + this.rand.nextDouble() * 15.0;
                startLocation = new Location(world, x, y, z);
                this.FallingArmageddon(world, player, direction, false, false);
            }
        } else if ((int)event == 4 || (int)event == 8) {
            if (random == 0 || random == 1 || random == 3) {
                direction = new Vector(this.rand.nextDouble() * 1.5, -0.4, this.rand.nextDouble() * 1.0);
                this.FallingArmageddon(world, player, direction, false, false);
            }
        } else if (!((int)event != 5 && (int)event != 6 || random != 0 && random != 1 && random != 3)) {
            direction = new Vector(this.rand.nextDouble() * 2.2 - 1.0, -0.4, -1.0);
            this.FallingArmageddon(world, player, direction, false, false);
        }
        direction.normalize();
        double speed = this.rand.nextDouble() * 1.6 + 1.2 * (y / 120.0);
        if (random == 4 || random == 5 || random == 6 || random == 8) {
            world.spawnParticle(Particle.FIREWORK, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 1 || random == 2) {
            world.spawnParticle(Particle.LAVA, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 0 || random == 3) {
            world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if (random == 7) {
            world.spawnParticle(Particle.CHERRY_LEAVES, startLocation, 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
        }
        if ((int)event == 1) {
            if (random == 0 || random == 1 || random == 2) {
                world.spawnParticle(Particle.END_ROD, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 4) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
            if (random == 0) {
                world.spawnParticle(Particle.TOTEM_OF_UNDYING, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
            if (random == 3) {
                world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 5) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 6) {
            startLocation.add(0.0, -15.0, 0.0);
            if (random == 0) {
                world.spawnParticle(Particle.END_ROD, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        } else if ((int)event == 8) {
            if (random == 1) {
                world.spawnParticle(Particle.FLAME, startLocation.clone().add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed * 2.0, null, true);
            }
            if (random == 3 || random == 4) {
                world.spawnParticle(Particle.SOUL_FIRE_FLAME, startLocation.add(100.0 * this.rand.nextDouble(), 0.0, 100.0 * this.rand.nextDouble()), 1, direction.getX(), direction.getY(), direction.getZ(), speed, null, true);
            }
        }
    }

    private void MoonEfects(World world, Player player, Location location, int dia, long moonPhase) {
    }

    private void Constelations(World world, Player player, Location playerLocation, int dia, long moonPhase) {
        int posicaoLua = (int)((double)(world.getTime() - 18000L) / 10000.0 * 180.0);
        if (this.playerObjects == null) {
            return;
        }
        Object[] playerMainObject = this.playerObjects.get(player.getUniqueId());
        if (playerMainObject == null) {
            return;
        }
        int halfmonth = dia / 15;
        if (halfmonth < 7 || halfmonth > 19) {
            this.constellationOrion(world, player, playerLocation, posicaoLua, halfmonth, playerMainObject);
        }
        if (halfmonth < 8 || halfmonth > 20) {
            this.constellationTaurus(world, player, playerLocation, posicaoLua, halfmonth, playerMainObject);
        }
        if (halfmonth > 8 && halfmonth <= 19) {
            this.constellationScorpio(world, player, playerLocation, posicaoLua, halfmonth, playerMainObject);
        }
    }

    private void constellationOrion(World world, Player player, Location playerLocation, int posicaoLua, int halfmonth, Object[] playerMainObject) {
        if (halfmonth == 20) {
            posicaoLua -= 75;
        } else if (halfmonth == 21) {
            posicaoLua -= 60;
        } else if (halfmonth == 22) {
            posicaoLua -= 45;
        } else if (halfmonth == 23) {
            posicaoLua -= 30;
        } else if (halfmonth == 0) {
            posicaoLua -= 15;
        } else if (halfmonth == 1) {
            posicaoLua -= 0;
        } else if (halfmonth == 2) {
            posicaoLua += 15;
        } else if (halfmonth == 3) {
            posicaoLua += 30;
        } else if (halfmonth == 4) {
            posicaoLua += 45;
        } else if (halfmonth == 5) {
            posicaoLua += 60;
        } else if (halfmonth == 6) {
            posicaoLua += 75;
        }
        double x = playerLocation.getX() - (double)posicaoLua;
        double y = playerLocation.getY() + 70.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0);
        double z = playerLocation.getZ();
        if (y < player.getLocation().getY() - 40.0 || world.hasStorm()) {
            return;
        }
        Location loc = new Location(world, x, y, z);
        loc.add(40.0, 10.0, 220.0);
        Location oldLocation = null;
        Object[][] Orion = (Object[][])playerMainObject[0];
        if (Orion == null) {
            playerMainObject[0] = Orion = new Object[15][2];
        }
        if (Orion[0][0] != null) {
            oldLocation = (Location)Orion[0][1];
        }
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        this.DrawStar(world, player, Orion, loc, 2, 1, 0);
        loc.add(-22.0, 25.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 4, 0, 1);
        loc.add(32.0, 5.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 2);
        loc.add(-2.0, 8.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 3);
        loc.add(-1.0, 8.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 3, 1, 4);
        loc.add(36.0, 10.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 4, 4, 5);
        loc.add(-8.0, 20.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 1, 1, 6);
        loc.add(-14.0, -5.0, 0.0);
        this.DrawStar(world, player, Orion, loc, 2, 1, 7);
    }

    private void constellationScorpio(World world, Player player, Location playerLocation, int posicaoLua, int halfmonth, Object[] playerMainObject) {
        if (halfmonth == 9) {
            posicaoLua -= 75;
        } else if (halfmonth == 10) {
            posicaoLua -= 60;
        } else if (halfmonth == 11) {
            posicaoLua -= 45;
        } else if (halfmonth == 12) {
            posicaoLua -= 30;
        } else if (halfmonth == 13) {
            posicaoLua -= 15;
        } else if (halfmonth == 14) {
            posicaoLua -= 0;
        } else if (halfmonth == 15) {
            posicaoLua += 15;
        } else if (halfmonth == 16) {
            posicaoLua += 30;
        } else if (halfmonth == 17) {
            posicaoLua += 45;
        } else if (halfmonth == 18) {
            posicaoLua += 60;
        } else if (halfmonth == 19) {
            posicaoLua += 75;
        }
        double x = playerLocation.getX() - (double)posicaoLua;
        double y = playerLocation.getY() + 60.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0);
        double z = playerLocation.getZ();
        if (y < player.getLocation().getY() - 40.0 || world.hasStorm()) {
            return;
        }
        Location loc = new Location(world, x, y, z);
        loc.add(0.0, 55.0, 220.0);
        Location oldLocation = null;
        Object[][] scorpio = (Object[][])playerMainObject[1];
        if (scorpio == null) {
            playerMainObject[1] = scorpio = new Object[15][2];
        }
        if (scorpio[0][0] != null) {
            oldLocation = (Location)scorpio[0][1];
        }
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        this.DrawStar(world, player, scorpio, loc, 2, 1, 0);
        loc.add(-2.0, -15.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 4, 0, 1);
        loc.add(1.0, -15.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 3, 1, 2);
        loc.add(0.0, -15.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 3, 1, 3);
        loc.add(30.0, 15.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 3, 4, 4);
        loc.add(8.0, -8.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 3, 1, 5);
        loc.add(15.0, -35.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 4, 1, 6);
        loc.add(2.0, -35.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 1, 1, 7);
        loc.add(30.0, 0.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 2, 1, 8);
        loc.add(3.0, 5.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 2, 1, 9);
        loc.add(-5.0, 2.0, 0.0);
        this.DrawStar(world, player, scorpio, loc, 2, 1, 10);
    }

    private void constellationTaurus(World world, Player player, Location playerLocation, int posicaoLua, int halfmonth, Object[] playerMainObject) {
        if (halfmonth == 21) {
            posicaoLua -= 75;
        } else if (halfmonth == 22) {
            posicaoLua -= 60;
        } else if (halfmonth == 23) {
            posicaoLua -= 45;
        } else if (halfmonth == 0) {
            posicaoLua -= 30;
        } else if (halfmonth == 1) {
            posicaoLua -= 15;
        } else if (halfmonth == 2) {
            posicaoLua -= 0;
        } else if (halfmonth == 3) {
            posicaoLua += 15;
        } else if (halfmonth == 4) {
            posicaoLua += 30;
        } else if (halfmonth == 5) {
            posicaoLua += 45;
        } else if (halfmonth == 6) {
            posicaoLua += 60;
        } else if (halfmonth == 7) {
            posicaoLua += 75;
        }
        double x = playerLocation.getX() - (double)posicaoLua;
        double y = playerLocation.getY() + 150.0 * Math.cos(Math.PI * (double)posicaoLua / 180.0);
        double z = playerLocation.getZ();
        if (y < player.getLocation().getY() - 40.0 || world.hasStorm()) {
            return;
        }
        Location loc = new Location(world, x, y, z);
        loc.add(-100.0, 10.0, 220.0);
        Location oldLocation = null;
        Object[][] taurus = (Object[][])playerMainObject[2];
        if (taurus == null) {
            playerMainObject[2] = taurus = new Object[15][2];
        }
        if (taurus[0][0] != null) {
            oldLocation = (Location)taurus[0][1];
        }
        if (oldLocation != null && oldLocation.equals((Object)loc)) {
            return;
        }
        this.DrawStar(world, player, taurus, loc, 2, 1, 0);
        loc.add(25.0, 10.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 4, 0, 1);
        loc.add(15.0, 8.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 3, 1, 2);
        loc.add(7.0, 5.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 3, 1, 3);
        loc.add(5.0, 7.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 3, 4, 4);
        loc.add(10.0, 15.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 3, 1, 5);
        loc.add(25.0, 20.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 4, 1, 6);
        loc.add(15.0, -20.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 1, 1, 7);
        loc.add(-35.0, -15.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 2, 1, 8);
        loc.add(-5.0, -2.0, 0.0);
        this.DrawStar(world, player, taurus, loc, 2, 1, 9);
    }

    private void DrawStar(World world, Player player, Object[][] constelation, Location newlocation, int size, int colourComposition, int pos) {
        Location oldLocation;
        Object myblock;
        Location location = newlocation.clone();
        if (constelation[pos][0] != null) {
            myblock = (BlockData)constelation[pos][0];
            oldLocation = (Location)constelation[pos][1];
        } else {
            myblock = colourComposition == 0 ? Material.SEA_LANTERN.createBlockData() : (colourComposition == 1 ? Material.VERDANT_FROGLIGHT.createBlockData() : (colourComposition == 2 ? Material.PEARLESCENT_FROGLIGHT.createBlockData() : (colourComposition == 3 ? Material.OCHRE_FROGLIGHT.createBlockData() : (colourComposition == 4 ? Material.SHROOMLIGHT.createBlockData() : (colourComposition == 5 ? Material.LAVA.createBlockData() : null)))));
            constelation[pos][0] = myblock;
            oldLocation = null;
        }
        Location finalOldLocation = oldLocation;
        this.mybukkit.runTaskLater(player, null, null, () -> CoolNightSky.lambda$DrawStar$2(finalOldLocation, player, location, world, (BlockData)myblock), 1L);
        constelation[pos][1] = location;
    }

    private void FallingArmageddon(World myWorld, Player player, Vector direction, boolean explosive, boolean incendiary) {
        if (this.fallingStarHash.size() > 1) {
            return;
        }
        FallingBlock myBlock = player.getWorld().spawnFallingBlock(player.getLocation().add(this.rand.nextDouble() * 35.0, 140.0, this.rand.nextDouble() * 35.0), Material.GRAVEL, (byte)0);
        myBlock.setDropItem(false);
        myBlock.setGravity(false);
        Vector mydirection = direction.clone().setY(-1.5).multiply(3);
        myBlock.setVelocity(mydirection);
        Object fallingStarTimer = this.mybukkit.runTaskTimer(null, null, (Entity)myBlock, () -> {
            if (myBlock.isDead() || myBlock.isOnGround()) {
                myWorld.spawnParticle(Particle.FLAME, myBlock.getLocation(), 10, 0.0, 0.5, 0.0, 0.2, null, true);
                myWorld.spawnParticle(Particle.FLASH, myBlock.getLocation(), 3, 0.0, 0.5, 0.0, 0.2, null, true);
                this.mybukkit.cancelTask(this.fallingStarHash.remove(myBlock));
                if (explosive) {
                    TNTPrimed tnt = (TNTPrimed)myWorld.spawnEntity(myBlock.getLocation(), EntityType.TNT);
                    tnt.setFuseTicks(0);
                    tnt.setYield(2.0f);
                    if (incendiary) {
                        tnt.setIsIncendiary(true);
                    }
                } else {
                    Block mynewBlock = myBlock.getLocation().getBlock();
                    mynewBlock.setType(Material.AIR);
                }
                myBlock.remove();
            } else {
                myWorld.spawnParticle(Particle.FIREWORK, myBlock.getLocation(), 4, 0.0, 0.5, 0.0, 0.2, null, true);
                myWorld.spawnParticle(Particle.SOUL_FIRE_FLAME, myBlock.getLocation(), 2, 0.0, 0.5, 0.0, 0.2, null, true);
            }
        }, 1L, 1L);
        if (myBlock != null && fallingStarTimer != null) {
            this.fallingStarHash.put((Entity)myBlock, fallingStarTimer);
        }
    }

    private static /* synthetic */ void lambda$DrawStar$2(Location finalOldLocation, Player player, Location location, World world, BlockData myblock) {
        if (finalOldLocation != null) {
            player.sendBlockChange(finalOldLocation, finalOldLocation.getBlock().getBlockData());
        }
        if (location.getY() < player.getLocation().getY() || world.hasStorm()) {
            return;
        }
        player.sendBlockChange(location, myblock);
    }
}

