/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobbleguard.config;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\"\u0010\u001e\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Ldev/zanckor/cobbleguard/config/SimpleConfig;", "", "<init>", "()V", "", "load", "save", "", "isWildPokesPassive", "Z", "()Z", "setWildPokesPassive", "(Z)V", "", "mobXPQuantity", "I", "getMobXPQuantity", "()I", "setMobXPQuantity", "(I)V", "", "runAwaySpeedMultiplier", "D", "getRunAwaySpeedMultiplier", "()D", "setRunAwaySpeedMultiplier", "(D)V", "pokemonDamageMultiplier", "getPokemonDamageMultiplier", "setPokemonDamageMultiplier", "playerDamageMultiplier", "getPlayerDamageMultiplier", "setPlayerDamageMultiplier", "Ljava/io/File;", "configFile", "Ljava/io/File;", "CobbleGuard"})
@SourceDebugExtension(value={"SMAP\nSimpleConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleConfig.kt\ndev/zanckor/cobbleguard/config/SimpleConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class SimpleConfig {
    @NotNull
    public static final SimpleConfig INSTANCE = new SimpleConfig();
    private static boolean isWildPokesPassive = true;
    private static int mobXPQuantity = 1;
    private static double runAwaySpeedMultiplier = 1.0;
    private static double pokemonDamageMultiplier = 1.0;
    private static double playerDamageMultiplier = 1.0;
    @NotNull
    private static final File configFile = new File("config/cobbleguard.cfg");

    private SimpleConfig() {
    }

    public final boolean isWildPokesPassive() {
        return isWildPokesPassive;
    }

    public final void setWildPokesPassive(boolean bl) {
        isWildPokesPassive = bl;
    }

    public final int getMobXPQuantity() {
        return mobXPQuantity;
    }

    public final void setMobXPQuantity(int n) {
        mobXPQuantity = n;
    }

    public final double getRunAwaySpeedMultiplier() {
        return runAwaySpeedMultiplier;
    }

    public final void setRunAwaySpeedMultiplier(double d) {
        runAwaySpeedMultiplier = d;
    }

    public final double getPokemonDamageMultiplier() {
        return pokemonDamageMultiplier;
    }

    public final void setPokemonDamageMultiplier(double d) {
        pokemonDamageMultiplier = d;
    }

    public final double getPlayerDamageMultiplier() {
        return playerDamageMultiplier;
    }

    public final void setPlayerDamageMultiplier(double d) {
        playerDamageMultiplier = d;
    }

    public final void load() {
        Properties properties;
        if (!configFile.exists()) {
            this.save();
            return;
        }
        Properties $this$load_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$load_u24lambda_u240.load(new FileInputStream(configFile));
        Properties props = properties;
        isWildPokesPassive = Boolean.parseBoolean(props.getProperty("isWildPokesPassive", "false"));
        String string = props.getProperty("mobXPQuantity", "20");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        mobXPQuantity = Integer.parseInt(string);
        String string2 = props.getProperty("runAwaySpeedMultiplier", "1.0");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        Double d = StringsKt.toDoubleOrNull((String)string2);
        runAwaySpeedMultiplier = d != null ? d : 1.0;
        String string3 = props.getProperty("pokemonDamageMultiplier", "1.0");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        Double d2 = StringsKt.toDoubleOrNull((String)string3);
        pokemonDamageMultiplier = d2 != null ? RangesKt.coerceIn((double)d2, (double)0.0, (double)10.0) : 1.0;
        String string4 = props.getProperty("playerDamageMultiplier", "1.0");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        Double d3 = StringsKt.toDoubleOrNull((String)string4);
        playerDamageMultiplier = d3 != null ? RangesKt.coerceIn((double)d3, (double)0.0, (double)10.0) : 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        Object object = new Properties();
        Properties $this$save_u24lambda_u241 = object;
        boolean bl = false;
        $this$save_u24lambda_u241.setProperty("isWildPokesPassive", String.valueOf(isWildPokesPassive));
        $this$save_u24lambda_u241.setProperty("mobXPQuantity", String.valueOf(mobXPQuantity));
        $this$save_u24lambda_u241.setProperty("pokemonDamageMultiplier", String.valueOf(pokemonDamageMultiplier));
        $this$save_u24lambda_u241.setProperty("playerDamageMultiplier", String.valueOf(playerDamageMultiplier));
        $this$save_u24lambda_u241.setProperty("runAwaySpeedMultiplier", String.valueOf(runAwaySpeedMultiplier));
        Properties props = object;
        configFile.getParentFile().mkdirs();
        object = new FileOutputStream(configFile);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            boolean bl2 = false;
            props.store(it, "CobbleGuard Config.\n\nisWildPokesPassive - If true, wild pokes won't attack you unless you attack first.\nmobXPQuantity - On kill a normal Minecraft Mob, how much XP Pok\u00e9mon should receive.\nrunAwaySpeedMultiplier - Speed multiplier applied to Pok\u00e9mon on run-away.\npokemonDamageMultiplier - Damage multiplier applied to attacks from Pok\u00e9mon to Players or Mobs. (0.0 -> 10.0)\nplayerDamageMultiplier - Damage multiplier applied to attacks from Players or Mobs to Pok\u00e9mon. (0.0 -> 10.0)");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

