/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobbleguard.core.rangedattacks;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import dev.zanckor.cobbleguard.core.rangedattacks.AttackMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.BugMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.ElectricMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.FireMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.GroundMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.PoisonMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.RockMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.ThunderballMove;
import dev.zanckor.cobbleguard.core.rangedattacks.moves.WaterMove;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0012R\u0017\u0010\u001d\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001e\u0010\u0012R\u0017\u0010\u001f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b \u0010\u0012R\u0017\u0010!\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u0010\u001a\u0004\b\"\u0010\u0012R\u0017\u0010#\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b$\u0010\u0012\u00a8\u0006%"}, d2={"Ldev/zanckor/cobbleguard/core/rangedattacks/MoveRegistry;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "elementalType", "Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;", "move", "registerMove", "(Lcom/cobblemon/mod/common/api/types/ElementalType;Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;)Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;", "getMove", "(Lcom/cobblemon/mod/common/api/types/ElementalType;)Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;", "", "moves", "Ljava/util/Map;", "FireMove", "Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;", "getFireMove", "()Ldev/zanckor/cobbleguard/core/rangedattacks/AttackMove;", "IceMove", "getIceMove", "WaterMove", "getWaterMove", "PoisonMove", "getPoisonMove", "ElectricMove", "getElectricMove", "ThunderballMove", "getThunderballMove", "GrassMove", "getGrassMove", "BugMove", "getBugMove", "GroundMove", "getGroundMove", "RockMove", "getRockMove", "CobbleGuard"})
public final class MoveRegistry {
    @NotNull
    public static final MoveRegistry INSTANCE = new MoveRegistry();
    @NotNull
    private static final Map<ElementalType, AttackMove> moves = new LinkedHashMap();
    @NotNull
    private static final AttackMove FireMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getFIRE(), new FireMove(true, true, ElementalTypes.INSTANCE.getFIRE(), 0.75f, 0.0, 16, null));
    @NotNull
    private static final AttackMove IceMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getICE(), new WaterMove(true, true, ElementalTypes.INSTANCE.getICE(), 4.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove WaterMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getWATER(), new WaterMove(true, true, ElementalTypes.INSTANCE.getWATER(), 2.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove PoisonMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getPOISON(), new PoisonMove(true, true, ElementalTypes.INSTANCE.getPOISON(), 0.5f, 0.0, 16, null));
    @NotNull
    private static final AttackMove ElectricMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getELECTRIC(), new ElectricMove(true, true, ElementalTypes.INSTANCE.getELECTRIC(), 5.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove ThunderballMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getELECTRIC(), new ThunderballMove(true, true, ElementalTypes.INSTANCE.getELECTRIC(), 3.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove GrassMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getGRASS(), new BugMove(true, true, ElementalTypes.INSTANCE.getGRASS(), 2.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove BugMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getBUG(), new BugMove(true, true, ElementalTypes.INSTANCE.getBUG(), 3.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove GroundMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getGROUND(), new GroundMove(true, true, ElementalTypes.INSTANCE.getGROUND(), 5.0f, 0.0, 16, null));
    @NotNull
    private static final AttackMove RockMove = INSTANCE.registerMove(ElementalTypes.INSTANCE.getROCK(), new RockMove(true, true, ElementalTypes.INSTANCE.getROCK(), 3.0f, 0.0, 16, null));

    private MoveRegistry() {
    }

    @NotNull
    public final AttackMove getFireMove() {
        return FireMove;
    }

    @NotNull
    public final AttackMove getIceMove() {
        return IceMove;
    }

    @NotNull
    public final AttackMove getWaterMove() {
        return WaterMove;
    }

    @NotNull
    public final AttackMove getPoisonMove() {
        return PoisonMove;
    }

    @NotNull
    public final AttackMove getElectricMove() {
        return ElectricMove;
    }

    @NotNull
    public final AttackMove getThunderballMove() {
        return ThunderballMove;
    }

    @NotNull
    public final AttackMove getGrassMove() {
        return GrassMove;
    }

    @NotNull
    public final AttackMove getBugMove() {
        return BugMove;
    }

    @NotNull
    public final AttackMove getGroundMove() {
        return GroundMove;
    }

    @NotNull
    public final AttackMove getRockMove() {
        return RockMove;
    }

    private final AttackMove registerMove(ElementalType elementalType, AttackMove move) {
        moves.put(elementalType, move);
        return move;
    }

    @Nullable
    public final AttackMove getMove(@NotNull ElementalType elementalType) {
        Intrinsics.checkNotNullParameter((Object)elementalType, (String)"elementalType");
        return moves.get(elementalType);
    }
}

