/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobbleguard.mixin.mixin;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.experience.ExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.experience.StandardExperienceCalculator;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.battles.ai.StrongBattleAIKt;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.zanckor.cobbleguard.CobbleGuard;
import dev.zanckor.cobbleguard.config.SimpleConfig;
import dev.zanckor.cobbleguard.core.brain.registry.PokemonMemoryModuleType;
import dev.zanckor.cobbleguard.core.brain.sensor.NearestOwnerTargetSensor;
import dev.zanckor.cobbleguard.core.brain.sensor.NearestWildTargetSensor;
import dev.zanckor.cobbleguard.core.brain.task.DefendOwnerTask;
import dev.zanckor.cobbleguard.core.brain.task.WildBehaviourTask;
import dev.zanckor.cobbleguard.core.rangedattacks.AttackMove;
import dev.zanckor.cobbleguard.core.rangedattacks.MoveRegistry;
import dev.zanckor.cobbleguard.mixin.mixininterface.Hostilemon;
import dev.zanckor.cobbleguard.mixin.mixininterface.RangedMove;
import dev.zanckor.cobbleguard.util.CobbleUtil;
import dev.zanckor.cobbleguard.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1680;
import net.minecraft.class_1687;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_8109;
import net.minecraft.class_8956;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Debug(export=true, print=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B/\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0017\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J)\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010,\u001a\u00020\b2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b.\u0010/J!\u00102\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b2\u00103J7\u0010:\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e09082\u0006\u00105\u001a\u0002042\u0006\u00107\u001a\u000206H\u0002\u00a2\u0006\u0004\b:\u0010;JC\u0010?\u001a\u00020>2\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e092\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e09H\u0002\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010B\u001a\u00020\u00142\u0006\u0010A\u001a\u000206H\u0002\u00a2\u0006\u0004\bB\u0010CJ'\u0010K\u001a\u00020J2\u0006\u0010E\u001a\u00020D2\u0006\u0010G\u001a\u00020F2\u0006\u0010I\u001a\u00020HH\u0016\u00a2\u0006\u0004\bK\u0010LJ\u0017\u0010O\u001a\u00020\u00142\u0006\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0004\bO\u0010PJ'\u0010S\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\bS\u0010TJ\u0017\u0010V\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000UH\u0016\u00a2\u0006\u0004\bV\u0010WJ\u001f\u0010Z\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00000Y0XH\u0016\u00a2\u0006\u0004\bZ\u0010[J\u0013\u0010]\u001a\u0006\u0012\u0002\b\u00030\\H\u0014\u00a2\u0006\u0004\b]\u0010^J\u000f\u0010_\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b_\u0010`R\"\u0010\t\u001a\u00020\b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010a\u001a\u0004\b\t\u0010b\"\u0004\bc\u0010dR\"\u0010\u000b\u001a\u00020\n8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010e\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u0018\u0010j\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010kR\u0018\u0010m\u001a\u0004\u0018\u00010l8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010n\u00a8\u0006o"}, d2={"Ldev/zanckor/cobbleguard/mixin/mixin/PokemonMixin;", "Lnet/minecraft/class_1314;", "Ldev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon;", "Lnet/tslat/smartbrainlib/api/SmartBrainOwner;", "Lnet/minecraft/class_1299;", "entityType", "Lnet/minecraft/class_1937;", "level", "", "isHostile", "Ldev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon$Aggresivity;", "aggressivity", "<init>", "(Lnet/minecraft/class_1299;Lnet/minecraft/class_1937;ZLdev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon$Aggresivity;)V", "Lnet/minecraft/class_1309;", "target", "Lcom/cobblemon/mod/common/api/moves/Move;", "getBestMoveAgainst", "(Lnet/minecraft/class_1309;)Lcom/cobblemon/mod/common/api/moves/Move;", "move", "", "usePhysicalMove", "(Lcom/cobblemon/mod/common/api/moves/Move;Lnet/minecraft/class_1309;)V", "useRangedMove", "Lnet/minecraft/class_1676;", "projectile", "", "speed", "shootProjectile", "(Lnet/minecraft/class_1676;FLnet/minecraft/class_1309;)V", "", "calculateMoveDamage", "(Lcom/cobblemon/mod/common/api/moves/Move;Lnet/minecraft/class_1309;)D", "calculateMoveEffectiveness", "basePower", "effectiveness", "calculateDamage", "(DD)D", "damage", "applyDamageToTarget", "(Lnet/minecraft/class_1309;D)V", "Lnet/minecraft/class_1282;", "damageSource", "f", "hurt", "(Lnet/minecraft/class_1282;F)Z", "updateTargetBehavior", "(Lnet/minecraft/class_1309;)V", "Lcom/cobblemon/mod/common/api/types/ElementalType;", "targetType", "getMoveEffectiveness", "(Lcom/cobblemon/mod/common/api/moves/Move;Lcom/cobblemon/mod/common/api/types/ElementalType;)D", "Lcom/cobblemon/mod/common/api/moves/MoveSet;", "moveSet", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemonTarget", "", "Lkotlin/Triple;", "mapMoves", "(Lcom/cobblemon/mod/common/api/moves/MoveSet;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/List;", "move1", "move2", "", "compareMoves", "(Lkotlin/Triple;Lkotlin/Triple;)I", "attacker", "givePokemonExperience", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_243;", "vec3", "Lnet/minecraft/class_1268;", "interactionHand", "Lnet/minecraft/class_1269;", "interactAt", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_243;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1269;", "Lnet/minecraft/class_1297$class_5529;", "removalReason", "remove", "(Lnet/minecraft/class_1297$class_5529;)V", "d", "e", "knockback", "(DDD)V", "Lnet/tslat/smartbrainlib/api/core/BrainActivityGroup;", "getCoreTasks", "()Lnet/tslat/smartbrainlib/api/core/BrainActivityGroup;", "", "Lnet/tslat/smartbrainlib/api/core/sensor/ExtendedSensor;", "getSensors", "()Ljava/util/List;", "Lnet/minecraft/class_4095$class_5303;", "brainProvider", "()Lnet/minecraft/class_4095$class_5303;", "customServerAiStep", "()V", "Z", "()Z", "setHostile", "(Z)V", "Ldev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon$Aggresivity;", "getAggressivity", "()Ldev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon$Aggresivity;", "setAggressivity", "(Ldev/zanckor/cobbleguard/mixin/mixininterface/Hostilemon$Aggresivity;)V", "pokemon", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "hostilemonAttacker", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "CobbleGuard"})
@Mixin(value={PokemonEntity.class})
public final class PokemonMixin
extends class_1314
implements Hostilemon,
SmartBrainOwner<PokemonMixin> {
    private boolean isHostile;
    @NotNull
    private Hostilemon.Aggresivity aggressivity;
    @Shadow(remap=false)
    @Nullable
    @JvmField
    public Pokemon pokemon;
    @Nullable
    private PokemonEntity hostilemonAttacker;

    public PokemonMixin(@NotNull class_1299<? extends class_1314> entityType, @NotNull class_1937 level, boolean isHostile, @NotNull Hostilemon.Aggresivity aggressivity) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)aggressivity), (String)"aggressivity");
        super(entityType, level);
        this.isHostile = isHostile;
        this.aggressivity = aggressivity;
    }

    @Override
    public boolean isHostile() {
        return this.isHostile;
    }

    @Override
    public void setHostile(boolean bl) {
        this.isHostile = bl;
    }

    @Override
    @NotNull
    public Hostilemon.Aggresivity getAggressivity() {
        return this.aggressivity;
    }

    @Override
    public void setAggressivity(@NotNull Hostilemon.Aggresivity aggresivity) {
        Intrinsics.checkNotNullParameter((Object)((Object)aggresivity), (String)"<set-?>");
        this.aggressivity = aggresivity;
    }

    @Override
    @Nullable
    public Move getBestMoveAgainst(@Nullable class_1309 target) {
        if (this.pokemon == null) {
            return null;
        }
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        if (CollectionsKt.toList((Iterable)((Iterable)pokemon.getMoveSet())).isEmpty()) {
            return null;
        }
        boolean isPokemon = target instanceof PokemonEntity;
        if (isPokemon) {
            Pokemon pokemonTarget = ((PokemonEntity)target).getPokemon();
            Pokemon pokemon2 = this.pokemon;
            Intrinsics.checkNotNull((Object)pokemon2);
            List moves = CollectionsKt.sortedWith((Iterable)this.mapMoves(pokemon2.getMoveSet(), pokemonTarget), (arg_0, arg_1) -> PokemonMixin.getBestMoveAgainst$lambda$1((arg_0, arg_1) -> PokemonMixin.getBestMoveAgainst$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
            return (Move)((Triple)CollectionsKt.last((List)moves)).getFirst();
        }
        Pokemon pokemon3 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon3);
        MoveSet moveSet = pokemon3.getMoveSet();
        Pokemon pokemon4 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon4);
        return moveSet.get(this.field_5974.method_39332(0, CollectionsKt.count((Iterable)((Iterable)pokemon4.getMoveSet())) - 1));
    }

    @Override
    public void usePhysicalMove(@Nullable Move move, @Nullable class_1309 target) {
        if (this.pokemon == null || move == null || target == null) {
            System.out.println((Object)("CobbleGuard Error: Invalid parameters in useRangedMove. Move: " + move + ", Target: " + target + ", Pokemon: " + this.pokemon));
            return;
        }
        this.updateTargetBehavior(target);
        this.applyDamageToTarget(target, this.calculateMoveDamage(move, target));
        class_2960 class_29602 = CobbleUtil.INSTANCE.getHIT();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"<get-HIT>(...)");
        CobbleUtil.INSTANCE.summonHitParticles(target, class_29602);
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        class_2960 class_29603 = CobbleUtil.INSTANCE.TYPE_HIT(pokemon.getPrimaryType());
        Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"TYPE_HIT(...)");
        CobbleUtil.INSTANCE.summonHitParticles(target, class_29603);
    }

    @Override
    public void useRangedMove(@Nullable Move move, @Nullable class_1309 target) {
        float f;
        class_1676 class_16762;
        if (this.pokemon == null || move == null || target == null) {
            System.out.println((Object)("CobbleGuard Error: Invalid parameters in useRangedMove. Move: " + move + ", Target: " + target + ", Pokemon: " + this.pokemon));
            return;
        }
        ElementalType moveType = move.getType();
        AttackMove attackMove = MoveRegistry.INSTANCE.getMove(moveType);
        ElementalType elementalType = moveType;
        if (Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getFIRE())) {
            class_16762 = (class_1676)new class_1677(this.method_37908(), (class_1309)this, class_243.field_1353);
        } else if (Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getICE()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getWATER()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getBUG()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getGRASS()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getROCK()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getSTEEL()) || Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getGROUND())) {
            class_16762 = (class_1676)new class_8956(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), class_243.field_1353);
        } else if (Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getPOISON())) {
            class_16762 = (class_1676)new class_1687(this.method_37908(), (class_1309)this, class_243.field_1353);
        } else if (Intrinsics.areEqual((Object)elementalType, (Object)ElementalTypes.INSTANCE.getELECTRIC())) {
            int chance = this.field_5974.method_43051(0, 100);
            attackMove = chance < 50 ? MoveRegistry.INSTANCE.getThunderballMove() : MoveRegistry.INSTANCE.getElectricMove();
            class_16762 = (class_1676)new class_1680(this.method_37908(), target.method_23317(), target.method_23318() + (double)25, target.method_23321());
        } else {
            return;
        }
        class_1676 projectile = class_16762;
        if (!(projectile instanceof RangedMove)) {
            System.out.println((Object)("CobbleGuard Error: Generated projectile is not a RangedMove for " + moveType));
            return;
        }
        if (!Intrinsics.areEqual((Object)((RangedMove)projectile).getMove(), (Object)MoveRegistry.INSTANCE.getElectricMove())) {
            projectile.method_5814(this.method_19538().field_1352, this.method_19538().field_1351 + (double)(this.method_17682() / (float)2), this.method_19538().field_1350);
        }
        ((RangedMove)projectile).setMove(attackMove);
        ((RangedMove)projectile).setMoveDamage(this.calculateMoveDamage(move, target));
        RangedMove rangedMove = (RangedMove)projectile;
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        rangedMove.setOwner(pokemon.getEntity());
        AttackMove attackMove2 = ((RangedMove)projectile).getMove();
        if (attackMove2 != null) {
            f = attackMove2.getSpeed();
        } else {
            PokemonMixin $this$useRangedMove_u24lambda_u242 = this;
            boolean bl = false;
            f = 1.0f;
        }
        float speed = f;
        this.shootProjectile(projectile, speed, target);
    }

    private final void shootProjectile(class_1676 projectile, float speed, class_1309 target) {
        block2: {
            class_1309 class_13092 = target;
            if (class_13092 == null || (class_13092 = class_13092.method_19538()) == null || (class_13092 = class_13092.method_1020(projectile.method_19538())) == null || (class_13092 = class_13092.method_1029()) == null) {
                return;
            }
            class_1309 direction = class_13092;
            projectile.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, 0.5f * speed, 1.0f);
            if (this.method_37908().field_9236) break block2;
            MinecraftServer minecraftServer = this.method_37908().method_8503();
            if (minecraftServer != null) {
                minecraftServer.execute(() -> PokemonMixin.shootProjectile$lambda$3(this, projectile));
            }
        }
    }

    private final double calculateMoveDamage(Move move, class_1309 target) {
        if (move == null) {
            return 20.0;
        }
        double effectiveness = this.calculateMoveEffectiveness(move, target);
        double basePower = move.getPower() == 0.0 ? 20.0 : move.getPower();
        return this.calculateDamage(basePower, effectiveness);
    }

    private final double calculateMoveEffectiveness(Move move, class_1309 target) {
        return target instanceof PokemonEntity ? this.getMoveEffectiveness(move, ((PokemonEntity)target).getPokemon().getPrimaryType()) : SimpleConfig.INSTANCE.getPokemonDamageMultiplier();
    }

    private final double calculateDamage(double basePower, double effectiveness) {
        if (this.pokemon == null) {
            return 10.0;
        }
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        int pokemonLevel = pokemon.getLevel();
        return basePower * effectiveness * ((double)pokemonLevel / 100.0) * 0.4;
    }

    private final void applyDamageToTarget(class_1309 target, double damage) {
        block6: {
            block5: {
                if (this.pokemon == null) break block5;
                Pokemon pokemon = this.pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                if (pokemon.getEntity() != null) break block6;
            }
            return;
        }
        class_8109 class_81092 = this.method_48923();
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        PokemonEntity pokemonEntity = pokemon.getEntity();
        Intrinsics.checkNotNull((Object)pokemonEntity);
        target.method_5643(class_81092.method_48812((class_1309)pokemonEntity), (float)damage);
        target.method_6005(0.5, this.method_19538().field_1352 - target.method_19538().field_1352, this.method_19538().field_1350 - target.method_19538().field_1350);
        if (target.method_29504()) {
            boolean isMobEntity;
            boolean bl = isMobEntity = !(target instanceof PokemonEntity);
            if (isMobEntity) {
                Pokemon pokemon2 = this.pokemon;
                Intrinsics.checkNotNull((Object)pokemon2);
                pokemon2.addExperience((ExperienceSource)new SidemodExperienceSource(CobbleGuard.MODID), SimpleConfig.INSTANCE.getMobXPQuantity());
            }
            Pokemon pokemon3 = this.pokemon;
            Intrinsics.checkNotNull((Object)pokemon3);
            PokemonEntity pokemonEntity2 = pokemon3.getEntity();
            Intrinsics.checkNotNull((Object)pokemonEntity2);
            class_1297 class_12972 = (class_1297)pokemonEntity2;
            class_2960 class_29602 = CobbleUtil.INSTANCE.getWIN_FIGHT();
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"<get-WIN_FIGHT>(...)");
            CobbleUtil.INSTANCE.summonEntityParticles(class_12972, class_29602, CollectionsKt.listOf((Object)"root"));
        }
    }

    public boolean method_5643(@NotNull class_1282 damageSource, float f) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
                if (this.pokemon == null) break block6;
                Pokemon pokemon = this.pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                if (pokemon.getEntity() == null) break block6;
                Pokemon pokemon2 = this.pokemon;
                Intrinsics.checkNotNull((Object)pokemon2);
                PokemonEntity pokemonEntity = pokemon2.getEntity();
                Intrinsics.checkNotNull((Object)pokemonEntity);
                if (!pokemonEntity.isBattling()) break block7;
            }
            return false;
        }
        boolean isDamageSourcePokemon = damageSource.method_5529() instanceof PokemonEntity;
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        double defense = (double)pokemon.getStat((Stat)Stats.DEFENCE) / 300.0;
        double configMultiplier = isDamageSourcePokemon ? 1.0 : SimpleConfig.INSTANCE.getPlayerDamageMultiplier();
        double damage = (double)f * (1.0 - defense) * configMultiplier;
        boolean result = super.method_5643(damageSource, (float)damage);
        Pokemon pokemon3 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon3);
        Pokemon pokemon4 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon4);
        pokemon3.setCurrentHealth(Math.max(0, pokemon4.getCurrentHealth() - (int)damage));
        Pokemon pokemon5 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon5);
        if (pokemon5.getCurrentHealth() <= 0) {
            Pokemon pokemon6 = this.pokemon;
            if (pokemon6 != null && (pokemon6 = pokemon6.getEntity()) != null) {
                pokemon6.method_6033(0.0f);
            }
            return super.method_5643(damageSource, Float.MAX_VALUE);
        }
        Pokemon pokemon7 = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon7);
        if (pokemon7.getEntity() != null) {
            Pokemon pokemon8 = this.pokemon;
            Intrinsics.checkNotNull((Object)pokemon8);
            PokemonEntity pokemonEntity = pokemon8.getEntity();
            Intrinsics.checkNotNull((Object)pokemonEntity);
            Pokemon pokemon9 = this.pokemon;
            Intrinsics.checkNotNull((Object)pokemon9);
            pokemonEntity.method_6033((float)pokemon9.getCurrentHealth());
        }
        return result;
    }

    private final void updateTargetBehavior(class_1309 target) {
        if (target instanceof class_1308) {
            ((class_1308)target).method_5980((class_1309)this);
        }
    }

    @Override
    public double getMoveEffectiveness(@Nullable Move move, @NotNull ElementalType targetType) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Map map = StrongBattleAIKt.getTypeEffectiveness();
        Move move2 = move;
        Intrinsics.checkNotNull((Object)move2);
        Object object = (Map)map.get(move2.getType());
        return object != null && (object = (Double)object.get(targetType)) != null ? (Double)object : 0.0;
    }

    private final List<Triple<Move, Double, Double>> mapMoves(MoveSet moveSet, Pokemon pokemonTarget) {
        List mappedMoves = new ArrayList();
        for (Move move : moveSet) {
            double d;
            double primaryTypeEffectiveness = this.getMoveEffectiveness(move, pokemonTarget.getPrimaryType());
            if (pokemonTarget.getSecondaryType() != null) {
                ElementalType it;
                boolean bl = false;
                d = this.getMoveEffectiveness(move, it);
            } else {
                d = 0.0;
            }
            double secondaryTypeEffectiveness = d;
            mappedMoves.add(new Triple((Object)move, (Object)(primaryTypeEffectiveness + secondaryTypeEffectiveness), (Object)move.getPower()));
        }
        return mappedMoves;
    }

    private final int compareMoves(Triple<? extends Move, Double, Double> move1, Triple<? extends Move, Double, Double> move2) {
        double move1Value = ((Number)move1.getSecond()).doubleValue() * ((Number)move1.getThird()).doubleValue();
        double move2Value = ((Number)move2.getSecond()).doubleValue() * ((Number)move2.getThird()).doubleValue();
        return Double.compare(move1Value, move2Value);
    }

    private final void givePokemonExperience(Pokemon attacker) {
        if (this.pokemon == null) {
            return;
        }
        BattlePokemon attackerBattle = BattlePokemon.Companion.safeCopyOf(attacker);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        attackerBattle.setActor((BattleActor)new PokemonBattleActor(uUID, attackerBattle, 10.0f, (BattleAI)new RandomBattleAI()));
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        BattlePokemon pokemonBattle = BattlePokemon.Companion.safeCopyOf(pokemon);
        UUID uUID2 = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
        pokemonBattle.setActor((BattleActor)new PokemonBattleActor(uUID2, pokemonBattle, 10.0f, (BattleAI)new RandomBattleAI()));
        int experienceResult = StandardExperienceCalculator.INSTANCE.calculate(attackerBattle, pokemonBattle, 1.0);
        PokemonEntity pokemonEntity = this.hostilemonAttacker;
        Intrinsics.checkNotNull((Object)pokemonEntity);
        pokemonEntity.getPokemon().addExperience((ExperienceSource)new SidemodExperienceSource(CobbleGuard.MODID), experienceResult);
    }

    @NotNull
    public class_1269 method_5664(@NotNull class_1657 player, @NotNull class_243 vec3, @NotNull class_1268 interactionHand) {
        boolean isGuardItem;
        class_9279 customData;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)vec3, (String)"vec3");
                Intrinsics.checkNotNullParameter((Object)interactionHand, (String)"interactionHand");
                if (this.pokemon == null) break block5;
                Pokemon pokemon = this.pokemon;
                Intrinsics.checkNotNull((Object)pokemon);
                if (Intrinsics.areEqual((Object)pokemon.getOwnerUUID(), (Object)player.method_5667())) break block6;
            }
            return class_1269.field_5814;
        }
        if (this.getAggressivity() == null) {
            this.setAggressivity(Hostilemon.Aggresivity.DEFENSIVE);
        }
        class_9279 class_92792 = customData = (class_9279)player.method_6047().method_57824(class_9334.field_49628);
        boolean bl = class_92792 != null ? class_92792.method_57450("isGuardItem") : (isGuardItem = false);
        if (!player.method_5715() && interactionHand == class_1268.field_5808 && isGuardItem) {
            this.setAggressivity(this.getAggressivity().next());
            player.method_43496((class_2561)class_2561.method_43470((String)this.getAggressivity().getMessage()));
        }
        class_1269 class_12692 = super.method_5664(player, vec3, interactionHand);
        Intrinsics.checkNotNullExpressionValue((Object)class_12692, (String)"interactAt(...)");
        return class_12692;
    }

    public void method_5650(@NotNull class_1297.class_5529 removalReason) {
        Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
        if (removalReason == class_1297.class_5529.field_26998 && this.hostilemonAttacker != null) {
            PokemonEntity pokemonEntity = this.hostilemonAttacker;
            Intrinsics.checkNotNull((Object)pokemonEntity);
            this.givePokemonExperience(pokemonEntity.getPokemon());
        }
        super.method_5650(removalReason);
    }

    public void method_6005(double d, double e, double f) {
        if (this.pokemon == null) {
            super.method_6005(d, e, f);
        }
        Pokemon pokemon = this.pokemon;
        Intrinsics.checkNotNull((Object)pokemon);
        double power = (double)pokemon.getAttack() / 75.0;
        super.method_6005(d * power, e * power, f * power);
    }

    @NotNull
    public BrainActivityGroup<? extends PokemonMixin> getCoreTasks() {
        class_4097[] class_4097Array = new class_4097[1];
        ExtendedBehaviour[] extendedBehaviourArray = new ExtendedBehaviour[]{new DefendOwnerTask().startCondition(arg_0 -> PokemonMixin.getCoreTasks$lambda$5(this, arg_0)), new WildBehaviourTask().startCondition(arg_0 -> PokemonMixin.getCoreTasks$lambda$6(this, arg_0))};
        class_4097Array[0] = new AllApplicableBehaviours(extendedBehaviourArray);
        BrainActivityGroup brainActivityGroup = BrainActivityGroup.coreTasks((class_4097[])class_4097Array);
        Intrinsics.checkNotNullExpressionValue((Object)brainActivityGroup, (String)"coreTasks(...)");
        return brainActivityGroup;
    }

    @NotNull
    public List<? extends ExtendedSensor<? extends PokemonMixin>> getSensors() {
        List sensors = new ArrayList();
        sensors.add((ExtendedSensor)new NearestOwnerTargetSensor());
        sensors.add((ExtendedSensor)new NearestWildTargetSensor());
        return sensors;
    }

    @NotNull
    protected class_4095.class_5303<?> method_28306() {
        return (class_4095.class_5303)new SmartBrainProvider((class_1309)this);
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
    }

    private static final int getBestMoveAgainst$lambda$0(PokemonMixin this$0, Triple move1, Triple move2) {
        Intrinsics.checkNotNull((Object)move1);
        Intrinsics.checkNotNull((Object)move2);
        return this$0.compareMoves((Triple<? extends Move, Double, Double>)move1, (Triple<? extends Move, Double, Double>)move2);
    }

    private static final int getBestMoveAgainst$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void shootProjectile$lambda$3(PokemonMixin this$0, class_1676 $projectile) {
        this$0.method_37908().method_8649((class_1297)$projectile);
    }

    private static final boolean getCoreTasks$lambda$5(PokemonMixin this$0, PokemonEntity entity) {
        PokemonEntity pokemonEntity = entity;
        Intrinsics.checkNotNull((Object)pokemonEntity);
        return pokemonEntity.method_18868().method_18904(PokemonMemoryModuleType.INSTANCE.getNEAREST_OWNER_TARGET()).isPresent() && Timer.INSTANCE.hasReached(this$0.method_5667() + "_defend_task_cooldown", 0.5);
    }

    private static final boolean getCoreTasks$lambda$6(PokemonMixin this$0, PokemonEntity entity) {
        PokemonEntity pokemonEntity = entity;
        Intrinsics.checkNotNull((Object)pokemonEntity);
        return pokemonEntity.method_18868().method_18904(PokemonMemoryModuleType.INSTANCE.getNEAREST_WILD_POKEMON_TARGET()).isPresent() && Timer.INSTANCE.hasReached(this$0.method_5667() + "_wild_task_cooldown", 0.5);
    }
}

