/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobbleguard.util;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\rJ\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/zanckor/cobbleguard/util/Timer;", "", "<init>", "()V", "", "name", "", "timeInSeconds", "", "start", "(Ljava/lang/String;D)V", "", "hasTimer", "(Ljava/lang/String;)Z", "removeOnReach", "hasReached", "(Ljava/lang/String;Z)Z", "(Ljava/lang/String;D)Z", "isRunning", "", "addTime", "(Ljava/lang/String;J)V", "", "timeToFinish", "(Ljava/lang/String;)I", "Ljava/util/HashMap;", "TIMERS", "Ljava/util/HashMap;", "CobbleGuard"})
public final class Timer {
    @NotNull
    public static final Timer INSTANCE = new Timer();
    @NotNull
    private static final HashMap<String, Long> TIMERS = new HashMap();

    private Timer() {
    }

    public final void start(@NotNull String name, double timeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Map)TIMERS).put(name, (long)((double)System.currentTimeMillis() + timeInSeconds * (double)1000));
    }

    public final boolean hasTimer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TIMERS.containsKey(name);
    }

    public final boolean hasReached(@NotNull String name, boolean removeOnReach) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (TIMERS.containsKey(name)) {
            Long l = TIMERS.get(name);
            Intrinsics.checkNotNull((Object)l);
            long timer = ((Number)l).longValue();
            if (System.currentTimeMillis() >= timer) {
                if (removeOnReach) {
                    TIMERS.remove(name);
                }
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public final boolean hasReached(@NotNull String name, double timeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (TIMERS.containsKey(name)) {
            Long l = TIMERS.get(name);
            Intrinsics.checkNotNull((Object)l);
            long timer = ((Number)l).longValue();
            if (System.currentTimeMillis() >= timer) {
                this.start(name, timeInSeconds);
                return true;
            }
        } else {
            this.start(name, timeInSeconds);
            return true;
        }
        return false;
    }

    public final boolean isRunning(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TIMERS.containsKey(name) && this.hasReached(name, false);
    }

    public final void addTime(@NotNull String name, long timeInSeconds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (TIMERS.containsKey(name)) {
            Map map = TIMERS;
            Long l = TIMERS.get(name);
            Intrinsics.checkNotNull((Object)l);
            map.put(name, ((Number)l).longValue() + timeInSeconds * (long)1000);
        }
    }

    public final int timeToFinish(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (TIMERS.containsKey(name)) {
            Long l = TIMERS.get(name);
            Intrinsics.checkNotNull((Object)l);
            return (int)((((Number)l).longValue() - System.currentTimeMillis()) / (long)1000);
        }
        return -1;
    }
}

