/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import cjminecraft.doubleslabs.api.ServerWorldWrapper;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.WorldWrapper;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class BlockInfo
implements IBlockInfo,
INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    private ISlabSupport support;
    private IBlockState state;
    private TileEntity tile;
    private World world;
    private final SlabTileEntity slab;
    private final boolean positive;

    public BlockInfo(SlabTileEntity slab, boolean positive) {
        this.slab = slab;
        this.positive = positive;
    }

    @Override
    @Nullable
    public IBlockState getBlockState() {
        return this.state;
    }

    @Override
    @Nullable
    public IBlockState getExtendedBlockState() {
        return this.state != null ? this.state.func_177230_c().getExtendedState(this.state, (IBlockAccess)this.getWorld(), this.getPos()) : null;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.tile;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public BlockPos getPos() {
        return this.slab.func_174877_v();
    }

    @Override
    @Nullable
    public ISlabSupport getSupport() {
        return this.support;
    }

    @Override
    public void setBlockState(@Nullable IBlockState state) {
        if (this.state != null && this.state.func_177230_c().hasTileEntity(this.state) && this.tile != null) {
            this.tile.func_145836_u();
        }
        if (this.state != null && state != null && (this.state.func_177230_c() != state.func_177230_c() || !state.func_177230_c().hasTileEntity(state)) && this.state.func_177230_c().hasTileEntity(this.state)) {
            this.setTileEntity(null);
        }
        if (this.state == null) {
            this.setTileEntity(null);
        }
        this.state = state;
        if (state != null && state.func_177230_c().hasTileEntity(state)) {
            if (!(this.world instanceof IWorldWrapper)) {
                this.wrapWorld(this.world);
            }
            if (this.tile == null) {
                this.setTileEntity(state.func_177230_c().createTileEntity(this.getWorld(), state));
            } else {
                this.tile.func_145836_u();
            }
        }
        this.slab.markDirtyClient();
        this.support = state == null ? null : SlabSupport.getSlabSupport((IBlockAccess)this.getWorld(), this.getPos(), this.state);
    }

    @Override
    public void setTileEntity(@Nullable TileEntity tile) {
        if (tile != null) {
            tile.func_145834_a(this.slab.func_145831_w());
            tile.func_174878_a(this.slab.func_174877_v());
            if (this.tile != null) {
                this.tile.func_145834_a(this.slab.func_145831_w());
                this.tile.func_174878_a(this.slab.func_174877_v());
                this.tile.func_145843_s();
            }
            tile.onLoad();
            if (!(this.world instanceof IWorldWrapper)) {
                this.wrapWorld(this.world);
            }
            tile.func_145834_a(this.getWorld());
        }
        this.tile = tile;
    }

    private void wrapWorld(World world) {
        IWorldWrapper<WorldServer> w = world instanceof WorldServer ? new ServerWorldWrapper((WorldServer)world) : new WorldWrapper(world);
        w.setPositive(this.positive);
        w.setBlockPos(this.slab.func_174877_v());
        w.setStateContainer(this.slab);
        this.world = (World)w;
    }

    public void setWorld(World world) {
        if (this.world != null && this.world instanceof IWorldWrapper) {
            ((IWorldWrapper)this.world).setWorld(world);
        } else {
            this.world = this.tile != null ? (world instanceof WorldServer ? new ServerWorldWrapper((WorldServer)world) : new WorldWrapper(world)) : world;
        }
        if (this.world instanceof IWorldWrapper) {
            IWorldWrapper w = (IWorldWrapper)this.world;
            w.setPositive(this.positive);
            w.setBlockPos(this.slab.func_174877_v());
            w.setStateContainer(this.slab);
        }
        if (this.tile != null) {
            this.tile.func_145834_a(this.getWorld());
        }
    }

    public void setPos(BlockPos pos) {
        if (this.world instanceof IWorldWrapper) {
            IWorldWrapper w = (IWorldWrapper)this.world;
            w.setBlockPos(pos);
        }
        if (this.tile != null) {
            this.tile.func_174878_a(pos);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.state != null) {
            nbt.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
        }
        if (this.tile != null) {
            nbt.func_74782_a("tile", (NBTBase)this.tile.func_189515_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("state")) {
            this.state = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("state"));
        }
        if (nbt.func_74764_b("tile")) {
            this.tile = TileEntity.func_190200_a((World)this.getWorld(), (NBTTagCompound)nbt.func_74775_l("tile"));
        }
        if (this.tile != null && this.world != null && !(this.world instanceof IWorldWrapper)) {
            this.wrapWorld(this.world);
        }
    }

    public void onLoad() {
        if (this.tile != null) {
            this.tile.func_145834_a(this.getWorld());
            this.tile.func_174878_a(this.getPos());
            this.tile.onLoad();
        }
    }

    public void onChunkUnloaded() {
        if (this.tile != null) {
            this.tile.onChunkUnload();
        }
    }

    public void remove() {
        if (this.tile != null) {
            this.tile.func_145834_a(this.slab.func_145831_w());
            this.tile.func_174878_a(this.slab.func_174877_v());
            this.tile.func_145843_s();
            this.tile = null;
        }
    }

    public void validate() {
        if (this.tile != null) {
            this.tile.func_145829_t();
        }
    }

    public void updateContainingBlockInfo() {
        if (this.tile != null) {
            this.tile.func_145836_u();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.tile != null && this.tile.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.tile != null ? this.tile.getCapability(capability, facing) : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        return this.positive == blockInfo.positive && Objects.equals(this.state, blockInfo.state) && Objects.equals(this.tile, blockInfo.tile);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.tile, this.positive);
    }
}

