/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ServerWorldWrapper
extends WorldServer
implements IWorldWrapper<WorldServer> {
    private static final Field WEAK_WORLD_MAP;
    private WorldServer world;
    private boolean positive;
    private BlockPos pos;
    private IStateContainer container;

    private static void patch(ServerWorldWrapper instance) {
        if (WEAK_WORLD_MAP == null) {
            return;
        }
        try {
            ConcurrentMap map = (ConcurrentMap)WEAK_WORLD_MAP.get(null);
            map.remove(instance);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public ServerWorldWrapper(WorldServer world) {
        super(world.func_73046_m(), world.func_72860_G(), world.func_72912_H(), world.field_73011_w.getDimension(), world.field_72984_F);
        this.world = world;
        DimensionManager.setWorld((int)world.func_175624_G().func_82747_f(), (WorldServer)world, (MinecraftServer)world.func_73046_m());
        ServerWorldWrapper.patch(this);
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public void setPositive(boolean positive) {
        this.positive = positive;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public IStateContainer getStateContainer() {
        return this.container;
    }

    @Override
    public void setStateContainer(IStateContainer container) {
        this.container = container;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = (WorldServer)world;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (pos.equals((Object)this.pos)) {
            IBlockState state = this.positive ? this.container.getPositiveBlockInfo().getBlockState() : this.container.getNegativeBlockInfo().getBlockState();
            return state != null ? state : this.world.func_180495_p(pos);
        }
        return this.world.func_180495_p(pos);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return pos.equals((Object)this.pos) ? (this.positive ? this.container.getPositiveBlockInfo().getTileEntity() : this.container.getNegativeBlockInfo().getTileEntity()) : this.world.func_175625_s(pos);
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(tileEntityIn);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(tileEntityIn);
            }
        } else {
            this.world.func_175690_a(pos, tileEntityIn);
        }
    }

    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(state);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(state);
            }
            return true;
        }
        return this.world.func_175656_a(pos, state);
    }

    public void func_175713_t(BlockPos pos) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(null);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(null);
            }
        } else {
            this.world.func_175713_t(pos);
        }
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(newState);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(newState);
            }
            return true;
        }
        return this.world.func_180501_a(pos, newState, flags);
    }

    static {
        Field weakWorldMap;
        try {
            weakWorldMap = DimensionManager.class.getDeclaredField("weakWorldMap");
            weakWorldMap.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            weakWorldMap = null;
        }
        WEAK_WORLD_MAP = weakWorldMap;
    }
}

