/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;

public class WorldWrapper
extends World
implements IWorldWrapper<World> {
    private World world;
    private boolean positive;
    private BlockPos pos;
    private IStateContainer container;

    public WorldWrapper(World world) {
        super(world.func_72860_G(), world.func_72912_H(), world.field_73011_w, world.field_72984_F, world.field_72995_K);
        this.world = world;
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public void setPositive(boolean positive) {
        this.positive = positive;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public IStateContainer getStateContainer() {
        return this.container;
    }

    @Override
    public void setStateContainer(IStateContainer container) {
        this.container = container;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return pos.equals((Object)this.pos) ? (this.positive ? this.container.getPositiveBlockInfo().getBlockState() : this.container.getNegativeBlockInfo().getBlockState()) : this.world.func_180495_p(pos);
    }

    public void func_184148_a(@Nullable EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.world.func_184148_a(player, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_184138_a(BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        this.world.func_184138_a(pos, oldState, newState, flags);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return pos.equals((Object)this.pos) ? (this.positive ? this.container.getPositiveBlockInfo().getTileEntity() : this.container.getNegativeBlockInfo().getTileEntity()) : this.world.func_175625_s(pos);
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(tileEntityIn);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(tileEntityIn);
            }
        } else {
            this.world.func_175690_a(pos, tileEntityIn);
        }
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return this.world.func_73045_a(id);
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        this.world.func_175715_c(breakerId, pos, progress);
    }

    public Scoreboard func_96441_U() {
        return this.world.func_96441_U();
    }

    public void func_180498_a(@Nullable EntityPlayer player, int type, BlockPos pos, int data) {
        this.world.func_180498_a(player, type, pos, data);
    }

    public Chunk func_72964_e(int chunkX, int chunkZ) {
        return this.world.func_72964_e(chunkX, chunkZ);
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable Chunk chunk, IBlockState IBlockState2, IBlockState newState, int flags) {
        this.world.markAndNotifyBlock(pos, chunk, IBlockState2, newState, flags);
    }

    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(state);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(state);
            }
            return true;
        }
        return this.world.func_175656_a(pos, state);
    }

    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.world.func_190524_a(pos, blockIn, fromPos);
    }

    public boolean func_72935_r() {
        return this.world.func_72935_r();
    }

    public void func_184133_a(@Nullable EntityPlayer player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.world.func_184133_a(player, pos, soundIn, category, volume, pitch);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.world.func_184134_a(x, y, z, soundIn, category, volume, pitch, distanceDelay);
    }

    public float func_72929_e(float partialTicks) {
        return this.world.func_72929_e(partialTicks);
    }

    public boolean func_175700_a(TileEntity tile) {
        return this.world.func_175700_a(tile);
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        this.world.func_147448_a(tileEntityCollection);
    }

    public String func_72827_u() {
        return this.world.func_72827_u();
    }

    public void func_175713_t(BlockPos pos) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(null);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(null);
            }
        } else {
            this.world.func_175713_t(pos);
        }
    }

    public void func_72966_v() {
        this.world.func_72966_v();
    }

    public void func_72891_a(boolean hostile, boolean peaceful) {
        this.world.func_72891_a(hostile, peaceful);
    }

    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        this.world.func_175646_b(pos, unusedTileEntity);
    }

    public int func_181545_F() {
        return this.world.func_181545_F();
    }

    public int func_175676_y(BlockPos pos) {
        return this.world.func_175676_y(pos);
    }

    public boolean func_175640_z(BlockPos pos) {
        return this.world.func_175640_z(pos);
    }

    public int func_175687_A(BlockPos pos) {
        return this.world.func_175687_A(pos);
    }

    public void func_72882_A() {
        this.world.func_72882_A();
    }

    public void func_72960_a(Entity entityIn, byte state) {
        this.world.func_72960_a(entityIn, state);
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.world.func_175641_c(pos, blockIn, eventID, eventParam);
    }

    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.world.func_82736_K();
    }

    public float func_72819_i(float delta) {
        return this.world.func_72819_i(delta);
    }

    public void func_147442_i(float strength) {
        this.world.func_147442_i(strength);
    }

    public float func_72867_j(float delta) {
        return this.world.func_72867_j(delta);
    }

    public void func_72894_k(float strength) {
        this.world.func_72894_k(strength);
    }

    public boolean func_72911_I() {
        return this.world.func_72911_I();
    }

    public boolean func_72896_J() {
        return this.world.func_72896_J();
    }

    public boolean func_175727_C(BlockPos position) {
        return this.world.func_175727_C(position);
    }

    public boolean func_180502_D(BlockPos pos) {
        return this.world.func_180502_D(pos);
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        this.world.func_175669_a(id, pos, data);
    }

    public void func_175666_e(BlockPos pos, Block blockIn) {
        this.world.func_175666_e(pos, blockIn);
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.world.func_175649_E(pos);
    }

    public int func_175657_ab() {
        return this.world.func_175657_ab();
    }

    public WorldBorder func_175723_af() {
        return this.world.func_175723_af();
    }

    public void func_175718_b(int type, BlockPos pos, int data) {
        this.world.func_175718_b(type, pos, data);
    }

    public int func_72800_K() {
        return this.world.func_72800_K();
    }

    public List<Entity> func_72839_b(@Nullable Entity entityIn, AxisAlignedBB bb) {
        return this.world.func_72839_b(entityIn, bb);
    }

    public <T extends Entity> List<T> func_72872_a(Class<? extends T> p_217357_1_, AxisAlignedBB p_217357_2_) {
        return this.world.func_72872_a(p_217357_1_, p_217357_2_);
    }

    @Nullable
    public EntityPlayer func_184137_a(double x, double y, double z, double distance, boolean creativePlayers) {
        return this.world.func_184137_a(x, y, z, distance, creativePlayers);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    protected IChunkProvider func_72970_h() {
        return this.world.func_72863_F();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.world.func_175623_d(pos);
    }

    public boolean func_72953_d(AxisAlignedBB bb) {
        return this.world.func_72953_d(bb);
    }

    public int func_175699_k(BlockPos pos) {
        return this.world.func_175699_k(pos);
    }

    public boolean func_175667_e(BlockPos pos) {
        return this.world.func_175667_e(pos);
    }

    public boolean func_175697_a(BlockPos center, int range) {
        return this.world.func_175697_a(center, range);
    }

    public boolean func_175707_a(BlockPos from, BlockPos to) {
        return this.world.func_175707_a(from, to);
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return false;
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return this.world.func_175655_b(pos, dropBlock);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(newState);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(newState);
            }
            return true;
        }
        return this.world.func_180501_a(pos, newState, flags);
    }

    public void func_72974_f() {
        this.world.func_72974_f();
    }

    public IBlockState func_184141_c(BlockPos pos) {
        return this.world.func_184141_c(pos);
    }

    public boolean func_72829_c(AxisAlignedBB bb) {
        return this.world.func_72829_c(bb);
    }

    public boolean func_147470_e(AxisAlignedBB bb) {
        return this.world.func_147470_e(bb);
    }

    public boolean func_72875_a(AxisAlignedBB bb, Material materialIn) {
        return this.world.func_72875_a(bb, materialIn);
    }

    public void calculateInitialWeatherBody() {
        this.world.calculateInitialWeatherBody();
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public long func_72905_C() {
        return this.world.func_72905_C();
    }

    public BlockPos func_175694_M() {
        return this.world.func_175694_M();
    }

    public void func_175652_B(BlockPos pos) {
        this.world.func_175652_B(pos);
    }

    public int func_72940_L() {
        return this.world.func_72940_L();
    }

    public float func_130001_d() {
        return this.world.func_130001_d();
    }

    public float func_72826_c(float partialTicks) {
        return this.world.func_72826_c(partialTicks);
    }

    public int func_72853_d() {
        return this.world.func_72853_d();
    }

    public float func_72971_b(float partialTicks) {
        return this.world.func_72971_b(partialTicks);
    }

    public float getSunBrightnessBody(float partialTicks) {
        return this.world.getSunBrightnessBody(partialTicks);
    }

    public Vec3d func_72824_f(float partialTicks) {
        return this.world.func_72824_f(partialTicks);
    }

    public Vec3d getCloudColorBody(float partialTicks) {
        return this.world.getCloudColorBody(partialTicks);
    }

    public Vec3d func_72948_g(float partialTicks) {
        return this.world.func_72948_g(partialTicks);
    }

    public float func_72880_h(float partialTicks) {
        return this.world.func_72880_h(partialTicks);
    }

    public float getStarBrightnessBody(float partialTicks) {
        return this.world.getStarBrightnessBody(partialTicks);
    }

    public double func_72919_O() {
        return this.world.func_72919_O();
    }

    public int func_175658_ac() {
        return this.world.func_175658_ac();
    }

    public void func_175702_c(int lastLightningBoltIn) {
        this.world.func_175702_c(lastLightningBoltIn);
    }

    public World func_175643_b() {
        return this.world.func_175643_b();
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return this.world.getBiomeForCoordsBody(pos);
    }

    public BiomeProvider func_72959_q() {
        return this.world.func_72959_q();
    }

    public void func_72963_a(WorldSettings settings) {
        this.world.func_72963_a(settings);
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return this.world.func_73046_m();
    }

    public boolean func_175701_a(BlockPos pos) {
        return this.world.func_175701_a(pos);
    }

    public boolean func_189509_E(BlockPos pos) {
        return this.world.func_189509_E(pos);
    }

    public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
        return this.world.func_175668_a(pos, allowEmpty);
    }

    public boolean func_175648_a(BlockPos center, int radius, boolean allowEmpty) {
        return this.world.func_175648_a(center, radius, allowEmpty);
    }

    public boolean func_175706_a(BlockPos from, BlockPos to, boolean allowEmpty) {
        return this.world.func_175706_a(from, to, allowEmpty);
    }

    public boolean func_175711_a(StructureBoundingBox box) {
        return this.world.func_175711_a(box);
    }

    public boolean func_175639_b(StructureBoundingBox box, boolean allowEmpty) {
        return this.world.func_175639_b(box, allowEmpty);
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.world.func_175726_f(pos);
    }

    public boolean func_190526_b(int x, int z) {
        return this.world.func_190526_b(x, z);
    }

    public boolean func_175698_g(BlockPos pos) {
        return this.world.func_175698_g(pos);
    }

    public void func_175722_b(BlockPos pos, Block blockType, boolean updateObservers) {
        this.world.func_175722_b(pos, blockType, updateObservers);
    }

    public void func_72975_g(int x, int z, int y1, int y2) {
        this.world.func_72975_g(x, z, y1, y2);
    }

    public void func_175704_b(BlockPos rangeMin, BlockPos rangeMax) {
        this.world.func_175704_b(rangeMin, rangeMax);
    }

    public void func_147458_c(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.world.func_147458_c(x1, y1, z1, x2, y2, z2);
    }

    public void func_190522_c(BlockPos pos, Block blockType) {
        this.world.func_190522_c(pos, blockType);
    }

    public void func_175685_c(BlockPos pos, Block blockType, boolean updateObservers) {
        this.world.func_175685_c(pos, blockType, updateObservers);
    }

    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        this.world.func_175695_a(pos, blockType, skipSide);
    }

    public void func_190529_b(BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        this.world.func_190529_b(pos, changedBlock, changedBlockPos);
    }

    public boolean func_175691_a(BlockPos pos, Block blockType) {
        return this.world.func_175691_a(pos, blockType);
    }

    public boolean func_175678_i(BlockPos pos) {
        return this.world.func_175678_i(pos);
    }

    public boolean func_175710_j(BlockPos pos) {
        return this.world.func_175710_j(pos);
    }

    public int func_175671_l(BlockPos pos) {
        return this.world.func_175671_l(pos);
    }

    public int func_175721_c(BlockPos pos, boolean checkNeighbors) {
        return this.world.func_175721_c(pos, checkNeighbors);
    }

    public BlockPos func_175645_m(BlockPos pos) {
        return this.world.func_175645_m(pos);
    }

    public int func_189649_b(int x, int z) {
        return this.world.func_189649_b(x, z);
    }

    public int func_82734_g(int x, int z) {
        return this.world.func_82734_g(x, z);
    }

    public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
        return this.world.func_175705_a(type, pos);
    }

    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        return this.world.func_175642_b(type, pos);
    }

    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        this.world.func_175653_a(type, pos, lightValue);
    }

    public void func_175679_n(BlockPos pos) {
        this.world.func_175679_n(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.world.func_175626_b(pos, lightValue);
    }

    public float func_175724_o(BlockPos pos) {
        return this.world.func_175724_o(pos);
    }

    @Nullable
    public RayTraceResult func_72933_a(Vec3d start, Vec3d end) {
        return this.world.func_72933_a(start, end);
    }

    @Nullable
    public RayTraceResult func_72901_a(Vec3d start, Vec3d end, boolean stopOnLiquid) {
        return this.world.func_72901_a(start, end, stopOnLiquid);
    }

    @Nullable
    public RayTraceResult func_147447_a(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return this.world.func_147447_a(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public void func_184149_a(BlockPos blockPositionIn, @Nullable SoundEvent soundEventIn) {
        this.world.func_184149_a(blockPositionIn, soundEventIn);
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.world.func_175688_a(particleType, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190523_a(int id, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.world.func_190523_a(id, x, y, z, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.world.func_175682_a(particleType, ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public boolean func_72942_c(Entity entityIn) {
        return this.world.func_72942_c(entityIn);
    }

    public boolean func_72838_d(Entity entityIn) {
        return this.world.func_72838_d(entityIn);
    }

    public void func_72923_a(Entity entityIn) {
        this.world.func_72923_a(entityIn);
    }

    public void func_72847_b(Entity entityIn) {
        this.world.func_72847_b(entityIn);
    }

    public void func_72900_e(Entity entityIn) {
        this.world.func_72900_e(entityIn);
    }

    public void func_72973_f(Entity entityIn) {
        this.world.func_72973_f(entityIn);
    }

    public void func_72954_a(IWorldEventListener listener) {
        this.world.func_72954_a(listener);
    }

    public List<AxisAlignedBB> func_184144_a(@Nullable Entity entityIn, AxisAlignedBB aabb) {
        return this.world.func_184144_a(entityIn, aabb);
    }

    public void func_72848_b(IWorldEventListener listener) {
        this.world.func_72848_b(listener);
    }

    public boolean func_191503_g(Entity entityToCheck) {
        return this.world.func_191503_g(entityToCheck);
    }

    public boolean func_184143_b(AxisAlignedBB bbox) {
        return this.world.func_184143_b(bbox);
    }

    public int func_72967_a(float partialTicks) {
        return this.world.func_72967_a(partialTicks);
    }

    public float getSunBrightnessFactor(float partialTicks) {
        return this.world.getSunBrightnessFactor(partialTicks);
    }

    public Vec3d func_72833_a(Entity entityIn, float partialTicks) {
        return this.world.func_72833_a(entityIn, partialTicks);
    }

    public Vec3d getSkyColorBody(Entity entityIn, float partialTicks) {
        return this.world.getSkyColorBody(entityIn, partialTicks);
    }

    public float getCurrentMoonPhaseFactorBody() {
        return this.world.getCurrentMoonPhaseFactorBody();
    }

    public BlockPos func_175725_q(BlockPos pos) {
        return this.world.func_175725_q(pos);
    }

    public BlockPos func_175672_r(BlockPos pos) {
        return this.world.func_175672_r(pos);
    }

    public boolean func_184145_b(BlockPos pos, Block blk) {
        return this.world.func_184145_b(pos, blk);
    }

    public void func_175684_a(BlockPos pos, Block blockIn, int delay) {
        this.world.func_175684_a(pos, blockIn, delay);
    }

    public void func_175654_a(BlockPos pos, Block blockIn, int delay, int priority) {
        this.world.func_175654_a(pos, blockIn, delay, priority);
    }

    public void func_180497_b(BlockPos pos, Block blockIn, int delay, int priority) {
        this.world.func_180497_b(pos, blockIn, delay, priority);
    }

    public void func_72939_s() {
        this.world.func_72939_s();
    }

    public void func_72870_g(Entity ent) {
        this.world.func_72870_g(ent);
    }

    public void func_72866_a(Entity entityIn, boolean forceUpdate) {
        this.world.func_72866_a(entityIn, forceUpdate);
    }

    public boolean func_72855_b(AxisAlignedBB bb) {
        return this.world.func_72855_b(bb);
    }

    public boolean func_72917_a(AxisAlignedBB bb, @Nullable Entity entityIn) {
        return this.world.func_72917_a(bb, entityIn);
    }

    public boolean func_72918_a(AxisAlignedBB bb, Material materialIn, Entity entityIn) {
        return this.world.func_72918_a(bb, materialIn, entityIn);
    }

    public Explosion func_72876_a(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean damagesTerrain) {
        return this.world.func_72876_a(entityIn, x, y, z, strength, damagesTerrain);
    }

    public Explosion func_72885_a(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        return this.world.func_72885_a(entityIn, x, y, z, strength, causesFire, damagesTerrain);
    }

    public float func_72842_a(Vec3d vec, AxisAlignedBB bb) {
        return this.world.func_72842_a(vec, bb);
    }

    public boolean func_175719_a(@Nullable EntityPlayer player, BlockPos pos, EnumFacing side) {
        return this.world.func_175719_a(player, pos, side);
    }

    public String func_72981_t() {
        return this.world.func_72981_t();
    }

    public void func_147457_a(TileEntity tileEntityIn) {
        this.world.func_147457_a(tileEntityIn);
    }

    public boolean func_175665_u(BlockPos pos) {
        return this.world.func_175665_u(pos);
    }

    public boolean func_175677_d(BlockPos pos, boolean _default) {
        return this.world.func_175677_d(pos, _default);
    }

    public void func_72835_b() {
        this.world.func_72835_b();
    }

    public void updateWeatherBody() {
        this.world.updateWeatherBody();
    }

    public void func_189507_a(BlockPos pos, IBlockState state, Random random) {
        this.world.func_189507_a(pos, state, random);
    }

    public boolean func_175675_v(BlockPos pos) {
        return this.world.func_175675_v(pos);
    }

    public boolean func_175662_w(BlockPos pos) {
        return this.world.func_175662_w(pos);
    }

    public boolean func_175670_e(BlockPos pos, boolean noWaterAdj) {
        return this.world.func_175670_e(pos, noWaterAdj);
    }

    public boolean canBlockFreezeBody(BlockPos pos, boolean noWaterAdj) {
        return this.world.canBlockFreezeBody(pos, noWaterAdj);
    }

    public boolean func_175708_f(BlockPos pos, boolean checkLight) {
        return this.world.func_175708_f(pos, checkLight);
    }

    public boolean canSnowAtBody(BlockPos pos, boolean checkLight) {
        return this.world.canSnowAtBody(pos, checkLight);
    }

    public boolean func_175664_x(BlockPos pos) {
        return this.world.func_175664_x(pos);
    }

    public boolean func_180500_c(EnumSkyBlock lightType, BlockPos pos) {
        return this.world.func_180500_c(lightType, pos);
    }

    public boolean func_72955_a(boolean runAllPending) {
        return this.world.func_72955_a(runAllPending);
    }

    @Nullable
    public List<NextTickListEntry> func_72920_a(Chunk chunkIn, boolean remove) {
        return this.world.func_72920_a(chunkIn, remove);
    }

    @Nullable
    public List<NextTickListEntry> func_175712_a(StructureBoundingBox structureBB, boolean remove) {
        return this.world.func_175712_a(structureBB, remove);
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return this.world.func_175674_a(entityIn, boundingBox, predicate);
    }

    public <T extends Entity> List<T> func_175644_a(Class<? extends T> entityType, Predicate<? super T> filter) {
        return this.world.func_175644_a(entityType, filter);
    }

    public <T extends Entity> List<T> func_175661_b(Class<? extends T> playerType, Predicate<? super T> filter) {
        return this.world.func_175661_b(playerType, filter);
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return this.world.func_175647_a(clazz, aabb, filter);
    }

    @Nullable
    public <T extends Entity> T func_72857_a(Class<? extends T> entityType, AxisAlignedBB aabb, T closestTo) {
        return (T)this.world.func_72857_a(entityType, aabb, closestTo);
    }

    public List<Entity> func_72910_y() {
        return this.world.func_72910_y();
    }

    public int func_72907_a(Class<?> entityType) {
        return this.world.func_72907_a(entityType);
    }

    public void func_175650_b(Collection<Entity> entityCollection) {
        this.world.func_175650_b(entityCollection);
    }

    public void func_175681_c(Collection<Entity> entityCollection) {
        this.world.func_175681_c(entityCollection);
    }

    public boolean func_190527_a(Block blockIn, BlockPos pos, boolean skipCollisionCheck, EnumFacing sidePlacedOn, @Nullable Entity placer) {
        return this.world.func_190527_a(blockIn, pos, skipCollisionCheck, sidePlacedOn, placer);
    }

    public void func_181544_b(int seaLevelIn) {
        this.world.func_181544_b(seaLevelIn);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public boolean func_175709_b(BlockPos pos, EnumFacing side) {
        return this.world.func_175709_b(pos, side);
    }

    public int func_175651_c(BlockPos pos, EnumFacing facing) {
        return this.world.func_175651_c(pos, facing);
    }

    @Nullable
    public EntityPlayer func_72890_a(Entity entityIn, double distance) {
        return this.world.func_72890_a(entityIn, distance);
    }

    @Nullable
    public EntityPlayer func_184136_b(Entity entityIn, double distance) {
        return this.world.func_184136_b(entityIn, distance);
    }

    @Nullable
    public EntityPlayer func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        return this.world.func_190525_a(x, y, z, distance, predicate);
    }

    public boolean func_175636_b(double x, double y, double z, double range) {
        return this.world.func_175636_b(x, y, z, range);
    }

    @Nullable
    public EntityPlayer func_184142_a(Entity entityIn, double maxXZDistance, double maxYDistance) {
        return this.world.func_184142_a(entityIn, maxXZDistance, maxYDistance);
    }

    @Nullable
    public EntityPlayer func_184139_a(BlockPos pos, double maxXZDistance, double maxYDistance) {
        return this.world.func_184139_a(pos, maxXZDistance, maxYDistance);
    }

    @Nullable
    public EntityPlayer func_184150_a(double posX, double posY, double posZ, double maxXZDistance, double maxYDistance, @Nullable Function<EntityPlayer, Double> playerToDouble, @Nullable Predicate<EntityPlayer> predicate) {
        return this.world.func_184150_a(posX, posY, posZ, maxXZDistance, maxYDistance, playerToDouble, predicate);
    }

    @Nullable
    public EntityPlayer func_72924_a(String name) {
        return this.world.func_72924_a(name);
    }

    @Nullable
    public EntityPlayer func_152378_a(UUID uuid) {
        return this.world.func_152378_a(uuid);
    }

    public void func_72906_B() throws MinecraftException {
        this.world.func_72906_B();
    }

    public void func_82738_a(long worldTime) {
        this.world.func_82738_a(worldTime);
    }

    public long func_82737_E() {
        return this.world.func_82737_E();
    }

    public long func_72820_D() {
        return this.world.func_72820_D();
    }

    public void func_72877_b(long time) {
        this.world.func_72877_b(time);
    }

    public void func_72897_h(Entity entityIn) {
        this.world.func_72897_h(entityIn);
    }

    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        return this.world.func_175660_a(player, pos);
    }

    public boolean canMineBlockBody(EntityPlayer player, BlockPos pos) {
        return this.world.canMineBlockBody(player, pos);
    }

    public IChunkProvider func_72863_F() {
        return this.world.func_72863_F();
    }

    public ISaveHandler func_72860_G() {
        return this.world.func_72860_G();
    }

    public void func_72854_c() {
        this.world.func_72854_c();
    }

    @Nullable
    public MapStorage func_175693_T() {
        return this.world.func_175693_T();
    }

    public void func_72823_a(String dataID, WorldSavedData worldSavedDataIn) {
        this.world.func_72823_a(dataID, worldSavedDataIn);
    }

    @Nullable
    public WorldSavedData func_72943_a(Class<? extends WorldSavedData> clazz, String dataID) {
        return this.world.func_72943_a(clazz, dataID);
    }

    public int func_72841_b(String key) {
        return this.world.func_72841_b(key);
    }

    public Random func_72843_D(int seedX, int seedY, int seedZ) {
        return this.world.func_72843_D(seedX, seedY, seedZ);
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        return this.world.func_72914_a(report);
    }

    public Calendar func_83015_S() {
        return this.world.func_83015_S();
    }

    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable NBTTagCompound compound) {
        this.world.func_92088_a(x, y, z, motionX, motionY, motionZ, compound);
    }

    public EnumDifficulty func_175659_aa() {
        return this.world.func_175659_aa();
    }

    public void func_175692_b(int newSkylightSubtracted) {
        this.world.func_175692_b(newSkylightSubtracted);
    }

    public VillageCollection func_175714_ae() {
        return this.world.func_175714_ae();
    }

    public boolean func_72916_c(int x, int z) {
        return this.world.func_72916_c(x, z);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side) {
        return this.world.isSideSolid(pos, side);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.world.isSideSolid(pos, side, _default);
    }

    public ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunks() {
        return this.world.getPersistentChunks();
    }

    public Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> chunkIterator) {
        return this.world.getPersistentChunkIterable(chunkIterator);
    }

    public int getBlockLightOpacity(BlockPos pos) {
        return this.world.getBlockLightOpacity(pos);
    }

    public int countEntities(EnumCreatureType type, boolean forSpawnCount) {
        return this.world.countEntities(type, forSpawnCount);
    }

    public void markTileEntitiesInChunkForRemoval(Chunk chunk) {
        this.world.markTileEntitiesInChunkForRemoval(chunk);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.world.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)this.world.getCapability(capability, facing);
    }

    public MapStorage getPerWorldStorage() {
        return this.world.getPerWorldStorage();
    }

    public void func_184135_a(Packet<?> packetIn) {
        this.world.func_184135_a(packetIn);
    }

    public LootTableManager func_184146_ak() {
        return this.world.func_184146_ak();
    }

    @Nullable
    public BlockPos func_190528_a(String structureName, BlockPos position, boolean findUnexplored) {
        return this.world.func_190528_a(structureName, position, findUnexplored);
    }
}

