/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.atum2;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SlabSupportProvider(modid="atum")
public class Atum2SlabSupport<T extends Enum<T>>
implements IHorizontalSlabSupport {
    private final Class<?> slab;
    private final PropertyEnum<T> slabTypeProperty;
    private final T[] slabTypes;

    public Atum2SlabSupport() {
        Enum[] slabTypes;
        PropertyEnum slabTypeProperty;
        Class<?> slab;
        try {
            slab = Class.forName("com.teammetallurgy.atum.blocks.base.BlockAtumSlab");
            slabTypeProperty = (PropertyEnum)slab.getField("TYPE").get(null);
            Class<?> slabType = Class.forName("com.teammetallurgy.atum.blocks.base.BlockAtumSlab$Type");
            slabTypes = (Enum[])slabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            slabTypeProperty = null;
            slabTypes = null;
        }
        this.slab = slab;
        this.slabTypeProperty = slabTypeProperty;
        this.slabTypes = slabTypes;
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof ItemBlock && this.slab.isAssignableFrom(((ItemBlock)item).func_179223_d().getClass());
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && this.slab.isAssignableFrom(block.getClass());
    }

    @Override
    public boolean isHorizontalSlab(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && state.func_177229_b(this.slabTypeProperty) != this.slabTypes[2];
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        return this.slab != null && state.func_177229_b(this.slabTypeProperty) == this.slabTypes[1] ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        return this.slab != null ? state.func_177226_a(this.slabTypeProperty, half == null ? this.slabTypes[2] : (half == BlockSlab.EnumBlockHalf.BOTTOM ? this.slabTypes[1] : this.slabTypes[0])) : state;
    }

    @Override
    public boolean areSame(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        return state.func_177230_c() == ((ItemBlock)stack.func_77973_b()).func_179223_d();
    }
}

