/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.conquestreforged;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@SlabSupportProvider(modid="conquest")
public class ConquestReforgedSlabSupport
implements IHorizontalSlabSupport {
    private final Class<?> slab;
    private final PropertyEnum<BlockTrapDoor.DoorHalf> slabHalfProperty;

    public ConquestReforgedSlabSupport() {
        PropertyEnum slabHalfProperty;
        Class<?> slab;
        try {
            slab = Class.forName("com.conquestreforged.common.block.SlabDirectionalBlock");
            slabHalfProperty = (PropertyEnum)slab.getField("HALF").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            slabHalfProperty = null;
        }
        this.slab = slab;
        this.slabHalfProperty = slabHalfProperty;
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && this.slab.isAssignableFrom(block.getClass());
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof ItemBlock && this.slab.isAssignableFrom(((ItemBlock)item).func_179223_d().getClass());
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        return this.slab != null && state.func_177229_b(this.slabHalfProperty) == BlockTrapDoor.DoorHalf.BOTTOM ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        return this.slab != null ? state.func_177226_a(this.slabHalfProperty, (Comparable)(half == BlockSlab.EnumBlockHalf.BOTTOM ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP)) : state;
    }

    @Override
    public boolean areSame(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        return state.func_177230_c() == ((ItemBlock)stack.func_77973_b()).func_179223_d();
    }
}

