/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.engineersdecor;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SlabSupportProvider(modid="engineersdecor")
public class EngineersDecorSlabSupport
implements IHorizontalSlabSupport {
    private final Class<?> slab;
    private final PropertyInteger parts;

    public EngineersDecorSlabSupport() {
        PropertyInteger parts;
        Class<?> slab;
        try {
            slab = Class.forName("wile.engineersdecor.blocks.BlockDecorSlab");
            parts = (PropertyInteger)slab.getField("PARTS").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            parts = null;
        }
        this.slab = slab;
        this.parts = parts;
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && block.getClass().equals(this.slab);
    }

    @Override
    public boolean isHorizontalSlab(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.slab != null && state.func_177230_c().getClass().equals(this.slab) && (Integer)state.func_177229_b((IProperty)this.parts) < 2;
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof ItemBlock && ((ItemBlock)item).func_179223_d().getClass().equals(this.slab);
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        return this.slab != null && (Integer)state.func_177229_b((IProperty)this.parts) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        return this.slab == null ? state : state.func_177226_a((IProperty)this.parts, (Comparable)Integer.valueOf(half == BlockSlab.EnumBlockHalf.BOTTOM ? 0 : 1));
    }
}

