/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.minecraft;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SlabSupportProvider
public class MinecraftSlabSupport
implements IHorizontalSlabSupport {
    private static final Map<IProperty<?>, Block> HALF_TO_DOUBLE = Maps.newHashMap();

    private boolean isValid(IBlockState state) {
        return state.func_177230_c() instanceof BlockSlab && !((BlockSlab)state.func_177230_c()).func_176552_j() && this.hasEnumHalfProperty(state);
    }

    private boolean hasEnumHalfProperty(IBlockState state) {
        return state.func_177227_a().contains(BlockSlab.field_176554_a);
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        boolean valid = this.isValid(block.func_176223_P());
        if (valid) {
            BlockSlab slab = (BlockSlab)block;
            if (slab.func_176552_j()) {
                HALF_TO_DOUBLE.put(slab.func_176551_l(), (Block)slab);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isHorizontalSlab(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.isValid(state);
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return item instanceof ItemBlock && this.isValid(((ItemBlock)item).func_179223_d().func_176223_P());
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        return (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
    }

    protected static <T extends Comparable<T>> IBlockState makeState(IBlockState state, IProperty<T> property, Comparable<?> value) {
        if (property != null) {
            return state.func_177226_a(property, value);
        }
        return state;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        if (half == null) {
            BlockSlab slab = (BlockSlab)state.func_177230_c();
            return MinecraftSlabSupport.makeState(HALF_TO_DOUBLE.getOrDefault(slab.func_176551_l(), (Block)slab).func_176223_P(), slab.func_176551_l(), state.func_177229_b(slab.func_176551_l()));
        }
        return state.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)half);
    }

    @Override
    public boolean useDoubleSlabModel(IBlockState state) {
        return state.func_177227_a().stream().noneMatch(property -> property.func_177699_b() == EnumFacing.class);
    }
}

