/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.slabmachines;

import cjminecraft.doubleslabs.api.containers.ContainerSupportProvider;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="slabmachines")
@ContainerSupportProvider(modid="slabmachines")
public class SlabMachinesContainerSupport
implements IContainerSupport {
    public static final Block FURNACE_SLAB = null;
    public static final Block WORKBENCH_SLAB = null;
    public static final Block CHEST_SLAB = null;
    public static final Block TRAPPED_CHEST_SLAB = null;
    public static final Block CRAFTING_STATION_SLAB = null;
    public static final Block PART_BUILDER_SLAB = null;
    public static final Block PART_CHEST_SLAB = null;
    public static final Block PATTERN_CHEST_SLAB = null;
    public static final Block STENCIL_TABLE_SLAB = null;
    public static final Block TOOL_FORGE_SLAB = null;
    public static final Block TOOL_STATION_SLAB = null;
    private final Object modInstance;
    private final boolean fastFurnace;
    private final Class<?> baseContainer;

    public SlabMachinesContainerSupport() {
        Class<?> baseContainer;
        Object modInstance;
        try {
            modInstance = Class.forName("com.mrbysco.slabmachines.SlabMachines").getField("instance").get(null);
            baseContainer = Loader.isModLoaded((String)"mantle") ? Class.forName("slimeknights.mantle.inventory.BaseContainer") : null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            modInstance = null;
            baseContainer = null;
        }
        this.modInstance = modInstance;
        this.baseContainer = baseContainer;
        this.fastFurnace = Loader.isModLoaded((String)"fastfurnace");
    }

    public void onClicked(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        if (state.func_177230_c() == WORKBENCH_SLAB) {
            player.func_71029_a(StatList.field_188062_ab);
        } else if (state.func_177230_c() == FURNACE_SLAB) {
            player.func_71029_a(StatList.field_188061_aa);
        } else if (state.func_177230_c() == CHEST_SLAB) {
            player.func_71029_a(StatList.field_188063_ac);
        } else if (state.func_177230_c() == TRAPPED_CHEST_SLAB) {
            player.func_71029_a(StatList.field_188089_W);
        } else if (this.baseContainer != null && this.baseContainer.isAssignableFrom(player.field_71070_bA.getClass())) {
            Object baseContainerObj = this.baseContainer.cast(player.field_71070_bA);
            try {
                this.baseContainer.getMethod("syncOnOpen", EntityPlayerMP.class).invoke(baseContainerObj, (EntityPlayerMP)player);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasSupport(World world, BlockPos pos, IBlockState state) {
        return this.modInstance != null && (state.func_177230_c() == FURNACE_SLAB || state.func_177230_c() == WORKBENCH_SLAB || state.func_177230_c() == CHEST_SLAB || state.func_177230_c() == TRAPPED_CHEST_SLAB || state.func_177230_c() == CRAFTING_STATION_SLAB || state.func_177230_c() == PART_BUILDER_SLAB || state.func_177230_c() == PART_CHEST_SLAB || state.func_177230_c() == PATTERN_CHEST_SLAB || state.func_177230_c() == STENCIL_TABLE_SLAB || state.func_177230_c() == TOOL_FORGE_SLAB || state.func_177230_c() == TOOL_STATION_SLAB);
    }

    @Override
    public Object getModInstance() {
        return this.modInstance;
    }

    @Override
    public int getId(World world, BlockPos pos, IBlockState state, EntityPlayer player, RayTraceResult hit) {
        int id = -1;
        if (state.func_177230_c() == WORKBENCH_SLAB) {
            id = this.fastFurnace ? 8 : 0;
        } else if (state.func_177230_c() == FURNACE_SLAB) {
            id = this.fastFurnace ? 10 : 2;
        } else if (state.func_177230_c() == CHEST_SLAB || state.func_177230_c() == TRAPPED_CHEST_SLAB) {
            id = 4;
        } else if (state.func_177230_c() == CRAFTING_STATION_SLAB) {
            id = 12;
        } else if (state.func_177230_c() == STENCIL_TABLE_SLAB) {
            id = 14;
        } else if (state.func_177230_c() == PART_BUILDER_SLAB) {
            id = 16;
        } else if (state.func_177230_c() == TOOL_STATION_SLAB) {
            id = 18;
        } else if (state.func_177230_c() == PATTERN_CHEST_SLAB) {
            id = 20;
        } else if (state.func_177230_c() == TOOL_FORGE_SLAB) {
            id = 22;
        } else if (state.func_177230_c() == PART_CHEST_SLAB) {
            id = 24;
        }
        if (state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
            ++id;
        }
        return id;
    }
}

