/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.stairwaytoaether;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@SlabSupportProvider(modid="stairway")
public class StairwayToAetherSlabSupport<T extends Enum<T>>
implements IHorizontalSlabSupport,
IVerticalSlabSupport {
    private final Class<?> slab;
    private final PropertyEnum<T> typeProperty;
    private final T[] slabTypes;

    public StairwayToAetherSlabSupport() {
        Enum[] slabTypes;
        PropertyEnum typeProperty;
        Class<?> slab;
        try {
            slab = Class.forName("mod.stairway.blocks.BlockSlab");
            typeProperty = (PropertyEnum)slab.getField("HALF").get(null);
            Class<?> slabType = Class.forName("mod.stairway.blocks.BlockSlab$EnumBlockHalf");
            slabTypes = (Enum[])slabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            typeProperty = null;
            slabTypes = null;
        }
        this.slab = slab;
        this.typeProperty = typeProperty;
        this.slabTypes = slabTypes;
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && this.slab.isAssignableFrom(block.getClass());
    }

    @Override
    public boolean isHorizontalSlab(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && (((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[0]) || ((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[1]));
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof ItemBlock && this.slab.isAssignableFrom(((ItemBlock)item).func_179223_d().getClass());
    }

    @Override
    public boolean isVerticalSlab(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[0]) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[1]) && !((Enum)((Object)state.func_177229_b(this.typeProperty))).equals(this.slabTypes[6]);
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, EntityPlayer player, EnumHand hand) {
        return this.isHorizontalSlab(stack, player, hand);
    }

    @Override
    public IBlockState getStateForDirection(World world, BlockPos pos, IBlockState state, EnumFacing direction) {
        return this.slab == null ? state : state.func_177226_a(this.typeProperty, this.slabTypes[direction.func_176745_a()]);
    }

    @Override
    public EnumFacing getDirection(World world, BlockPos pos, IBlockState state) {
        if (this.slab == null) {
            return null;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.typeProperty));
        if (type.equals(this.slabTypes[2])) {
            return EnumFacing.NORTH;
        }
        if (type.equals(this.slabTypes[3])) {
            return EnumFacing.SOUTH;
        }
        if (type.equals(this.slabTypes[4])) {
            return EnumFacing.EAST;
        }
        return EnumFacing.WEST;
    }

    @Override
    public BlockSlab.EnumBlockHalf getHalf(World world, BlockPos pos, IBlockState state) {
        if (this.slab == null) {
            return null;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.typeProperty));
        if (type.equals(this.slabTypes[0])) {
            return BlockSlab.EnumBlockHalf.TOP;
        }
        return BlockSlab.EnumBlockHalf.BOTTOM;
    }

    @Override
    public IBlockState getStateForHalf(World world, BlockPos pos, IBlockState state, BlockSlab.EnumBlockHalf half) {
        return this.slab == null ? state : state.func_177226_a(this.typeProperty, this.slabTypes[half == null ? 2 : (half == BlockSlab.EnumBlockHalf.TOP ? 0 : 1)]);
    }
}

