/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.libraryex.LibraryExSlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.util.Vector3f;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ClientConstants {
    public static final int TINT_OFFSET = 1000;
    private static final TRSRTransformation TRANSFORMATION_2D;
    private static final Map<IBlockState, Map<EnumFacing, IBakedModel>> VERTICAL_SLAB_MODELS;
    private static final Map<ModelResourceLocation, IBakedModel> VERTICAL_SLAB_ITEM_MODELS;
    private static final Class<?> WEIGHTED_RANDOM_MODEL;
    private static final Constructor<?> WEIGHTED_RANDOM_MODEL_CONSTRUCTOR;
    private static final Field WEIGHTED_RANDOM_MODEL_VARIANTS;
    private static final Class<?> FORGE_VARIANT;
    private static final Constructor<?> FORGE_VARIANT_CONSTRUCTOR;
    private static final Field FORGE_VARIANT_BLOCKSTATE_LOCATION;
    private static final Field FORGE_VARIANT_TEXTURES;
    private static final Field FORGE_VARIANT_PARTS;
    private static final Field FORGE_VARIANT_CUSTOMDATA;
    private static final Field FORGE_VARIANT_STATE;
    private static final Field FORGE_VARIANT_SMOOTH;
    private static final Field FORGE_VARIANT_GUI3D;

    public static boolean isTransparent(IBlockState state) {
        return !state.func_185904_a().func_76218_k() || state.func_185895_e();
    }

    public static IBakedModel getFallbackModel() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
    }

    public static IBakedModel getVerticalModel(IBlockState state, EnumFacing direction) {
        Map<EnumFacing, IBakedModel> map = VERTICAL_SLAB_MODELS.get(state);
        if (map != null) {
            return map.getOrDefault(direction, ClientConstants.getFallbackModel());
        }
        return ClientConstants.getFallbackModel();
    }

    public static IBakedModel getVerticalModel(ItemStack stack) {
        ModelResourceLocation location = ((ItemModelMesherForge)Minecraft.func_71410_x().func_175599_af().func_175037_a()).getLocation(stack);
        return VERTICAL_SLAB_ITEM_MODELS.getOrDefault(location, ClientConstants.getFallbackModel());
    }

    private static IModel newWeightedRandomModel(VariantList variants) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return (IModel)WEIGHTED_RANDOM_MODEL_CONSTRUCTOR.newInstance(new ResourceLocation(""), variants);
    }

    private static List<Variant> getVariantListFromWeightedRandomModel(IModel model) throws IllegalAccessException {
        Object obj = WEIGHTED_RANDOM_MODEL.cast(model);
        return (List)WEIGHTED_RANDOM_MODEL_VARIANTS.get(obj);
    }

    private static Variant convertVariant(Variant variant, boolean uvlock) {
        if (FORGE_VARIANT != null && FORGE_VARIANT.isAssignableFrom(variant.getClass())) {
            try {
                Object obj = FORGE_VARIANT.cast(variant);
                return (Variant)FORGE_VARIANT_CONSTRUCTOR.newInstance((ResourceLocation)FORGE_VARIANT_BLOCKSTATE_LOCATION.get(obj), variant.func_188046_a(), (IModelState)FORGE_VARIANT_STATE.get(obj), variant.func_188049_c() || uvlock, (Optional)FORGE_VARIANT_SMOOTH.get(obj), (Optional)FORGE_VARIANT_GUI3D.get(obj), variant.func_188047_d(), (ImmutableMap)FORGE_VARIANT_TEXTURES.get(obj), (ImmutableMap)FORGE_VARIANT_PARTS.get(obj), (ImmutableMap)FORGE_VARIANT_CUSTOMDATA.get(obj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Variant(variant.func_188046_a(), variant.func_188048_b(), variant.func_188049_c() || uvlock, variant.func_188047_d());
    }

    public static IBakedModel bake(ModelLoader modelLoader, IModel model, ModelRotation rotation, boolean uvlock) {
        Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> modelLoader.field_177609_j.func_110572_b(location.toString());
        Optional vanillaModel = model.asVanillaModel();
        if (vanillaModel.isPresent()) {
            ModelBlock block = (ModelBlock)vanillaModel.get();
            TextureAtlasSprite textureatlassprite = modelLoader.field_177609_j.func_110572_b(new ResourceLocation(block.func_178308_c("particle")).toString());
            SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(block, block.func_187967_g()).func_177646_a(textureatlassprite);
            if (block.func_178298_a().isEmpty()) {
                return ClientConstants.getFallbackModel();
            }
            for (BlockPart blockpart : block.func_178298_a()) {
                for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(enumfacing);
                    TextureAtlasSprite textureatlassprite1 = modelLoader.field_177609_j.func_110572_b(new ResourceLocation(block.func_178308_c(blockpartface.field_178242_d)).toString());
                    if (blockpartface.field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)rotation.getMatrix())) {
                        simplebakedmodel$builder.func_177648_a(modelLoader.func_177589_a(blockpart, blockpartface, textureatlassprite1, enumfacing, rotation, uvlock));
                        continue;
                    }
                    simplebakedmodel$builder.func_177650_a(rotation.rotate(blockpartface.field_178244_b), modelLoader.func_177589_a(blockpart, blockpartface, textureatlassprite1, enumfacing, rotation, uvlock));
                }
            }
            return simplebakedmodel$builder.func_177645_b();
        }
        if (WEIGHTED_RANDOM_MODEL != null && WEIGHTED_RANDOM_MODEL_VARIANTS != null && WEIGHTED_RANDOM_MODEL_CONSTRUCTOR != null && WEIGHTED_RANDOM_MODEL.isAssignableFrom(model.getClass())) {
            try {
                IModel newModel = ClientConstants.newWeightedRandomModel(new VariantList(ClientConstants.getVariantListFromWeightedRandomModel(model).stream().map(v -> ClientConstants.convertVariant(v, uvlock)).collect(Collectors.toList())));
                return newModel.bake((IModelState)rotation, DefaultVertexFormats.field_176599_b, textureGetter);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return model.bake((IModelState)rotation, DefaultVertexFormats.field_176599_b, textureGetter);
    }

    public static void bakeVerticalSlabModels(ModelLoader modelLoader) {
        VERTICAL_SLAB_MODELS.clear();
        VERTICAL_SLAB_ITEM_MODELS.clear();
        BlockStateMapper mapper = modelLoader.field_177610_k.func_178120_a();
        ForgeRegistries.BLOCKS.forEach(block -> {
            IHorizontalSlabSupport slabSupport = SlabSupport.getHorizontalSlabSupport(block);
            if (slabSupport != null) {
                Map variants = mapper.func_188181_b(block);
                block.func_176194_O().func_177619_a().forEach(state -> {
                    boolean uvlock = DSConfig.CLIENT.uvlock((IBlockState)state);
                    ModelResourceLocation resourceLocation = (ModelResourceLocation)variants.get(state);
                    if (resourceLocation != null) {
                        boolean fix;
                        boolean bl = fix = resourceLocation.func_110624_b().equals("quark") && ((BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a)).equals((Object)BlockSlab.EnumBlockHalf.TOP);
                        if (slabSupport instanceof LibraryExSlabSupport) {
                            fix = slabSupport.getHalf(null, null, (IBlockState)state) == BlockSlab.EnumBlockHalf.TOP;
                        }
                        try {
                            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)resourceLocation).uvlock(uvlock);
                            EnumMap map = Maps.newEnumMap(EnumFacing.class);
                            map.put(EnumFacing.NORTH, ClientConstants.bake(modelLoader, model, fix ? ModelRotation.X90_Y0 : ModelRotation.X90_Y180, uvlock));
                            map.put(EnumFacing.EAST, ClientConstants.bake(modelLoader, model, fix ? ModelRotation.X90_Y90 : ModelRotation.X90_Y270, uvlock));
                            map.put(EnumFacing.SOUTH, ClientConstants.bake(modelLoader, model, fix ? ModelRotation.X90_Y180 : ModelRotation.X90_Y0, uvlock));
                            map.put(EnumFacing.WEST, ClientConstants.bake(modelLoader, model, fix ? ModelRotation.X90_Y270 : ModelRotation.X90_Y90, uvlock));
                            VERTICAL_SLAB_MODELS.put((IBlockState)state, map);
                        }
                        catch (Exception e) {
                            DoubleSlabs.LOGGER.warn("Failed to generate vertical slab model for: {}", (Object)resourceLocation.toString());
                            DoubleSlabs.LOGGER.catching((Throwable)e);
                        }
                    }
                });
            }
        });
        ForgeRegistries.ITEMS.forEach(item -> {
            if (SlabSupport.isHorizontalSlab(item)) {
                for (String s : modelLoader.func_177596_a(item)) {
                    ModelResourceLocation modelResourceLocation = ModelLoader.getInventoryVariant((String)s);
                    boolean uvlock = !DSConfig.CLIENT.uvlockModelBlacklist.contains(modelResourceLocation.func_110624_b() + ":" + modelResourceLocation.func_110623_a());
                    try {
                        IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelResourceLocation).uvlock(uvlock);
                        VERTICAL_SLAB_ITEM_MODELS.put(modelResourceLocation, ClientConstants.bake(modelLoader, model, ModelRotation.X90_Y0, uvlock));
                    }
                    catch (Exception e) {
                        DoubleSlabs.LOGGER.warn("Failed to generate vertical slab item model for: {}", (Object)modelResourceLocation.toString());
                        DoubleSlabs.LOGGER.catching((Throwable)e);
                    }
                }
            }
        });
        DoubleSlabs.LOGGER.debug("Loaded vertical slab models!");
    }

    static {
        Field forgeVariantState;
        Field forgeVariantGui3d;
        Field forgeVariantSmooth;
        Field forgeVariantCustomData;
        Field forgeVariantParts;
        Field forgeVariantTextures;
        Field forgeVariantBlockstateLocation;
        Constructor<?> forgeVariantConstructor;
        Class<?> forgeVariant;
        Field weightedRandomModelVariants;
        Constructor<?> weightedRandomModelConstructor;
        Class<?> weightedRandomModel;
        TRANSFORMATION_2D = new TRSRTransformation(null, Vector3f.ZN.rotationDegrees(90.0f).toQuat(), null, null);
        VERTICAL_SLAB_MODELS = Maps.newIdentityHashMap();
        VERTICAL_SLAB_ITEM_MODELS = Maps.newHashMap();
        try {
            weightedRandomModel = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
            weightedRandomModelConstructor = weightedRandomModel.getConstructor(ResourceLocation.class, VariantList.class);
            weightedRandomModelConstructor.setAccessible(true);
            weightedRandomModelVariants = weightedRandomModel.getDeclaredField("variants");
            weightedRandomModelVariants.setAccessible(true);
            forgeVariant = Class.forName("net.minecraftforge.client.model.BlockStateLoader$ForgeVariant");
            forgeVariantConstructor = forgeVariant.getConstructor(ResourceLocation.class, ResourceLocation.class, IModelState.class, Boolean.TYPE, Optional.class, Optional.class, Integer.TYPE, ImmutableMap.class, ImmutableMap.class, ImmutableMap.class);
            forgeVariantConstructor.setAccessible(true);
            forgeVariantBlockstateLocation = forgeVariant.getDeclaredField("blockstateLocation");
            forgeVariantBlockstateLocation.setAccessible(true);
            forgeVariantTextures = forgeVariant.getDeclaredField("textures");
            forgeVariantTextures.setAccessible(true);
            forgeVariantParts = forgeVariant.getDeclaredField("parts");
            forgeVariantParts.setAccessible(true);
            forgeVariantCustomData = forgeVariant.getDeclaredField("customData");
            forgeVariantCustomData.setAccessible(true);
            forgeVariantSmooth = forgeVariant.getDeclaredField("smooth");
            forgeVariantSmooth.setAccessible(true);
            forgeVariantGui3d = forgeVariant.getDeclaredField("gui3d");
            forgeVariantGui3d.setAccessible(true);
            forgeVariantState = forgeVariant.getDeclaredField("state");
            forgeVariantState.setAccessible(true);
        }
        catch (Exception ignore) {
            weightedRandomModel = null;
            weightedRandomModelConstructor = null;
            weightedRandomModelVariants = null;
            forgeVariant = null;
            forgeVariantConstructor = null;
            forgeVariantBlockstateLocation = null;
            forgeVariantTextures = null;
            forgeVariantParts = null;
            forgeVariantCustomData = null;
            forgeVariantState = null;
            forgeVariantSmooth = null;
            forgeVariantGui3d = null;
        }
        WEIGHTED_RANDOM_MODEL = weightedRandomModel;
        WEIGHTED_RANDOM_MODEL_CONSTRUCTOR = weightedRandomModelConstructor;
        WEIGHTED_RANDOM_MODEL_VARIANTS = weightedRandomModelVariants;
        FORGE_VARIANT = forgeVariant;
        FORGE_VARIANT_CONSTRUCTOR = forgeVariantConstructor;
        FORGE_VARIANT_BLOCKSTATE_LOCATION = forgeVariantBlockstateLocation;
        FORGE_VARIANT_TEXTURES = forgeVariantTextures;
        FORGE_VARIANT_PARTS = forgeVariantParts;
        FORGE_VARIANT_CUSTOMDATA = forgeVariantCustomData;
        FORGE_VARIANT_STATE = forgeVariantState;
        FORGE_VARIANT_SMOOTH = forgeVariantSmooth;
        FORGE_VARIANT_GUI3D = forgeVariantGui3d;
    }
}

