/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.asm;

import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.util.AmbientOcclusionFace;
import cjminecraft.doubleslabs.client.util.DoubleSlabCulling;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BlockModelRendererMixin {
    private static <T> IBlockState setValue(IBlockState state, IUnlistedProperty<T> property, T value) {
        if (state instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty(property, value);
        }
        return state;
    }

    public static boolean renderModelSmooth(BlockModelRenderer renderer, IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            float[] afloat = new float[EnumFacing.values().length * 2];
            BitSet bitset = new BitSet(3);
            AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (EnumFacing direction : EnumFacing.values()) {
                List quads;
                if (doubleSlab) {
                    quads = model.func_188616_a(state, direction, rand);
                    if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                    flag = true;
                    continue;
                }
                if (renderPositive && !(quads = model.func_188616_a(state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, true), direction, rand)).isEmpty() && (!checkSides || DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                    BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                    flag = true;
                }
                if (!renderNegative) continue;
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    IBlockState newState = state.func_177226_a((IProperty)VerticalSlabBlock.FACING, (Comparable)((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d());
                    quads = ((VerticalSlabBakedModel)model).getModel(newState).func_188616_a(newState, direction, rand);
                } else {
                    state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, false);
                    quads = model.func_188616_a(state, direction, rand);
                }
                if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                flag = true;
            }
            List list1 = model.func_188616_a(state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, null), null, rand);
            if (!list1.isEmpty()) {
                BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    public static boolean renderModelFlat(BlockModelRenderer renderer, IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            BitSet bitset = new BitSet(3);
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (EnumFacing direction : EnumFacing.values()) {
                List list;
                if (doubleSlab) {
                    list = model.func_188616_a(state, direction, rand);
                    if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    int i = state.func_185889_a(world, pos.func_177972_a(direction));
                    BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                    flag = true;
                    continue;
                }
                if (renderPositive && !(list = model.func_188616_a(state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, true), direction, rand)).isEmpty() && (!checkSides || DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                    int i = state.func_185889_a(world, pos.func_177972_a(direction));
                    BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                    flag = true;
                }
                if (!renderNegative) continue;
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    IBlockState newState = state.func_177226_a((IProperty)VerticalSlabBlock.FACING, (Comparable)((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d());
                    list = ((VerticalSlabBakedModel)model).getModel(newState).func_188616_a(newState, direction, rand);
                } else {
                    state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, false);
                    list = model.func_188616_a(state, direction, rand);
                }
                if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                int i = state.func_185889_a(world, pos.func_177972_a(direction));
                BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                flag = true;
            }
            List list1 = model.func_188616_a(state = BlockModelRendererMixin.setValue(state, DynamicSlabBlock.RENDER_POSITIVE, null), (EnumFacing)null, rand);
            if (!list1.isEmpty()) {
                BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, -1, true, buffer, list1, bitset);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    private static void fillQuadBounds(IBlockState stateIn, int[] vertexData, EnumFacing face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[EnumFacing.WEST.func_176745_a()] = f;
            quadBounds[EnumFacing.EAST.func_176745_a()] = f3;
            quadBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            quadBounds[EnumFacing.UP.func_176745_a()] = f4;
            quadBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            int j = EnumFacing.values().length;
            quadBounds[EnumFacing.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[EnumFacing.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[EnumFacing.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[EnumFacing.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[EnumFacing.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || stateIn.func_185917_h()) && f == f3);
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || stateIn.func_185917_h()) && f == f3);
            }
        }
    }

    private static void renderQuadsSmooth(BlockModelRenderer renderer, IBlockAccess blockAccessIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, List<BakedQuad> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace) {
        Vec3d vec3d = stateIn.func_191059_e(blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            BlockModelRendererMixin.fillQuadBounds(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.updateVertexBrightness(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet);
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                aoFace.vertexColorMultiplier[0] = aoFace.vertexColorMultiplier[0] * diffuse;
                aoFace.vertexColorMultiplier[1] = aoFace.vertexColorMultiplier[1] * diffuse;
                aoFace.vertexColorMultiplier[2] = aoFace.vertexColorMultiplier[2] * diffuse;
                aoFace.vertexColorMultiplier[3] = aoFace.vertexColorMultiplier[3] * diffuse;
            }
            if (bakedquad.func_178212_b()) {
                int k = renderer.field_187499_a.func_186724_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.func_178978_a(aoFace.vertexColorMultiplier[0] * f, aoFace.vertexColorMultiplier[0] * f1, aoFace.vertexColorMultiplier[0] * f2, 4);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[1] * f, aoFace.vertexColorMultiplier[1] * f1, aoFace.vertexColorMultiplier[1] * f2, 3);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[2] * f, aoFace.vertexColorMultiplier[2] * f1, aoFace.vertexColorMultiplier[2] * f2, 2);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[3] * f, aoFace.vertexColorMultiplier[3] * f1, aoFace.vertexColorMultiplier[3] * f2, 1);
            } else {
                buffer.func_178978_a(aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], 4);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], 3);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], 2);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private static void renderQuadsFlat(BlockModelRenderer renderer, IBlockAccess blockAccessIn, IBlockState stateIn, BlockPos posIn, int brightnessIn, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = stateIn.func_191059_e(blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                BlockModelRendererMixin.fillQuadBounds(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = stateIn.func_185889_a(blockAccessIn, blockpos);
            }
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.func_178212_b()) {
                int k = renderer.field_187499_a.func_186724_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                buffer.func_178978_a(f, f1, f2, 4);
                buffer.func_178978_a(f, f1, f2, 3);
                buffer.func_178978_a(f, f1, f2, 2);
                buffer.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }
}

