/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.asm;

import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    private static final Map<String, Transformer> TRANSFORMERS = Maps.newHashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (TRANSFORMERS.containsKey(transformedName)) {
            ClassTransformer.log("Transforming " + transformedName);
            return (byte[])TRANSFORMERS.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformBlockModelRenderer(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("renderModelSmooth", "func_187498_b", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z");
        MethodSignature sig2 = new MethodSignature("renderModelFlat", "func_187497_c", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig1, method -> {
            InsnList newInstructions = new InsnList();
            LabelNode escape = new LabelNode();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(22, 7));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "cjminecraft/doubleslabs/client/asm/BlockModelRendererMixin", "renderModelSmooth", "(Lnet/minecraft/client/renderer/BlockModelRenderer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(89));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, escape));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)escape);
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }), ClassTransformer.forMethod(sig2, method -> {
            InsnList newInstructions = new InsnList();
            LabelNode escape = new LabelNode();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(22, 7));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "cjminecraft/doubleslabs/client/asm/BlockModelRendererMixin", "renderModelFlat", "(Lnet/minecraft/client/renderer/BlockModelRenderer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(89));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, escape));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)escape);
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }));
    }

    private static void log(String str) {
        LogManager.getLogger((String)"DoubleSlabs ASM").info(str);
    }

    private static byte[] transform(byte[] basicClass, TransformerAction ... methods) {
        ClassReader reader;
        try {
            reader = new ClassReader(basicClass);
        }
        catch (NullPointerException ex) {
            return basicClass;
        }
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (TransformerAction pair : methods) {
            didAnything |= pair.test(node);
        }
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction predicate, boolean logResult) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            ClassTransformer.log("Located Method, patching...");
            boolean finish = predicate.test(method);
            if (logResult) {
                ClassTransformer.log("Patch result: " + finish);
            }
            return finish;
        }
        if (logResult) {
            ClassTransformer.log("Failed to locate the method!");
        }
        return false;
    }

    private static TransformerAction forMethod(MethodSignature sig, MethodAction ... actions) {
        return new MethodTransformerAction(sig, actions);
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            ClassTransformer.log("Located patch target node " + ClassTransformer.getNodeString(anode));
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    static {
        TRANSFORMERS.put("net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer", ClassTransformer::transformBlockModelRenderer);
        TRANSFORMERS.put("net.minecraft.client.renderer.BlockModelRenderer", ClassTransformer::transformBlockModelRenderer);
    }

    private static class MethodTransformerAction
    implements TransformerAction {
        private final MethodSignature sig;
        private final MethodAction[] actions;

        public MethodTransformerAction(MethodSignature sig, MethodAction[] actions) {
            this.sig = sig;
            this.actions = actions;
        }

        @Override
        public boolean test(ClassNode classNode) {
            boolean didAnything = false;
            ClassTransformer.log("Applying Transformation to method (" + this.sig + ")");
            for (MethodAction action : this.actions) {
                didAnything |= ClassTransformer.findMethodAndTransform(classNode, this.sig, action, true);
            }
            return didAnything;
        }
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            LaunchClassLoader classLoader = Launch.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, (ClassLoader)classLoader);
                d = Class.forName(type2.replace('/', '.'), false, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }

        public String mappedName(String owner) {
            return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(owner, this.srgName, this.funcDesc);
        }
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface TransformerAction
    extends Predicate<ClassNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }
}

