/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.handlers;

import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="doubleslabs", value={Side.CLIENT})
public class ClientRenderHandler {
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<IProperty<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty<?> prop = entry.getKey();
            return prop.func_177701_a() + "=" + this.getPropertyName(prop, entry.getValue());
        }

        private <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
            return property.func_177702_a(entry);
        }
    };

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        IBlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.getTarget().func_178782_a());
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_() || Minecraft.func_71410_x().field_71439_g.func_184812_l_() && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            double expansionAmount;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            double x = (double)event.getTarget().func_178782_a().func_177958_n() - (event.getPlayer().field_70142_S + (event.getPlayer().field_70165_t - event.getPlayer().field_70142_S) * (double)event.getPartialTicks());
            double y = (double)event.getTarget().func_178782_a().func_177956_o() - (event.getPlayer().field_70137_T + (event.getPlayer().field_70163_u - event.getPlayer().field_70137_T) * (double)event.getPartialTicks());
            double z = (double)event.getTarget().func_178782_a().func_177952_p() - (event.getPlayer().field_70136_U + (event.getPlayer().field_70161_v - event.getPlayer().field_70136_U) * (double)event.getPartialTicks());
            if (state.func_177230_c() == DSBlocks.DOUBLE_SLAB) {
                if (Minecraft.func_71410_x().field_71441_e.func_175723_af().func_177746_a(event.getTarget().func_178782_a())) {
                    expansionAmount = 0.002f;
                    if (event.getTarget().field_72307_f.field_72448_b - (double)event.getTarget().func_178782_a().func_177956_o() > 0.5) {
                        RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y + 0.5 - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    } else {
                        RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 0.5 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                }
                event.setCanceled(true);
            }
            if (state.func_177230_c() == DSBlocks.VERTICAL_SLAB && ((Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue()) {
                expansionAmount = 0.002f;
                switch (((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176740_k()) {
                    case X: {
                        if (event.getTarget().field_72307_f.field_72450_a - (double)event.getTarget().func_178782_a().func_177958_n() > 0.5) {
                            RenderGlobal.func_189694_a((double)(x + 0.5 - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 0.5 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                    case Z: {
                        if (event.getTarget().field_72307_f.field_72449_c - (double)event.getTarget().func_178782_a().func_177952_p() > 0.5) {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z + 0.5 - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 1.0 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            RenderGlobal.func_189694_a((double)(x - (double)0.002f), (double)(y - (double)0.002f), (double)(z - (double)0.002f), (double)(x + 1.0 + (double)0.002f), (double)(y + 1.0 + (double)0.002f), (double)(z + 0.5 + (double)0.002f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    private static <T extends Comparable<T>> String stateToString(@Nullable IBlockState state) {
        if (state == null) {
            return TextFormatting.RED + "null";
        }
        return state.func_177230_c().getRegistryName().toString() + "[" + state.func_177228_b().entrySet().stream().map(MAP_ENTRY_TO_STRING).collect(Collectors.joining(",")) + "]";
    }

    private static String tileToString(@Nullable TileEntity tile) {
        if (tile == null) {
            return TextFormatting.RED + "null";
        }
        String data = tile.getTileData().toString();
        return TileEntity.func_190559_a(tile.getClass()) + data;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderOverlayText(RenderGameOverlayEvent.Text event) {
        BlockPos pos;
        TileEntity tileEntity;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos = Minecraft.func_71410_x().field_71476_x.func_178782_a())) instanceof SlabTileEntity) {
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            event.getRight().add("");
            event.getRight().add("Slab Types");
            event.getRight().add("Positive Block: " + ClientRenderHandler.stateToString(tile.getPositiveBlockInfo().getBlockState()));
            event.getRight().add("Positive Tile: " + ClientRenderHandler.tileToString(tile.getPositiveBlockInfo().getTileEntity()));
            event.getRight().add("Negative Block: " + ClientRenderHandler.stateToString(tile.getNegativeBlockInfo().getBlockState()));
            event.getRight().add("Negative Tile: " + ClientRenderHandler.tileToString(tile.getNegativeBlockInfo().getTileEntity()));
        }
    }
}

