/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class DoubleSlabBakedModel
extends DynamicSlabBakedModel {
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            IHorizontalSlabSupport horizontalSlabSupport;
            boolean shouldCull;
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBlockInfo positiveBlock = (IBlockInfo)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.NEGATIVE_BLOCK);
            IBlockState positiveState = positiveBlock.getBlockState();
            IBlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null || negativeState == null) {
                return ClientConstants.getFallbackModel().func_188616_a(state, side, rand);
            }
            boolean renderHalves = extendedState.getUnlistedProperties().containsKey((Object)DynamicSlabBlock.POSITIVE_BLOCK) && extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.RENDER_POSITIVE) != false;
            boolean topTransparent = ClientConstants.isTransparent(positiveState);
            boolean bottomTransparent = ClientConstants.isTransparent(negativeState);
            boolean bl = shouldCull = DSConfig.CLIENT.shouldCull(positiveState) && DSConfig.CLIENT.shouldCull(negativeState) && (!topTransparent || !bottomTransparent || positiveState.func_177230_c() == negativeState.func_177230_c() && positiveState.func_177230_c() == negativeState.func_177230_c());
            if (DoubleSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                IBlockState doubleState = horizontalSlabSupport.getStateForHalf(positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, null);
                if (doubleState.func_177230_c().canRenderInLayer(doubleState, MinecraftForgeClient.getRenderLayer()) || MinecraftForgeClient.getRenderLayer() == null) {
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(doubleState);
                    return model.func_188616_a(state, side, rand);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!(renderHalves && !renderPositive || !positiveState.func_177230_c().canRenderInLayer(positiveState, MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                List<BakedQuad> topQuads = this.getQuadsForState(positiveBlock, side, rand);
                if (shouldCull && (!bottomTransparent && !topTransparent || topTransparent && !bottomTransparent || topTransparent && bottomTransparent)) {
                    topQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == EnumFacing.DOWN);
                }
                quads.addAll(topQuads);
            }
            if (!(renderHalves && renderPositive || !negativeState.func_177230_c().canRenderInLayer(negativeState, MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                List<BakedQuad> bottomQuads = this.getQuadsForState(negativeBlock, side, rand);
                if (shouldCull && (!topTransparent && !bottomTransparent || bottomTransparent && !topTransparent || topTransparent && bottomTransparent)) {
                    bottomQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == EnumFacing.UP);
                }
                quads.addAll(bottomQuads);
            }
            return quads;
        }
        if (MinecraftForgeClient.getRenderLayer() == null) {
            // empty if block
        }
        return ClientConstants.getFallbackModel().func_188616_a(state, side, rand);
    }
}

