/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class DynamicSlabBakedModel
implements IBakedModel {
    public boolean func_177555_b() {
        return ClientConstants.getFallbackModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return ClientConstants.getFallbackModel().func_177556_c();
    }

    public boolean func_188618_c() {
        return ClientConstants.getFallbackModel().func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientConstants.getFallbackModel().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        try {
            return ClientConstants.getFallbackModel().func_188617_f();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean shouldCull(IBlockState state, IBlockState neighbour, EnumFacing direction) {
        if (state == null || neighbour == null) {
            return false;
        }
        return !ClientConstants.isTransparent(state) && !ClientConstants.isTransparent(neighbour);
    }

    public static boolean useDoubleSlabModel(IBlockState state1, IBlockState state2) {
        return state1.equals(state2) && DSConfig.CLIENT.useDoubleSlabModel(state1);
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, EnumFacing side, long rand) {
        IBlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return this.getQuadsForState(block, model, side, rand);
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, IBakedModel model, EnumFacing side, long rand) {
        IBlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        return this.getQuadsForModel(model, state, side, rand, block.isPositive());
    }

    protected List<BakedQuad> getQuadsForModel(IBakedModel model, IBlockState state, EnumFacing side, long rand, boolean positive) {
        return model.func_188616_a(state, side, rand).stream().map(quad -> new BakedQuad(quad.func_178209_a(), quad.func_178212_b() ? quad.func_178211_c() + (positive ? 1000 : 0) : -1, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat())).collect(Collectors.toList());
    }
}

