/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class VerticalSlabBakedModel
extends DynamicSlabBakedModel {
    public static final VerticalSlabBakedModel INSTANCE = new VerticalSlabBakedModel();
    private final Map<IBlockState, IBakedModel> models = new HashMap<IBlockState, IBakedModel>();

    public void addModel(IBakedModel model, IBlockState state) {
        this.models.put(state, model);
    }

    public IBakedModel getModel(IBlockState state) {
        return this.models.get(state);
    }

    private static boolean rotateHalf(IExtendedBlockState extendedState, IUnlistedProperty<Boolean> property) {
        return !extendedState.getUnlistedProperties().containsKey(property) || (Boolean)extendedState.getValue(property) != false;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        IBakedModel model;
        if (state instanceof IExtendedBlockState) {
            IBakedModel model2;
            IHorizontalSlabSupport horizontalSlabSupport;
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBlockInfo positiveBlock = (IBlockInfo)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.NEGATIVE_BLOCK);
            IBlockState positiveState = positiveBlock.getBlockState();
            IBlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null && negativeState == null) {
                return ClientConstants.getFallbackModel().func_188616_a(state, side, rand);
            }
            boolean positiveTransparent = positiveState == null || ClientConstants.isTransparent(positiveState);
            boolean negativeTransparent = negativeState == null || ClientConstants.isTransparent(negativeState);
            boolean shouldCull = positiveState != null && negativeState != null && DSConfig.CLIENT.shouldCull(positiveState) && DSConfig.CLIENT.shouldCull(negativeState) && (!positiveTransparent || !negativeTransparent || positiveState.func_177230_c() == negativeState.func_177230_c());
            boolean renderHalves = extendedState.getUnlistedProperties().containsKey((Object)DynamicSlabBlock.POSITIVE_BLOCK) && extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extendedState.getValue((IUnlistedProperty)DynamicSlabBlock.RENDER_POSITIVE) != false;
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
            if (positiveState != null && negativeState != null && VerticalSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                IBlockState doubleState = horizontalSlabSupport.getStateForHalf(positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, null);
                if (doubleState.func_177230_c().canRenderInLayer(doubleState, MinecraftForgeClient.getRenderLayer()) || MinecraftForgeClient.getRenderLayer() == null) {
                    IBakedModel model3 = ClientConstants.getVerticalModel(doubleState, direction);
                    return model3.func_188616_a(doubleState, side, rand);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!(renderHalves && !renderPositive || positiveState == null || !positiveState.func_177230_c().canRenderInLayer(positiveState, MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = VerticalSlabBakedModel.rotateHalf(extendedState, VerticalSlabBlock.ROTATE_POSITIVE) ? ClientConstants.getVerticalModel(positiveState, direction) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(positiveState);
                List<BakedQuad> positiveQuads = this.getQuadsForState(positiveBlock, model2, side, rand);
                if (shouldCull && (!negativeTransparent && !positiveTransparent || positiveTransparent && !negativeTransparent || positiveTransparent && negativeTransparent)) {
                    positiveQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction.func_176734_d());
                }
                quads.addAll(positiveQuads);
            }
            if (!(renderHalves && renderPositive || negativeState == null || !negativeState.func_177230_c().canRenderInLayer(negativeState, MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = VerticalSlabBakedModel.rotateHalf(extendedState, VerticalSlabBlock.ROTATE_NEGATIVE) ? ClientConstants.getVerticalModel(negativeState, direction) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(negativeState);
                List<BakedQuad> negativeQuads = this.getQuadsForState(negativeBlock, model2, side, rand);
                if (shouldCull && (!positiveTransparent && !negativeTransparent || negativeTransparent && !positiveTransparent || positiveTransparent && negativeTransparent)) {
                    negativeQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction);
                }
                quads.addAll(negativeQuads);
            }
            return quads;
        }
        if (MinecraftForgeClient.getRenderLayer() == null && (model = this.models.get(state)) != null) {
            return model.func_188616_a(state, side, rand);
        }
        return ClientConstants.getFallbackModel().func_188616_a(state, side, rand);
    }
}

