/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.proxy;

import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabItemBakedModel;
import cjminecraft.doubleslabs.client.render.SlabTileEntityRenderer;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.init.DSKeyBindings;
import cjminecraft.doubleslabs.common.proxy.IProxy;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="doubleslabs")
public class ClientProxy
implements IProxy {
    @Override
    public void preInit() {
        DSKeyBindings.register();
        ClientRegistry.bindTileEntitySpecialRenderer(SlabTileEntity.class, (TileEntitySpecialRenderer)new SlabTileEntityRenderer());
        ModelLoader.setCustomModelResourceLocation((Item)DSItems.VERTICAL_SLAB, (int)0, (ModelResourceLocation)new ModelResourceLocation(DSItems.VERTICAL_SLAB.getRegistryName(), "inventory"));
    }

    @Override
    public void postInit() {
    }

    private static String getPropertyString(Map<IProperty<?>, Comparable<?>> values) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(ClientProxy.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    private static void replaceModel(IBakedModel model, Block block, BiConsumer<IBakedModel, IBlockState> perModel, IRegistry<ModelResourceLocation, IBakedModel> registry) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation variantResourceLocation;
            IBakedModel existingModel;
            if (state instanceof IExtendedBlockState) {
                state = ((IExtendedBlockState)state).getClean();
            }
            if ((existingModel = (IBakedModel)registry.func_82594_a((Object)(variantResourceLocation = new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), ClientProxy.getPropertyString(state.func_177228_b()))))) == null) {
                DoubleSlabs.LOGGER.warn("Did not find the expected vanilla baked model(s) for the block in registry");
                continue;
            }
            if (existingModel instanceof DynamicSlabBakedModel) {
                DoubleSlabs.LOGGER.warn("Tried to replace model twice");
                continue;
            }
            perModel.accept(existingModel, state);
            registry.func_82595_a((Object)variantResourceLocation, (Object)model);
        }
    }

    @SubscribeEvent
    public static void bakeModels(ModelBakeEvent event) {
        ClientConstants.bakeVerticalSlabModels(event.getModelLoader());
        ClientProxy.replaceModel(new DoubleSlabBakedModel(), DSBlocks.DOUBLE_SLAB, (model, state) -> {}, (IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
        ClientProxy.replaceModel(VerticalSlabBakedModel.INSTANCE, DSBlocks.VERTICAL_SLAB, VerticalSlabBakedModel.INSTANCE::addModel, (IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
        ModelResourceLocation verticalSlabItemResourceLocation = new ModelResourceLocation(DSItems.VERTICAL_SLAB.getRegistryName(), "inventory");
        VerticalSlabItemBakedModel.INSTANCE = new VerticalSlabItemBakedModel((IBakedModel)event.getModelRegistry().func_82594_a((Object)verticalSlabItemResourceLocation));
        event.getModelRegistry().func_82595_a((Object)verticalSlabItemResourceLocation, (Object)VerticalSlabItemBakedModel.INSTANCE);
    }

    @SubscribeEvent
    public static void registerBlockColours(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(DSBlocks.DOUBLE_SLAB.getBlockColor(), new Block[]{DSBlocks.DOUBLE_SLAB});
        event.getBlockColors().func_186722_a(DSBlocks.VERTICAL_SLAB.getBlockColor(), new Block[]{DSBlocks.VERTICAL_SLAB});
    }
}

