/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.util;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.util.BlockAccessWrapper;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.function.BiFunction;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DoubleSlabCulling {
    private static IBlockState getSlabForType(IBlockState state, IBlockAccess world, BlockPos pos, BlockSlab.EnumBlockHalf type) {
        IHorizontalSlabSupport horizontalSupport = SlabSupport.getHorizontalSlabSupport(world, pos, state);
        if (horizontalSupport != null) {
            return horizontalSupport.getStateForHalf((World)Minecraft.func_71410_x().field_71441_e, pos, state, type);
        }
        return state;
    }

    private static IBlockState matchState(IBlockState state1, IBlockState state2, IBlockAccess world, BlockPos pos1, BlockPos pos2) {
        IHorizontalSlabSupport horizontalSupport = SlabSupport.getHorizontalSlabSupport(world, pos1, state1);
        if (horizontalSupport != null) {
            IHorizontalSlabSupport otherSupport = SlabSupport.getHorizontalSlabSupport(world, pos2, state2);
            if (otherSupport != null) {
                return otherSupport.getStateForHalf((World)Minecraft.func_71410_x().field_71441_e, pos2, state2, horizontalSupport.getHalf((World)Minecraft.func_71410_x().field_71441_e, pos1, state1));
            }
        } else {
            IVerticalSlabSupport otherSupport;
            IVerticalSlabSupport verticalSupport = SlabSupport.getVerticalSlabSupport(world, pos1, state1);
            if (verticalSupport != null && (otherSupport = SlabSupport.getVerticalSlabSupport(world, pos2, state2)) != null) {
                return otherSupport.getStateForDirection((World)Minecraft.func_71410_x().field_71441_e, pos2, state2, verticalSupport.getDirection((World)Minecraft.func_71410_x().field_71441_e, pos1, state1));
            }
        }
        return state2;
    }

    public static boolean shouldDoubleSlabSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction) {
        IHorizontalSlabSupport horizontalSlabSupport;
        BlockPos otherPos = pos.func_177972_a(direction);
        IBlockState adjacentState = world.func_180495_p(otherPos);
        TileEntity tile = world.func_175625_s(pos);
        assert (tile instanceof SlabTileEntity);
        SlabTileEntity slab = (SlabTileEntity)tile;
        assert (slab.getPositiveBlockInfo().getBlockState() != null);
        assert (slab.getNegativeBlockInfo().getBlockState() != null);
        if (state.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                assert (otherSlab.getPositiveBlockInfo().getBlockState() != null);
                assert (otherSlab.getNegativeBlockInfo().getBlockState() != null);
                return DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos, direction);
            }
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.VERTICAL_SLAB)) {
                EnumFacing facing = (EnumFacing)adjacentState.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    IBlockInfo block = direction.equals((Object)facing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                    return block.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), block.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), block.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().func_176722_c()) {
                    return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.equals((Object)EnumFacing.UP)) {
                    return otherSlab.getNegativeBlockInfo().getBlockState() == null || otherSlab.getPositiveBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                return otherSlab.getNegativeBlockInfo().getBlockState() == null || otherSlab.getPositiveBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
            }
        } else {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.VERTICAL_SLAB)) {
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                EnumFacing otherFacing = (EnumFacing)adjacentState.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                if (otherFacing.func_176740_k().equals((Object)facing.func_176740_k())) {
                    if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                        IBlockInfo block = direction.equals((Object)facing) ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                        IBlockInfo otherBlock = direction.equals((Object)otherFacing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                        return otherBlock.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block.getBlockState(), DoubleSlabCulling.matchState(block.getBlockState(), otherBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                    }
                    IBlockInfo positiveBlock = otherFacing.equals((Object)facing) ? otherSlab.getPositiveBlockInfo() : otherSlab.getNegativeBlockInfo();
                    IBlockInfo negativeBlock = otherFacing.equals((Object)facing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                    return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), positiveBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), negativeBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    IBlockInfo block = direction.equals((Object)facing) ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                    return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block.getBlockState(), DoubleSlabCulling.matchState(block.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block.getBlockState(), DoubleSlabCulling.matchState(block.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                IBlockInfo otherBlock = direction.equals((Object)otherFacing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                return otherBlock.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
            }
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    IBlockInfo block = direction.equals((Object)facing) ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                    return DoubleSlabCulling.shouldSideBeRendered(block.getBlockState(), DoubleSlabCulling.matchState(block.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block.getBlockState(), DoubleSlabCulling.matchState(block.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().func_176722_c()) {
                    return DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.equals((Object)EnumFacing.UP)) {
                    return DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(DoubleSlabCulling.getSlabForType(slab.getPositiveBlockInfo().getBlockState(), world, pos, BlockSlab.EnumBlockHalf.TOP), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos, direction);
                }
                return DoubleSlabCulling.shouldSideBeRendered(DoubleSlabCulling.getSlabForType(slab.getNegativeBlockInfo().getBlockState(), world, pos, BlockSlab.EnumBlockHalf.BOTTOM), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos, direction);
            }
        }
        if ((horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(world, pos, slab.getNegativeBlockInfo().getBlockState())) != null) {
            IBlockState doubleState = horizontalSlabSupport.getStateForHalf((World)Minecraft.func_71410_x().field_71441_e, pos, slab.getPositiveBlockInfo().getBlockState(), null);
            return doubleState.func_185894_c(world, pos, direction);
        }
        return state.func_185894_c(world, pos, direction);
    }

    public static boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, boolean positive) {
        IHorizontalSlabSupport horizontalSlabSupport;
        IBlockInfo block;
        BlockPos otherPos = pos.func_177972_a(direction);
        IBlockState adjacentState = world.func_180495_p(otherPos);
        TileEntity tile = world.func_175625_s(pos);
        assert (tile instanceof SlabTileEntity);
        SlabTileEntity slab = (SlabTileEntity)tile;
        if (state.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
            IBlockInfo currentBlock;
            IBlockInfo iBlockInfo = currentBlock = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
            assert (currentBlock.getBlockState() != null);
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                IBlockInfo otherBlock = direction.func_176740_k().func_176722_c() ? (positive ? otherSlab.getPositiveBlockInfo() : otherSlab.getNegativeBlockInfo()) : (direction.equals((Object)EnumFacing.UP) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo());
                assert (otherBlock.getBlockState() != null);
                return DoubleSlabCulling.shouldSideBeRendered(currentBlock.getBlockState(), otherBlock.getBlockState(), world, pos, otherPos, direction);
            }
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.VERTICAL_SLAB)) {
                EnumFacing facing = (EnumFacing)adjacentState.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    IBlockInfo block2 = direction.equals((Object)facing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                    return block2.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(currentBlock.getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), block2.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().func_176722_c()) {
                    return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(currentBlock.getBlockState(), DoubleSlabCulling.matchState(slab.getNegativeBlockInfo().getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(currentBlock.getBlockState(), DoubleSlabCulling.matchState(slab.getPositiveBlockInfo().getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.equals((Object)EnumFacing.UP)) {
                    assert (slab.getPositiveBlockInfo().getBlockState() != null);
                    return otherSlab.getNegativeBlockInfo().getBlockState() == null || otherSlab.getPositiveBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.getSlabForType(otherSlab.getNegativeBlockInfo().getBlockState(), world, otherPos, BlockSlab.EnumBlockHalf.BOTTOM), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getPositiveBlockInfo().getBlockState(), DoubleSlabCulling.getSlabForType(otherSlab.getPositiveBlockInfo().getBlockState(), world, otherPos, BlockSlab.EnumBlockHalf.BOTTOM), world, pos, otherPos, direction);
                }
                assert (slab.getNegativeBlockInfo().getBlockState() != null);
                return otherSlab.getNegativeBlockInfo().getBlockState() == null || otherSlab.getPositiveBlockInfo().getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.getSlabForType(otherSlab.getNegativeBlockInfo().getBlockState(), world, otherPos, BlockSlab.EnumBlockHalf.TOP), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(slab.getNegativeBlockInfo().getBlockState(), DoubleSlabCulling.getSlabForType(otherSlab.getPositiveBlockInfo().getBlockState(), world, otherPos, BlockSlab.EnumBlockHalf.TOP), world, pos, otherPos, direction);
            }
        } else {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.VERTICAL_SLAB)) {
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                EnumFacing otherFacing = (EnumFacing)adjacentState.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                if (otherFacing.func_176740_k().equals((Object)facing.func_176740_k())) {
                    if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                        IBlockInfo block3 = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                        IBlockInfo otherBlock = direction.equals((Object)otherFacing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                        return otherBlock.getBlockState() == null || block3.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block3.getBlockState(), DoubleSlabCulling.matchState(block3.getBlockState(), otherBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                    }
                    IBlockInfo positiveBlock = otherFacing.equals((Object)facing) ? otherSlab.getPositiveBlockInfo() : otherSlab.getNegativeBlockInfo();
                    IBlockInfo negativeBlock = otherFacing.equals((Object)facing) ? otherSlab.getNegativeBlockInfo() : otherSlab.getPositiveBlockInfo();
                    IBlockInfo otherBlock = positive ? positiveBlock : negativeBlock;
                    IBlockInfo currentBlock = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                    return otherBlock.getBlockState() == null || currentBlock.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(currentBlock.getBlockState(), DoubleSlabCulling.matchState(currentBlock.getBlockState(), otherBlock.getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    IBlockInfo block4 = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                    return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || block4.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block4.getBlockState(), DoubleSlabCulling.matchState(block4.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block4.getBlockState(), DoubleSlabCulling.matchState(block4.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                IBlockInfo block5 = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                return otherSlab.getPositiveBlockInfo().getBlockState() == null || otherSlab.getNegativeBlockInfo().getBlockState() == null || block5.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block5.getBlockState(), DoubleSlabCulling.matchState(block5.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block5.getBlockState(), DoubleSlabCulling.matchState(block5.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
            }
            if (adjacentState.func_177230_c().equals((Object)DSBlocks.DOUBLE_SLAB)) {
                IBlockInfo block6;
                TileEntity otherTile = world.func_175625_s(otherPos);
                assert (otherTile instanceof SlabTileEntity);
                SlabTileEntity otherSlab = (SlabTileEntity)otherTile;
                IBlockInfo iBlockInfo = block6 = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
                if (direction.func_176740_k().equals((Object)facing.func_176740_k())) {
                    return block6.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block6.getBlockState(), DoubleSlabCulling.matchState(block6.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block6.getBlockState(), DoubleSlabCulling.matchState(block6.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.func_176740_k().func_176722_c()) {
                    return block6.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(block6.getBlockState(), DoubleSlabCulling.matchState(block6.getBlockState(), otherSlab.getNegativeBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction) || DoubleSlabCulling.shouldSideBeRendered(block6.getBlockState(), DoubleSlabCulling.matchState(block6.getBlockState(), otherSlab.getPositiveBlockInfo().getBlockState(), world, pos, otherPos), world, pos, otherPos, direction);
                }
                if (direction.equals((Object)EnumFacing.UP)) {
                    IBlockState otherState = otherSlab.getNegativeBlockInfo().getBlockState();
                    return block6.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(DoubleSlabCulling.getSlabForType(block6.getBlockState(), world, pos, BlockSlab.EnumBlockHalf.TOP), otherState, world, pos, otherPos, direction);
                }
                IBlockState otherState = otherSlab.getPositiveBlockInfo().getBlockState();
                return block6.getBlockState() == null || DoubleSlabCulling.shouldSideBeRendered(DoubleSlabCulling.getSlabForType(block6.getBlockState(), world, pos, BlockSlab.EnumBlockHalf.BOTTOM), otherState, world, pos, otherPos, direction);
            }
        }
        IBlockInfo iBlockInfo = block = positive ? slab.getPositiveBlockInfo() : slab.getNegativeBlockInfo();
        if (block.getBlockState() != null && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(world, pos, block.getBlockState())) != null) {
            IBlockState doubleState = horizontalSlabSupport.getStateForHalf((World)Minecraft.func_71410_x().field_71441_e, pos, block.getBlockState(), null);
            return doubleState.func_185894_c(world, pos, direction);
        }
        return state.func_185894_c(world, pos, direction);
    }

    private static boolean isEmpty(AxisAlignedBB shape) {
        return shape.field_72340_a >= shape.field_72336_d && shape.field_72338_b >= shape.field_72337_e && shape.field_72339_c >= shape.field_72334_f;
    }

    public static boolean compare(AxisAlignedBB shape1, AxisAlignedBB shape2, BiFunction<Boolean, Boolean, Boolean> function) {
        if (function.apply(false, false).booleanValue()) {
            throw new IllegalArgumentException();
        }
        if (shape1 == shape2) {
            return function.apply(true, true);
        }
        if (DoubleSlabCulling.isEmpty(shape1)) {
            return function.apply(false, !DoubleSlabCulling.isEmpty(shape2));
        }
        if (DoubleSlabCulling.isEmpty(shape2)) {
            return function.apply(!DoubleSlabCulling.isEmpty(shape1), false);
        }
        boolean flag = function.apply(true, false);
        boolean flag1 = function.apply(false, true);
        if (shape1.field_72336_d < shape2.field_72340_a - 1.0E-7) {
            return flag || flag1;
        }
        if (shape2.field_72336_d < shape1.field_72340_a - 1.0E-7) {
            return flag || flag1;
        }
        if (shape1.field_72337_e < shape2.field_72338_b - 1.0E-7) {
            return flag || flag1;
        }
        if (shape2.field_72337_e < shape1.field_72338_b - 1.0E-7) {
            return flag || flag1;
        }
        if (shape1.field_72334_f < shape2.field_72339_c - 1.0E-7) {
            return flag || flag1;
        }
        if (shape2.field_72334_f < shape1.field_72339_c - 1.0E-7) {
            return flag || flag1;
        }
        return shape1.func_72326_a(shape2);
    }

    public static boolean shouldSideBeRendered(IBlockState state, IBlockState otherState, IBlockAccess world, BlockPos pos, BlockPos otherPos, EnumFacing side) {
        assert (state != null);
        assert (otherState != null);
        BlockAccessWrapper wrappedWorld = new BlockAccessWrapper(world, pos, otherPos, state, otherState);
        if (!ClientConstants.isTransparent(state)) {
            AxisAlignedBB bounding1 = otherState.func_185900_c(world, otherPos);
            AxisAlignedBB bounding2 = state.func_185900_c(world, pos);
            return DoubleSlabCulling.compare(bounding1, bounding2, (a, b) -> a != false && b == false);
        }
        return true;
    }
}

