/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DoubleSlabBlock
extends DynamicSlabBlock {
    protected static Optional<IBlockInfo> getHalfState(IBlockAccess world, BlockPos pos, double y) {
        return DoubleSlabBlock.getTile(world, pos).flatMap(tile -> tile.getNegativeBlockInfo().getBlockState() == null && tile.getPositiveBlockInfo().getBlockState() == null ? Optional.empty() : ((y > 0.5 || tile.getNegativeBlockInfo().getBlockState() == null) && tile.getPositiveBlockInfo().getBlockState() != null ? Optional.of(tile.getPositiveBlockInfo()) : Optional.of(tile.getNegativeBlockInfo())));
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3d hitVec = rayTraceResult.field_72307_f;
        if (hitVec == null) {
            return DoubleSlabBlock.minFloat((IBlockAccess)world, pos, i -> i.getBlockState().func_185903_a(player, i.getWorld(), pos));
        }
        return DoubleSlabBlock.getHalfState((IBlockAccess)world, pos, hitVec.field_72448_b - (double)pos.func_177956_o()).map(i -> Float.valueOf(DoubleSlabBlock.blockStrength(i.getBlockState(), player, world, pos))).orElseGet(() -> Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return DoubleSlabBlock.getHalfState((IBlockAccess)world, pos, target.field_72307_f.field_72448_b - (double)pos.func_177956_o()).map(i -> i.getBlockState().func_177230_c().getPickBlock(i.getBlockState(), target, i.getWorld(), i.getPos(), player)).orElse(ItemStack.field_190927_a);
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return DoubleSlabBlock.either(world, pos, i -> DoubleSlabBlock.canHarvestBlock(i.getBlockState().func_177230_c(), player, i.getBlockState()));
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        } else {
            SlabTileEntity tile = (SlabTileEntity)te;
            double y = hitVec.field_72448_b - (double)pos.func_177956_o();
            IBlockInfo remainingBlock = y > 0.5 ? tile.getNegativeBlockInfo() : tile.getPositiveBlockInfo();
            IBlockInfo blockToRemove = y > 0.5 ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(StatList.func_188055_a((Block)blockToRemove.getBlockState().func_177230_c()));
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.func_184812_l_()) {
                blockToRemove.getBlockState().func_177230_c().func_180657_a(blockToRemove.getWorld(), player, blockToRemove.getPos(), blockToRemove.getBlockState(), blockToRemove.getTileEntity(), stack);
            }
            if (!world.field_72995_K) {
                blockToRemove.getBlockState().func_177230_c().func_180663_b(blockToRemove.getWorld(), blockToRemove.getPos(), Blocks.field_150350_a.func_176223_P());
            }
            world.func_180501_a(pos, remainingBlock.getExtendedBlockState(), 3);
            world.func_175690_a(pos, remainingBlock.getTileEntity());
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return DoubleSlabBlock.getTile((IBlockAccess)world, pos).map(tile -> {
            float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
            double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
            int numOfParticles = (int)(150.0 * d0);
            world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)tile.getPositiveBlockInfo().getBlockState())});
            return true;
        }).orElse(false);
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            DoubleSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)tile.getPositiveBlockInfo().getBlockState())}));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            return DoubleSlabBlock.getHalfState((IBlockAccess)world, target.func_178782_a(), target.field_72307_f.field_72448_b).map(info -> {
                BlockPos pos = target.func_178782_a();
                EnumFacing side = target.field_178784_b;
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                ParticleDigging.Factory factory = new ParticleDigging.Factory();
                ParticleDigging particle = (ParticleDigging)factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)info.getBlockState())});
                if (particle == null) {
                    return false;
                }
                particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a((Particle)particle);
                return true;
            }).orElse(false);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void createDestroyParticle(World world, BlockPos pos, ParticleManager manager, IBlockState state, ParticleDigging.Factory factory, double d0, double d1, double d2) {
        ParticleDigging particle = (ParticleDigging)factory.func_178902_a(0, world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
        if (particle == null) {
            return;
        }
        particle.func_174846_a(pos);
        manager.func_78873_a((Particle)particle);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return DoubleSlabBlock.getTile((IBlockAccess)world, pos).map(tile -> {
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        if (tile.getPositiveBlockInfo().getBlockState() != null) {
                            this.createDestroyParticle(world, pos, manager, tile.getPositiveBlockInfo().getBlockState(), factory, d0, d1, d2);
                        }
                        if (tile.getNegativeBlockInfo().getBlockState() == null) continue;
                        this.createDestroyParticle(world, pos, manager, tile.getNegativeBlockInfo().getBlockState(), factory, d0, d1, d2);
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() != this) {
            return false;
        }
        return DoubleSlabBlock.getHalfState((IBlockAccess)world, pos, hitY).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((IBlockAccess)world, pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.field_72995_K) {
                    player.openGui((Object)DoubleSlabs.instance, i.isPositive() ? 0 : 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            try {
                return slabSupport == null ? i.getBlockState().func_177230_c().func_180639_a(i.getWorld(), pos, i.getBlockState(), player, hand, facing, hitX, hitY, hitZ) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, facing, hitX, hitY, hitZ);
            }
            catch (Exception e) {
                return false;
            }
        }).orElse(false);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult result = RayTraceUtil.rayTrace(player);
        if (result.field_72307_f != null) {
            DoubleSlabBlock.getHalfState((IBlockAccess)world, pos, result.field_72307_f.field_72448_b - (double)pos.func_177956_o()).ifPresent(i -> i.getBlockState().func_177230_c().func_180649_a(i.getWorld(), i.getPos(), player));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!DoubleSlabBlock.getTile((IBlockAccess)world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_180658_a(tile.getPositiveBlockInfo().getWorld(), pos, entity, fallDistance);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        BlockPos pos = new BlockPos(entity.func_174791_d()).func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !DoubleSlabBlock.getTile((IBlockAccess)world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176216_a(tile.getPositiveBlockInfo().getWorld(), entity);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        DoubleSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176199_a(tile.getPositiveBlockInfo().getWorld(), pos, entity);
            }
        });
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        DoubleSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_180634_a(world, pos, tile.getPositiveBlockInfo().getBlockState(), entity);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                tile.getNegativeBlockInfo().getBlockState().func_177230_c().func_180634_a(world, pos, tile.getNegativeBlockInfo().getBlockState(), entity);
            }
        });
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return DoubleSlabBlock.getTile((IBlockAccess)world, pos).flatMap(tile -> tile.getPositiveBlockInfo().getBlockState() != null ? Optional.of(tile.getPositiveBlockInfo().getBlockState().func_177230_c().getSoundType(tile.getPositiveBlockInfo().getBlockState(), tile.getPositiveBlockInfo().getWorld(), pos, entity)) : Optional.empty()).orElseGet(() -> super.getSoundType(state, world, pos, entity));
    }
}

