/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.common.blocks.properties.UnlistedPropertyBlockInfo;
import cjminecraft.doubleslabs.common.blocks.properties.UnlistedPropertyBoolean;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicSlabBlock
extends Block {
    public static final UnlistedPropertyBlockInfo POSITIVE_BLOCK = new UnlistedPropertyBlockInfo();
    public static final UnlistedPropertyBlockInfo NEGATIVE_BLOCK = new UnlistedPropertyBlockInfo();
    public static final UnlistedPropertyBoolean RENDER_POSITIVE = new UnlistedPropertyBoolean();

    public DynamicSlabBlock() {
        super(Material.field_151576_e);
    }

    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, @Nonnull IBlockState state) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = block.getHarvestTool(state);
        if (!stack.func_190926_b() && tool != null) {
            int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
            if (toolLevel < 0) {
                return player.func_184823_b(state);
            }
            return toolLevel >= block.getHarvestLevel(state);
        }
        return player.func_184823_b(state);
    }

    public static float blockStrength(@Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        return !DynamicSlabBlock.canHarvestBlock(state.func_177230_c(), player, state) ? player.getDigSpeed(state, pos) / hardness / 100.0f : player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return DynamicSlabBlock.either(state, i -> i.getBlockState().func_185895_e());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{POSITIVE_BLOCK, NEGATIVE_BLOCK, RENDER_POSITIVE}).build();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, world, pos);
        return actualState instanceof IExtendedBlockState ? (IBlockState)DynamicSlabBlock.getTile(world, pos).map(tile -> ((IExtendedBlockState)actualState).withProperty((IUnlistedProperty)POSITIVE_BLOCK, (Object)tile.getPositiveBlockInfo()).withProperty((IUnlistedProperty)NEGATIVE_BLOCK, (Object)tile.getNegativeBlockInfo())).orElse((IExtendedBlockState)actualState) : actualState;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public static Optional<SlabTileEntity> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof SlabTileEntity ? Optional.of((SlabTileEntity)tile) : Optional.empty();
    }

    public static Optional<IBlockInfo> getAvailable(IBlockAccess world, BlockPos pos) {
        return DynamicSlabBlock.getTile(world, pos).flatMap(tile -> Optional.of(tile.getPositiveBlockInfo().getBlockState() != null ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo()));
    }

    public static int min(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : Integer.MAX_VALUE, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 2.147483647E9, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockAccess world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : 0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockAccess world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> (tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0) + (tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockAccess world, BlockPos pos, Consumer<IBlockInfo> consumer) {
        DynamicSlabBlock.getTile(world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getPositiveBlockInfo());
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getNegativeBlockInfo());
            }
            return null;
        });
    }

    public static boolean both(IBlockAccess world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    public static boolean either(IBlockAccess world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) || tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    public static Optional<IStateContainer> getStateContainer(IBlockState state) {
        if (!(state.func_177230_c() instanceof DynamicSlabBlock)) {
            return Optional.empty();
        }
        if (state instanceof IExtendedBlockState) {
            final IBlockInfo positiveBlock = (IBlockInfo)((IExtendedBlockState)state).getValue((IUnlistedProperty)POSITIVE_BLOCK);
            final IBlockInfo negativeBlock = (IBlockInfo)((IExtendedBlockState)state).getValue((IUnlistedProperty)NEGATIVE_BLOCK);
            if (negativeBlock == null || positiveBlock == null) {
                return Optional.empty();
            }
            return Optional.of(new IStateContainer(){

                @Override
                public IBlockInfo getPositiveBlockInfo() {
                    return positiveBlock;
                }

                @Override
                public IBlockInfo getNegativeBlockInfo() {
                    return negativeBlock;
                }
            });
        }
        return Optional.empty();
    }

    public static boolean either(IBlockState state, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getStateContainer(state).map(c -> c.getPositiveBlockInfo().getBlockState() != null && predicate.test(c.getPositiveBlockInfo()) || c.getNegativeBlockInfo().getBlockState() != null && predicate.test(c.getNegativeBlockInfo())).orElse(false);
    }

    public static boolean both(IBlockState state, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getStateContainer(state).map(c -> c.getPositiveBlockInfo().getBlockState() != null && c.getNegativeBlockInfo().getBlockState() != null && predicate.test(c.getPositiveBlockInfo()) && predicate.test(c.getNegativeBlockInfo())).orElse(false);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new SlabTileEntity();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_177230_c().getLightOpacity(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos()));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return DynamicSlabBlock.maxFloat((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().getExplosionResistance(i.getWorld(), i.getPos(), exploder, explosion));
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getLightValue((IBlockAccess)i.getWorld(), i.getPos()));
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        DynamicSlabBlock.runIfAvailable(world, pos, i -> i.getBlockState().func_177230_c().getDrops(drops, (IBlockAccess)i.getWorld(), i.getPos(), i.getBlockState(), fortune));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.func_184812_l_()) {
            DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_180663_b(i.getWorld(), pos, i.getBlockState()));
            super.func_176208_a(world, pos, state, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return DynamicSlabBlock.getTile(world, pos).map(tile -> {
                if (tintIndex >= 1000) {
                    return tile.getPositiveBlockInfo().getBlockState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getPositiveBlockInfo().getBlockState(), (IBlockAccess)tile.getPositiveBlockInfo().getWorld(), pos, tintIndex - 1000) : -1;
                }
                return tile.getNegativeBlockInfo().getBlockState() != null ? Minecraft.func_71410_x().func_184125_al().func_186724_a(tile.getNegativeBlockInfo().getBlockState(), (IBlockAccess)tile.getNegativeBlockInfo().getWorld(), pos, tintIndex) : -1;
            }).orElse(-1);
        };
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(world, pos, state, random);
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_180645_a(i.getWorld(), i.getPos(), i.getBlockState(), random));
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().canConnectRedstone(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), side));
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_185911_a((IBlockAccess)i.getWorld(), pos, side));
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_185893_b((IBlockAccess)i.getWorld(), pos, side));
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return DynamicSlabBlock.max((IBlockAccess)world, pos, i -> i.getBlockState().func_185888_a(i.getWorld(), pos));
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return DynamicSlabBlock.addFloat((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().getEnchantPowerBonus(i.getWorld(), i.getPos()));
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        try {
            return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_177230_c().getFireSpreadSpeed((IBlockAccess)i.getWorld(), i.getPos(), face));
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150344_f.getFireSpreadSpeed(world, pos, face);
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        try {
            return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_177230_c().getFlammability((IBlockAccess)i.getWorld(), i.getPos(), face));
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150344_f.getFlammability(world, pos, face);
        }
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().getWeakChanges((IBlockAccess)i.getWorld(), i.getPos()));
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().isBurning((IBlockAccess)i.getWorld(), i.getPos()));
    }

    public boolean isFertile(World world, BlockPos pos) {
        return DynamicSlabBlock.either((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().isFertile(i.getWorld(), i.getPos()));
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return DynamicSlabBlock.either((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().isFireSource(i.getWorld(), i.getPos(), side));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        try {
            return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().isFlammable((IBlockAccess)i.getWorld(), i.getPos(), face));
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150344_f.isFlammable(world, pos, face);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_189546_a(i.getWorld(), i.getPos(), i.getBlockState().func_177230_c(), fromPos));
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        DynamicSlabBlock.runIfAvailable(world, pos, i -> i.getBlockState().func_177230_c().onNeighborChange((IBlockAccess)i.getWorld(), i.getPos(), neighbor));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_180650_b(i.getWorld(), i.getPos(), i.getBlockState(), rand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_180655_c(i.getBlockState(), i.getWorld(), i.getPos(), rand));
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_180652_a(i.getWorld(), pos, explosion));
    }

    public void func_176224_k(World world, BlockPos pos) {
        DynamicSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176224_k(tile.getPositiveBlockInfo().getWorld(), pos);
            }
        });
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        return DynamicSlabBlock.maxFloat(world, pos, i -> i.getBlockState().func_177230_c().getSlipperiness(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), entity));
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getPositiveBlockInfo().getBlockState().func_177230_c().canSustainPlant(tile.getPositiveBlockInfo().getBlockState(), (IBlockAccess)tile.getPositiveBlockInfo().getWorld(), pos, direction, plantable)).orElse(false);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_176213_c(i.getWorld(), i.getPos(), i.getBlockState()));
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        return DynamicSlabBlock.either((IBlockAccess)world, pos, i -> i.getBlockState().func_189547_a(i.getWorld(), pos, id, param));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().isLadder(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), entity));
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().func_177230_c().isBed(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), player));
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().onPlantGrow(i.getBlockState(), i.getWorld(), i.getPos(), source));
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_177230_c().getExpDrop(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), fortune));
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return DynamicSlabBlock.getAvailable((IBlockAccess)world, pos).map(i -> i.getBlockState().func_177230_c().getSoundType(i.getBlockState(), i.getWorld(), pos, null)).orElse(super.getSoundType(state, world, pos, null));
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        ArrayList result = new ArrayList();
        DynamicSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            float[] positiveBlockColours = null;
            float[] negativeBlockColours = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockColours = tile.getPositiveBlockInfo().getBlockState().func_177230_c().getBeaconColorMultiplier(tile.getPositiveBlockInfo().getBlockState(), tile.getPositiveBlockInfo().getWorld(), pos, beaconPos);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockColours = tile.getNegativeBlockInfo().getBlockState().func_177230_c().getBeaconColorMultiplier(tile.getNegativeBlockInfo().getBlockState(), tile.getNegativeBlockInfo().getWorld(), pos, beaconPos);
            }
            if (positiveBlockColours != null) {
                for (float colour : positiveBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
            if (negativeBlockColours != null) {
                for (float colour : negativeBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
        });
        if (result.size() == 0) {
            return null;
        }
        float[] colours = new float[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            colours[i] = ((Float)result.get(i)).floatValue();
        }
        return colours;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> {
            PathNodeType positiveBlockNodeType = null;
            PathNodeType negativeBlockNodeType = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockNodeType = tile.getPositiveBlockInfo().getBlockState().func_177230_c().getAiPathNodeType(tile.getPositiveBlockInfo().getBlockState(), (IBlockAccess)tile.getPositiveBlockInfo().getWorld(), pos, entity);
            }
            if (positiveBlockNodeType != null) {
                return positiveBlockNodeType;
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockNodeType = tile.getNegativeBlockInfo().getBlockState().func_177230_c().getAiPathNodeType(tile.getNegativeBlockInfo().getBlockState(), (IBlockAccess)tile.getNegativeBlockInfo().getWorld(), pos, entity);
            }
            return negativeBlockNodeType;
        }).orElse(super.getAiPathNodeType(state, world, pos, entity));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return DynamicSlabBlock.both(world, pos, i -> i.getBlockState().func_177230_c().canEntityDestroy(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), entity));
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().onBlockExploded(i.getWorld(), i.getPos(), explosion));
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_149653_t() {
        return true;
    }

    public boolean func_176214_u(IBlockState state) {
        return DynamicSlabBlock.either(state, i -> i.getBlockState().func_191058_s());
    }
}

