/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.properties.UnlistedPropertyBoolean;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VerticalSlabBlock
extends DynamicSlabBlock {
    public static final UnlistedPropertyBoolean ROTATE_POSITIVE = new UnlistedPropertyBoolean();
    public static final UnlistedPropertyBoolean ROTATE_NEGATIVE = new UnlistedPropertyBoolean();
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool DOUBLE = PropertyBool.func_177716_a((String)"double");

    public VerticalSlabBlock() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public static Optional<IBlockInfo> getHalfState(IBlockAccess world, BlockPos pos, double x, double z) {
        IBlockState state = world.func_180495_p(pos);
        return VerticalSlabBlock.getTile(world, pos).map(tile -> {
            IBlockInfo iBlockInfo;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (tile.getPositiveBlockInfo().getBlockState() == null && tile.getNegativeBlockInfo().getBlockState() == null) {
                                return null;
                            }
                            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() != EnumFacing.AxisDirection.POSITIVE) break block5;
                            double d = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z;
                            if (!(d > 0.5)) break block6;
                            break block7;
                        }
                        if ((((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? x : z) < 0.5) break block7;
                    }
                    if (tile.getNegativeBlockInfo().getBlockState() != null) break block8;
                }
                if (tile.getPositiveBlockInfo().getBlockState() != null) {
                    iBlockInfo = tile.getPositiveBlockInfo();
                    return iBlockInfo;
                }
            }
            iBlockInfo = tile.getNegativeBlockInfo();
            return iBlockInfo;
        }).flatMap(block -> block == null || block.getBlockState() == null ? Optional.empty() : Optional.of(block));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{POSITIVE_BLOCK, NEGATIVE_BLOCK, ROTATE_POSITIVE, ROTATE_NEGATIVE, RENDER_POSITIVE}).add(new IProperty[]{FACING, DOUBLE}).build();
    }

    private boolean rotateModel(IBlockInfo info) {
        if (info.getBlockState() == null) {
            return false;
        }
        IVerticalSlabSupport support = SlabSupport.getVerticalSlabSupport((IBlockAccess)info.getWorld(), info.getPos(), info.getBlockState());
        if (support != null) {
            return support.rotateModel((IBlockAccess)info.getWorld(), info.getPos(), info.getBlockState());
        }
        return true;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState superState = super.getExtendedState(state, world, pos);
        if (superState instanceof IExtendedBlockState) {
            IExtendedBlockState extendedBlockState = (IExtendedBlockState)superState;
            return (IBlockState)VerticalSlabBlock.getTile(world, pos).map(tile -> extendedBlockState.withProperty((IUnlistedProperty)ROTATE_POSITIVE, (Object)this.rotateModel(tile.getPositiveBlockInfo())).withProperty((IUnlistedProperty)ROTATE_NEGATIVE, (Object)this.rotateModel(tile.getNegativeBlockInfo()))).orElse(extendedBlockState);
        }
        return superState;
    }

    @Override
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (VerticalSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() == null || tile.getNegativeBlockInfo().getBlockState() == null).orElse(false).booleanValue()) {
            return 0;
        }
        return VerticalSlabBlock.min(world, pos, i -> i.getBlockState().getLightOpacity((IBlockAccess)i.getWorld(), i.getPos()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(meta >= 4)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4)));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE) != false ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + 4 : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149730_j(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    @Override
    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DOUBLE);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean positive;
        float value;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return state.func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(true));
        }
        if (facing.func_176740_k().func_176720_b()) {
            Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ).func_178786_a(0.5, 0.0, 0.5);
            double angle = Math.atan2(vec.field_72450_a, vec.field_72449_c) * -180.0 / Math.PI;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176733_a((double)angle));
        }
        float f = value = placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? hitZ : hitX;
        if ((double)value > 0.25 && (double)value < 0.75) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
        }
        boolean bl = placer.func_174811_aO().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (double)value > 0.5 : (positive = (double)value < 0.5);
        if (placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z) {
            positive = !positive;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(positive ? facing.func_176735_f() : facing.func_176746_e()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)DOUBLE)).booleanValue()) {
            return field_185505_j;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        double min = 0.0;
        double max = 8.0;
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            min = 8.0;
            max = 16.0;
        }
        if (tileEntity instanceof SlabTileEntity) {
            boolean negative;
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            boolean bl = negative = tile.getNegativeBlockInfo().getBlockState() != null;
            if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE && positive || ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && negative) {
                min = 8.0;
                max = 16.0;
            } else {
                min = 0.0;
                max = 8.0;
            }
        }
        if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X) {
            return new AxisAlignedBB(min / 16.0, 0.0, 0.0, max / 16.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, min / 16.0, 1.0, 1.0, max / 16.0);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null) {
            return VerticalSlabBlock.minFloat((IBlockAccess)world, pos, i -> VerticalSlabBlock.blockStrength(i.getBlockState(), player, i.getWorld(), pos));
        }
        return VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72449_c - (double)pos.func_177952_p()).map(i -> Float.valueOf(VerticalSlabBlock.blockStrength(i.getBlockState(), player, i.getWorld(), pos))).orElse(Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, target.field_72307_f.field_72450_a - (double)pos.func_177958_n(), target.field_72307_f.field_72449_c - (double)pos.func_177952_p()).map(i -> i.getBlockState().func_177230_c().getPickBlock(i.getBlockState(), target, i.getWorld(), pos, player)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af() && ((Boolean)state.func_177229_b((IProperty)DOUBLE)).booleanValue()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vec3d hitVec;
        RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3d vec3d = hitVec = rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK ? rayTraceResult.field_72307_f : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        } else if (((Boolean)state.func_177229_b((IProperty)DOUBLE)).booleanValue()) {
            double distance;
            SlabTileEntity tile = (SlabTileEntity)te;
            double d = distance = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? hitVec.field_72450_a - (double)pos.func_177958_n() : hitVec.field_72449_c - (double)pos.func_177952_p();
            boolean positive = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? distance > 0.5 : distance < 0.5;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(StatList.func_188055_a((Block)blockToRemove.getBlockState().func_177230_c()));
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.func_184812_l_()) {
                blockToRemove.getBlockState().func_177230_c().func_180657_a(blockToRemove.getWorld(), player, blockToRemove.getPos(), blockToRemove.getBlockState(), blockToRemove.getTileEntity(), stack);
            }
            if (!world.field_72995_K) {
                blockToRemove.getBlockState().func_177230_c().func_180663_b(blockToRemove.getWorld(), blockToRemove.getPos(), blockToRemove.getBlockState());
            }
            blockToRemove.setBlockState(null);
            world.func_180501_a(pos, this.getExtendedState(state.func_177226_a((IProperty)DOUBLE, (Comparable)Boolean.valueOf(false)), (IBlockAccess)world, pos), 11);
            world.func_175664_x(pos);
        } else {
            SlabTileEntity tile = (SlabTileEntity)te;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(StatList.func_188055_a((Block)blockToRemove.getBlockState().func_177230_c()));
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.func_184812_l_()) {
                blockToRemove.getBlockState().func_177230_c().func_180657_a(blockToRemove.getWorld(), player, blockToRemove.getPos(), blockToRemove.getBlockState(), blockToRemove.getTileEntity(), stack);
            }
            if (!world.field_72995_K) {
                blockToRemove.getBlockState().func_177230_c().func_180663_b(blockToRemove.getWorld(), blockToRemove.getPos(), blockToRemove.getBlockState());
            }
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        }
    }

    public boolean addLandingEffects(IBlockState state1, WorldServer worldServer, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int numOfParticles = (Boolean)state1.func_177229_b((IProperty)DOUBLE) != false ? (int)(75.0 * d0) : (int)(150.0 * d0);
        VerticalSlabBlock.runIfAvailable((IBlockAccess)worldServer, pos, i -> worldServer.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)i.getBlockState())}));
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            VerticalSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)i.getBlockState())}));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            return VerticalSlabBlock.getHalfState((IBlockAccess)world, target.func_178782_a(), target.field_72307_f.field_72450_a - (double)target.func_178782_a().func_177958_n(), target.field_72307_f.field_72449_c - (double)target.func_178782_a().func_177952_p()).map(info -> {
                BlockPos pos = target.func_178782_a();
                EnumFacing side = target.field_178784_b;
                double i = pos.func_177958_n();
                double j = pos.func_177956_o();
                double k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185890_d((IBlockAccess)world, pos);
                double d0 = i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                ParticleDigging.Factory factory = new ParticleDigging.Factory();
                Particle particle = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)info.getBlockState())});
                if (particle != null) {
                    ((ParticleDigging)particle).func_174846_a(pos);
                    particle = particle.func_70543_e(0.2f).func_70541_f(0.6f);
                    manager.func_78873_a(particle);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return VerticalSlabBlock.getTile((IBlockAccess)world, pos).map(tile -> {
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        Particle particle2;
                        Particle particle1;
                        double d0 = ((double)j + 0.5) / 4.0 + (double)pos.func_177958_n();
                        double d1 = ((double)k + 0.5) / 4.0 + (double)pos.func_177956_o();
                        double d2 = ((double)l + 0.5) / 4.0 + (double)pos.func_177952_p();
                        if (tile.getPositiveBlockInfo().getBlockState() != null && (particle1 = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)tile.getPositiveBlockInfo().getBlockState())})) != null) {
                            manager.func_78873_a(particle1);
                        }
                        if (tile.getNegativeBlockInfo().getBlockState() == null || (particle2 = factory.func_178902_a(1, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)tile.getNegativeBlockInfo().getBlockState())})) == null) continue;
                        manager.func_78873_a(particle2);
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() != this) {
            return false;
        }
        return VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, hitX, hitZ).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((IBlockAccess)world, pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.field_72995_K) {
                    player.openGui((Object)DoubleSlabs.instance, i.isPositive() ? 0 : 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            try {
                return slabSupport == null ? i.getBlockState().func_177230_c().func_180639_a(i.getWorld(), i.getPos(), i.getBlockState(), player, hand, facing, hitX, hitY, hitZ) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, facing, hitX, hitY, hitZ);
            }
            catch (Exception e) {
                return false;
            }
        }).orElse(false);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult result = RayTraceUtil.rayTrace(player);
        if (result.field_72307_f != null) {
            VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, result.field_72307_f.field_72450_a - (double)pos.func_177958_n(), result.field_72307_f.field_72449_c - (double)pos.func_177952_p()).ifPresent(i -> i.getBlockState().func_177230_c().func_180649_a(i.getWorld(), i.getPos(), player));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_180658_a(i.getWorld(), pos, entity, fallDistance);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        BlockPos pos = new BlockPos(entity.func_174791_d()).func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_176216_a(i.getWorld(), entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_176199_a(i.getWorld(), pos, entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176199_a(world, pos, entity);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).ifPresent(i -> i.getBlockState().func_177230_c().func_180634_a(i.getWorld(), i.getPos(), i.getBlockState(), entity));
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (entity != null) {
            return VerticalSlabBlock.getHalfState((IBlockAccess)world, pos, entity.field_70165_t - (double)pos.func_177958_n(), entity.field_70161_v - (double)pos.func_177952_p()).map(i -> i.getBlockState().func_177230_c().getSoundType(i.getBlockState(), i.getWorld(), i.getPos(), entity)).orElseGet(() -> super.getSoundType(state, world, pos, entity));
        }
        return VerticalSlabBlock.getAvailable((IBlockAccess)world, pos).map(i -> i.getBlockState().func_177230_c().getSoundType(i.getBlockState(), i.getWorld(), i.getPos(), null)).orElseGet(() -> super.getSoundType(state, world, pos, null));
    }

    @Override
    public void func_176224_k(World world, BlockPos pos) {
        VerticalSlabBlock.runIfAvailable((IBlockAccess)world, pos, i -> i.getBlockState().func_177230_c().func_176224_k(i.getWorld(), i.getPos()));
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return VerticalSlabBlock.both(world, pos, i -> i.getBlockState().func_177230_c().canSustainPlant(i.getBlockState(), (IBlockAccess)i.getWorld(), i.getPos(), direction, plantable));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return VerticalSlabBlock.either(world, pos, i -> VerticalSlabBlock.canHarvestBlock(i.getBlockState().func_177230_c(), player, i.getBlockState()));
    }

    @Override
    public boolean func_176214_u(IBlockState state) {
        return VerticalSlabBlock.both(state, i -> i.getBlockState().func_191058_s());
    }
}

