/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.config;

import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.placement.VerticalSlabPlacementMethod;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class DSConfig {
    public static final Client CLIENT = new Client();
    public static final Server SERVER = new Server();
    private static Configuration config = null;

    public static void load(File configFile) {
        config = new Configuration(configFile);
        DSConfig.syncFromFiles();
    }

    private static void sync(boolean load, boolean read) {
        if (load) {
            config.load();
        }
        try {
            SERVER.sync(read);
            CLIENT.sync(read);
        }
        catch (IllegalArgumentException e) {
            DoubleSlabs.LOGGER.error("Error when syncing config. Error: " + e.getLocalizedMessage());
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void syncFromFiles() {
        DSConfig.sync(true, true);
    }

    public static void syncFromGui() {
        DSConfig.sync(false, true);
    }

    public static void syncFromFields() {
        DSConfig.sync(false, false);
    }

    private static boolean isItemPresent(List<String> option, Item item) {
        return DSConfig.isItemPresent(option, item.func_190903_i());
    }

    private static boolean isItemPresent(List<String> option, ItemStack stack) {
        if (stack.func_77973_b().getRegistryName() == null) {
            return false;
        }
        return option.stream().anyMatch(entry -> {
            if (entry.startsWith("*")) {
                return true;
            }
            return entry.equals(stack.func_77973_b().getRegistryName().toString()) || entry.equals(stack.func_77973_b().getRegistryName().toString() + "/" + stack.func_77952_i());
        });
    }

    private static String slabToString(IBlockState state) {
        if (state == null) {
            return "null";
        }
        Block block = state.func_177230_c();
        if (state.func_177230_c().getRegistryName() == null) {
            return "";
        }
        if (block instanceof BlockSlab) {
            BlockSlab slab = (BlockSlab)block;
            try {
                if (slab.func_176551_l() == BlockSlab.field_176554_a || slab.func_176551_l() == null) {
                    return state.func_177230_c().getRegistryName().toString();
                }
                return state.func_177230_c().getRegistryName().toString() + (slab.func_176551_l().func_177700_c().size() == 1 ? "" : "#" + slab.func_176551_l().func_177701_a() + "=" + state.func_177229_b(slab.func_176551_l()).toString());
            }
            catch (Exception e) {
                return state.func_177230_c().getRegistryName().toString();
            }
        }
        return state.func_177230_c().getRegistryName().toString();
    }

    private static boolean isBlockPresent(List<String> option, Block block) {
        return DSConfig.isBlockPresent(option, block.func_176223_P());
    }

    private static boolean isBlockPresent(List<String> option, IBlockState state) {
        if (state.func_177230_c().getRegistryName() == null) {
            return false;
        }
        String stringState = DSConfig.slabToString(state);
        return option.stream().anyMatch(entry -> {
            if (entry.startsWith("*")) {
                return true;
            }
            return entry.equals(stringState);
        });
    }

    public static class Client {
        public List<String> uvlockModelBlacklist;
        public List<String> slabCullBlacklist;
        public List<String> useDoubleSlabModelBlacklist;
        public VerticalSlabPlacementMethod verticalSlabPlacementMethod;

        public void sync(boolean read) {
            Property propertyUvlockModelBlacklist = config.get("client", "uvlockModelBlacklist", new String[]{"minecraft:stone_slab#variant=stone", "minecraft:stone_slab#variant=sandstone", "minecraft:stone_slab2#variant=red_sandstone", "minecraft:stone_slab", "minecraft:sandstone_slab", "minecraft:red_sandstone_slab"});
            propertyUvlockModelBlacklist.setComment("The list of slabs which should use the lazy model rendering technique\nThis often yields better looking results with wooden planks and does not necessarily improve the look of all vertical slabs\nUse the wildcard value * to enable this feature for all slabs");
            propertyUvlockModelBlacklist.setLanguageKey("doubleslabs.configgui.uvlockModelBlacklist");
            Property propertySlabCullBlacklist = config.get("client", "slabCullBlacklist", new String[0]);
            propertySlabCullBlacklist.setComment("The list of slabs which should not be culled when combined\nUse the wildcard value * to disable this feature for all slabs");
            propertySlabCullBlacklist.setLanguageKey("doubleslabs.configgui.slabCullBlacklist");
            Property propertyUseDoubleSlabModelBlacklist = config.get("client", "useDoubleSlabModelBlacklist", new String[0]);
            propertyUseDoubleSlabModelBlacklist.setComment("The list of slabs which should not use the double variant model when two of the same slab are combined together\nUse the wildcard value * to disable this feature for all slabs");
            propertyUseDoubleSlabModelBlacklist.setLanguageKey("doubleslabs.configgui.useDoubleSlabModelBlacklist");
            Property propertyVerticalSlabPlacementMethod = config.get("client", "verticalSlabPlacementMethod", VerticalSlabPlacementMethod.DYNAMIC.name());
            propertyVerticalSlabPlacementMethod.setComment("Which placement method to use to place vertical slabs\nThis is a per user option and can be any of the following values:\nPLACE_WHEN_SNEAKING - Only place vertical slabs when you are sneaking\nDYNAMIC - Place vertical slabs when clicking on the side of a block unless you are sneaking and place vertical slabs when sneaking when looking at the top or bottom face of a block but place regular slabs by default");
            propertyVerticalSlabPlacementMethod.setValidValues((String[])Arrays.stream(VerticalSlabPlacementMethod.values()).map(Enum::name).toArray(String[]::new));
            propertyVerticalSlabPlacementMethod.setLanguageKey("doubleslabs.configgui.verticalSlabPlacementMethod");
            config.setCategoryPropertyOrder("client", (List)Lists.newArrayList((Object[])new String[]{propertyUvlockModelBlacklist.getName(), propertySlabCullBlacklist.getName(), propertyUseDoubleSlabModelBlacklist.getName(), propertyVerticalSlabPlacementMethod.getName()}));
            if (read) {
                this.uvlockModelBlacklist = Lists.newArrayList((Object[])propertyUvlockModelBlacklist.getStringList());
                this.slabCullBlacklist = Lists.newArrayList((Object[])propertySlabCullBlacklist.getStringList());
                this.useDoubleSlabModelBlacklist = Lists.newArrayList((Object[])propertyUseDoubleSlabModelBlacklist.getStringList());
                this.verticalSlabPlacementMethod = VerticalSlabPlacementMethod.valueOf(propertyVerticalSlabPlacementMethod.getString());
            }
            propertyUvlockModelBlacklist.set(this.uvlockModelBlacklist.toArray(new String[0]));
            propertySlabCullBlacklist.set(this.slabCullBlacklist.toArray(new String[0]));
            propertyUseDoubleSlabModelBlacklist.set(this.useDoubleSlabModelBlacklist.toArray(new String[0]));
            propertyVerticalSlabPlacementMethod.set(this.verticalSlabPlacementMethod.name());
        }

        public boolean shouldCull(IBlockState state) {
            return !DSConfig.isBlockPresent((List<String>)this.slabCullBlacklist, state);
        }

        public boolean useLazyModel(IBlockState state) {
            return DSConfig.isBlockPresent((List<String>)this.uvlockModelBlacklist, state);
        }

        public boolean useDoubleSlabModel(IBlockState state) {
            return !DSConfig.isBlockPresent((List<String>)this.useDoubleSlabModelBlacklist, state);
        }

        public boolean uvlock(IBlockState state) {
            return !DSConfig.isBlockPresent((List<String>)this.uvlockModelBlacklist, state);
        }

        public boolean uvlock(Item item) {
            return !DSConfig.isItemPresent((List<String>)this.uvlockModelBlacklist, item);
        }
    }

    public static class Server {
        public List<String> slabBlacklist;
        public List<String> verticalSlabBlacklist;
        public boolean replaceSameSlab;
        public boolean disableVerticalSlabPlacement;
        public List<String> verticalSlabCraftingBlacklist;

        public boolean isBlacklistedHorizontalSlab(IBlockState state) {
            return DSConfig.isBlockPresent((List<String>)this.slabBlacklist, state);
        }

        public boolean isBlacklistedVerticalSlab(IBlockState state) {
            return DSConfig.isBlockPresent((List<String>)this.verticalSlabBlacklist, state);
        }

        public boolean isBlacklistedCraftingItem(ItemStack stack) {
            return DSConfig.isItemPresent((List<String>)this.verticalSlabCraftingBlacklist, stack);
        }

        public void sync(boolean read) {
            Property propertySlabBlacklist = config.get("general", "slabBlacklist", new String[0]);
            propertySlabBlacklist.setComment("The list of slabs to ignore when creating double slabs\nExample: minecraft:purpur_slab");
            propertySlabBlacklist.setLanguageKey("doubleslabs.configgui.slabBlacklist");
            Property propertyVerticalSlabBlacklist = config.get("general", "verticalSlabBlacklist", new String[0]);
            propertyVerticalSlabBlacklist.setComment("The list of slabs to ignore when creating vertical slabs\nExample: minecraft:purpur_slab");
            propertyVerticalSlabBlacklist.setLanguageKey("doubleslabs.configgui.verticalSlabBlacklist");
            Property propertyReplaceSameSlab = config.get("general", "replaceSameSlab", true);
            propertyReplaceSameSlab.setComment("Whether to use the custom double slab when combining slabs of the same type");
            propertyReplaceSameSlab.setLanguageKey("doubleslabs.configgui.replaceSameSlab");
            Property propertyDisableVerticalSlabPlacement = config.get("general", "disableVerticalSlabPlacement", false);
            propertyDisableVerticalSlabPlacement.setComment("Whether to disable the placement of vertical slabs from regular horizontal slabs");
            propertyDisableVerticalSlabPlacement.setLanguageKey("doubleslabs.configgui.disableVerticalSlabPlacement");
            Property propertyVerticalSlabCraftingBlacklist = config.get("general", "verticalSlabCraftingBlacklist", new String[0]);
            propertyVerticalSlabCraftingBlacklist.setComment("The list of slabs to ignore when trying to convert between a regular slab and a vertical slab item\nUse the wildcard value * to disable this feature for all slabs\nUse the \"/\" symbol after an item name to specifiy specific meta data");
            propertyVerticalSlabCraftingBlacklist.setLanguageKey("doubleslabs.configgui.verticalSlabCraftingBlacklist");
            config.setCategoryPropertyOrder("general", (List)Lists.newArrayList((Object[])new String[]{propertySlabBlacklist.getName(), propertyVerticalSlabBlacklist.getName(), propertyReplaceSameSlab.getName(), propertyDisableVerticalSlabPlacement.getName(), propertyVerticalSlabCraftingBlacklist.getName()}));
            if (read) {
                this.slabBlacklist = Lists.newArrayList((Object[])propertySlabBlacklist.getStringList());
                this.verticalSlabBlacklist = Lists.newArrayList((Object[])propertyVerticalSlabBlacklist.getStringList());
                this.replaceSameSlab = propertyReplaceSameSlab.getBoolean();
                this.disableVerticalSlabPlacement = propertyDisableVerticalSlabPlacement.getBoolean();
                this.verticalSlabCraftingBlacklist = Lists.newArrayList((Object[])propertyVerticalSlabCraftingBlacklist.getStringList());
            }
            propertySlabBlacklist.set(this.slabBlacklist.toArray(new String[0]));
            propertyVerticalSlabBlacklist.set(this.verticalSlabBlacklist.toArray(new String[0]));
            propertyReplaceSameSlab.set(this.replaceSameSlab);
            propertyDisableVerticalSlabPlacement.set(this.disableVerticalSlabPlacement);
            propertyVerticalSlabCraftingBlacklist.set(this.verticalSlabCraftingBlacklist.toArray(new String[0]));
        }
    }
}

