/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.container;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.PlayerEntityWrapper;
import cjminecraft.doubleslabs.api.ServerPlayerEntityWrapper;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class GuiHandler
implements IGuiHandler {
    public static final int WRAPPER_POSITIVE = 0;
    public static final int WRAPPER_NEGATIVE = 1;

    private static <P extends EntityPlayer> P getPlayerWrapper(P player, World world) {
        return (P)(player instanceof EntityPlayerMP ? new ServerPlayerEntityWrapper((EntityPlayerMP)player, (WorldServer)world) : new PlayerEntityWrapper(player, world));
    }

    @Nullable
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SlabTileEntity) {
            IContainerSupport support;
            IBlockInfo blockInfo;
            boolean positive = ID == 0;
            IBlockInfo iBlockInfo = blockInfo = positive ? ((SlabTileEntity)tileEntity).getPositiveBlockInfo() : ((SlabTileEntity)tileEntity).getNegativeBlockInfo();
            if (blockInfo.getBlockState() != null && (support = ContainerSupport.getSupport(world, tileEntity.func_174877_v(), blockInfo.getBlockState())) != null) {
                return NetworkRegistry.INSTANCE.getRemoteGuiContainer(FMLCommonHandler.instance().findContainerFor(support.getModInstance()), GuiHandler.getPlayerWrapper((EntityPlayerMP)player, blockInfo.getWorld()), support.getId(blockInfo.getWorld(), blockInfo.getPos(), blockInfo.getBlockState(), player, RayTraceUtil.rayTrace(player)), blockInfo.getWorld(), x, y, z);
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SlabTileEntity) {
            IContainerSupport support;
            IBlockInfo blockInfo;
            boolean positive = ID == 0;
            IBlockInfo iBlockInfo = blockInfo = positive ? ((SlabTileEntity)tileEntity).getPositiveBlockInfo() : ((SlabTileEntity)tileEntity).getNegativeBlockInfo();
            if (blockInfo.getBlockState() != null && (support = ContainerSupport.getSupport(world, tileEntity.func_174877_v(), blockInfo.getBlockState())) != null) {
                return NetworkRegistry.INSTANCE.getLocalGuiContainer(FMLCommonHandler.instance().findContainerFor(support.getModInstance()), GuiHandler.getPlayerWrapper(player, blockInfo.getWorld()), support.getId(blockInfo.getWorld(), blockInfo.getPos(), blockInfo.getBlockState(), player, RayTraceUtil.rayTrace(player)), blockInfo.getWorld(), x, y, z);
            }
        }
        return null;
    }
}

