/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.container;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.PlayerEntityWrapper;
import cjminecraft.doubleslabs.api.ServerPlayerEntityWrapper;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class WrappedContainer
extends Container {
    public Container wrapped;
    public final World world;
    private final boolean positive;
    public final EntityPlayer player;
    public final ModContainer mod;
    public final int id;
    public final IBlockInfo blockInfo;

    public WrappedContainer(EntityPlayer player, Object mod, int id, IBlockInfo blockInfo, int x, int y, int z) {
        this.positive = blockInfo.isPositive();
        this.world = blockInfo.getWorld();
        this.blockInfo = blockInfo;
        this.mod = FMLCommonHandler.instance().findContainerFor(mod);
        this.id = id;
        this.player = player instanceof EntityPlayerMP ? new ServerPlayerEntityWrapper((EntityPlayerMP)player, (WorldServer)blockInfo.getWorld()) : new PlayerEntityWrapper(player, blockInfo.getWorld());
        this.wrapped = player instanceof EntityPlayerMP ? NetworkRegistry.INSTANCE.getRemoteGuiContainer(this.mod, (EntityPlayerMP)this.player, id, blockInfo.getWorld(), x, y, z) : null;
    }

    public boolean isPositive() {
        return this.positive;
    }

    private Optional<Container> getContainer() {
        return this.wrapped != null ? Optional.of(this.wrapped) : Optional.empty();
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75132_a(listener);
        } else {
            super.func_75132_a(listener);
        }
    }

    public NonNullList<ItemStack> func_75138_a() {
        return this.getContainer().map(Container::func_75138_a).orElseGet(() -> super.func_75138_a());
    }

    public void func_82847_b(IContainerListener listener) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_82847_b(listener);
        } else {
            super.func_82847_b(listener);
        }
    }

    public void func_75142_b() {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75142_b();
        } else {
            super.func_75142_b();
        }
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        return this.getContainer().map(c -> c.func_75140_a(playerIn, id)).orElseGet(() -> super.func_75140_a(playerIn, id));
    }

    @Nullable
    public Slot func_75147_a(IInventory inv, int slotIn) {
        return this.getContainer().map(c -> c.func_75147_a(inv, slotIn)).orElseGet(() -> super.func_75147_a(inv, slotIn));
    }

    public Slot func_75139_a(int slotId) {
        return this.getContainer().map(c -> c.func_75139_a(slotId)).orElseGet(() -> super.func_75139_a(slotId));
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return this.getContainer().map(c -> c.func_82846_b(playerIn, index)).orElseGet(() -> super.func_82846_b(playerIn, index));
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return this.getContainer().map(c -> c.func_184996_a(slotId, dragType, clickTypeIn, player)).orElseGet(() -> super.func_184996_a(slotId, dragType, clickTypeIn, player));
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.getContainer().map(c -> c.func_94530_a(stack, slotIn)).orElseGet(() -> super.func_94530_a(stack, slotIn));
    }

    public void func_75134_a(EntityPlayer playerIn) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75134_a(playerIn);
        } else {
            super.func_75134_a(playerIn);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75130_a(inventoryIn);
        } else {
            super.func_75130_a(inventoryIn);
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75141_a(slotID, stack);
        } else {
            super.func_75141_a(slotID, stack);
        }
    }

    public void func_190896_a(List<ItemStack> stacks) {
        DoubleSlabs.LOGGER.info(Arrays.toString(stacks.toArray(new ItemStack[0])));
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_190896_a(stacks);
        } else if (stacks.size() < this.field_75151_b.size()) {
            super.func_190896_a(stacks);
        }
    }

    public void func_75137_b(int id, int data) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75137_b(id, data);
        } else {
            super.func_75137_b(id, data);
        }
    }

    public short func_75136_a(InventoryPlayer invPlayer) {
        return this.getContainer().map(c -> c.func_75136_a(invPlayer)).orElseGet(() -> super.func_75136_a(invPlayer));
    }

    public boolean func_75129_b(EntityPlayer player) {
        return this.getContainer().map(c -> c.func_75129_b(player)).orElseGet(() -> super.func_75129_b(player));
    }

    public void func_75128_a(EntityPlayer player, boolean canCraft) {
        if (this.getContainer().isPresent()) {
            this.getContainer().get().func_75128_a(player, canCraft);
        } else {
            super.func_75128_a(player, canCraft);
        }
    }

    public boolean func_94531_b(Slot slotIn) {
        return this.getContainer().map(c -> c.func_94531_b(slotIn)).orElseGet(() -> super.func_94531_b(slotIn));
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.getContainer().map(c -> c.func_75145_c(playerIn)).orElse(true);
    }
}

