/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.init;

import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.network.PacketHandler;
import cjminecraft.doubleslabs.common.network.packet.config.UpdateServerPlayerConfigPacket;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="doubleslabs", value={Side.CLIENT})
public class DSKeyBindings {
    private static final List<Pair<KeyBinding, Runnable>> KEYBINDINGS = new LinkedList<Pair<KeyBinding, Runnable>>();

    public static void register() {
        for (Pair<KeyBinding, Runnable> keybind : KEYBINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)keybind.getKey()));
        }
    }

    private static Pair<KeyBinding, Runnable> makeKeybind(String name, int key, Runnable action) {
        KeyBinding keyBinding = new KeyBinding("doubleslabs.key." + name, key, "doubleslabs.keycategory");
        return Pair.of((Object)keyBinding, (Object)action);
    }

    private static void toggleVerticalSlabPlacement() {
        IPlayerConfig config = (IPlayerConfig)Minecraft.func_71410_x().field_71439_g.getCapability(PlayerConfigCapability.PLAYER_CONFIG, null);
        if (config == null) {
            return;
        }
        config.setPlaceVerticalSlabs(!config.placeVerticalSlabs());
        PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerPlayerConfigPacket(config));
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Pair<KeyBinding, Runnable> keybind : KEYBINDINGS) {
            if (!((KeyBinding)keybind.getKey()).func_151468_f()) continue;
            ((Runnable)keybind.getValue()).run();
        }
    }

    static {
        KEYBINDINGS.add(DSKeyBindings.makeKeybind("toggleVerticalSlabPlacement", 58, DSKeyBindings::toggleVerticalSlabPlacement));
    }
}

