/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.items;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.placement.PlacementHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VerticalSlabItem
extends ItemBlock {
    public VerticalSlabItem() {
        super((Block)DSBlocks.VERTICAL_SLAB);
        this.func_77637_a(DoubleSlabs.TAB);
    }

    public static ItemStack setStack(ItemStack stack, ItemStack toSet) {
        ItemStack copy = toSet.func_77946_l();
        copy.func_190920_e(1);
        stack.func_77983_a("item", (NBTBase)copy.func_77955_b(new NBTTagCompound()));
        return stack;
    }

    public static ItemStack getStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_190925_c("item");
        return new ItemStack(nbt);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == DoubleSlabs.TAB || tab == CreativeTabs.field_78027_g) {
            ForgeRegistries.ITEMS.forEach(item -> {
                if (item != null && SlabSupport.isHorizontalSlab(item)) {
                    NonNullList list = NonNullList.func_191196_a();
                    if (item.func_77614_k()) {
                        item.func_150895_a(CreativeTabs.field_78027_g, list);
                    } else {
                        list.add((Object)item.func_190903_i());
                    }
                    list.forEach(itemStack -> {
                        ItemStack stack = new ItemStack((Item)this);
                        items.add((Object)VerticalSlabItem.setStack(stack, itemStack));
                    });
                }
            });
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean result = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        VerticalSlabBlock.getTile((IBlockAccess)world, pos).ifPresent(tile -> {
            ItemStack slabStack = VerticalSlabItem.getStack(stack);
            IHorizontalSlabSupport support = SlabSupport.getHorizontalSlabSupport(slabStack, player, EnumHand.MAIN_HAND);
            if (support != null) {
                boolean positive = tile.getPositiveBlockInfo().getBlockState() == null;
                IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, EnumHand.MAIN_HAND, slabStack, positive ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP, support);
                if (positive) {
                    tile.getPositiveBlockInfo().setBlockState(slabState);
                } else {
                    tile.getNegativeBlockInfo().setBlockState(slabState);
                }
            }
        });
        return result;
    }

    public String func_77667_c(ItemStack stack) {
        return VerticalSlabItem.getStack(stack).func_77977_a();
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)"item.vertical_slab.prefix", (Object[])new Object[]{VerticalSlabItem.getStack(stack).func_82833_r()});
    }
}

