/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.placement;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.patches.DynamicSurroundings;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class PlacementHandler {
    private static boolean canPlace(World world, BlockPos pos, EnumFacing face, EntityPlayer player, EnumHand hand, ItemStack stack, float hitX, float hitY, float hitZ, Consumer<Boolean> cancelEventConsumer, boolean activateBlock) {
        boolean flag1;
        if (!player.func_175151_a(pos, face, stack)) {
            return false;
        }
        if (MathHelper.func_76128_c((double)player.field_70165_t) == pos.func_177958_n() && MathHelper.func_76128_c((double)player.field_70163_u) == pos.func_177956_o() && MathHelper.func_76128_c((double)player.field_70161_v) == pos.func_177952_p()) {
            return false;
        }
        if (!activateBlock) {
            return true;
        }
        boolean flag = !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
        boolean bl = flag1 = !player.func_70093_af() || !flag || player.func_184614_ca().doesSneakBypassUse((IBlockAccess)world, pos, player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)world, pos, player);
        if (flag1) {
            boolean result = world.func_180495_p(pos).func_177230_c().func_180639_a(world, pos, world.func_180495_p(pos), player, hand, face, hitX, hitY, hitZ);
            if (result) {
                cancelEventConsumer.accept(result);
            }
            return !result;
        }
        return true;
    }

    private static boolean activateBlock(World world, BlockPos pos, EntityPlayer player, EnumHand hand, Consumer<Boolean> cancelEventConsumer) {
        boolean flag1;
        boolean flag = !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
        boolean bl = flag1 = !player.func_70093_af() || !flag || player.func_184614_ca().doesSneakBypassUse((IBlockAccess)world, pos, player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)world, pos, player);
        if (flag1) {
            RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
            boolean result = world.func_180495_p(pos).func_177230_c().func_180639_a(world, pos, world.func_180495_p(pos), player, hand, rayTraceResult.field_178784_b, (float)rayTraceResult.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)rayTraceResult.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)rayTraceResult.field_72307_f.field_72449_c - (float)pos.func_177952_p());
            if (result) {
                cancelEventConsumer.accept(result);
            }
            return result;
        }
        return false;
    }

    public static IBlockState getStateFromSupport(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack stack, BlockSlab.EnumBlockHalf half, IHorizontalSlabSupport support) {
        return support.getStateForHalf(world, pos, support.getStateFromStack(stack, world, pos, player, hand, RayTraceUtil.rayTrace(player)), half);
    }

    public static IBlockState getStateFromSupport(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing direction, IVerticalSlabSupport support) {
        return support.getStateForDirection(world, pos, support.getStateFromStack(stack, world, pos, player, hand, RayTraceUtil.rayTrace(player)), direction);
    }

    private static void finishBlockPlacement(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack stack, Consumer<Boolean> cancel) {
        SoundType soundType = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        cancel.accept(true);
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
        }
    }

    private static boolean placeSlab(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, Consumer<SlabTileEntity> setStates) {
        DynamicSurroundings.patchBlockState(state);
        if (world.func_180501_a(pos, state, 11)) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SlabTileEntity) {
                SlabTileEntity tile = (SlabTileEntity)tileEntity;
                setStates.accept(tile);
            }
            return true;
        }
        return false;
    }

    private static boolean placeSlab(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, IBlockState negativeState, IBlockState positiveState) {
        return PlacementHandler.placeSlab(world, pos, state, player, side, tile -> {
            tile.getNegativeBlockInfo().setBlockState(negativeState);
            tile.getPositiveBlockInfo().setBlockState(positiveState);
        });
    }

    private static boolean shouldPlaceVerticalSlab(EntityPlayer player, EnumFacing face) {
        if (DSConfig.SERVER.disableVerticalSlabPlacement) {
            return false;
        }
        IPlayerConfig config = (IPlayerConfig)player.getCapability(PlayerConfigCapability.PLAYER_CONFIG, null);
        if (config == null) {
            config = new PlayerConfig();
        }
        return config.getVerticalSlabPlacementMethod().shouldPlace(player, face, config.placeVerticalSlabs());
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b()) {
            ItemStack stack = event.getItemStack();
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = event.getHand();
            EnumFacing face = event.getFace();
            BlockPos pos = event.getPos();
            if (stack.func_77973_b() == DSItems.VERTICAL_SLAB) {
                stack = VerticalSlabItem.getStack(stack);
            }
            IHorizontalSlabSupport horizontalSlabItemSupport = SlabSupport.getHorizontalSlabSupport(stack, player, hand);
            Consumer<Boolean> cancel = resultType -> {
                event.setCanceled(true);
                event.setCancellationResult(resultType != false ? EnumActionResult.SUCCESS : EnumActionResult.PASS);
            };
            IBlockState state = world.func_180495_p(pos);
            RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
            if (horizontalSlabItemSupport == null) {
                TileEntity tileEntity;
                IVerticalSlabSupport verticalSlabItemSupport = SlabSupport.getVerticalSlabSupport(stack, player, hand);
                if (verticalSlabItemSupport == null) {
                    return;
                }
                boolean offset = false;
                if (state.func_177230_c() != DSBlocks.VERTICAL_SLAB && world.func_180495_p(pos.func_177972_a(face)).func_177230_c() == DSBlocks.VERTICAL_SLAB) {
                    pos = pos.func_177972_a(face);
                    state = world.func_180495_p(pos);
                    tileEntity = world.func_175625_s(pos);
                    offset = true;
                    if (tileEntity instanceof SlabTileEntity) {
                        EnumFacing enumFacing = face = ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? ((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                    }
                }
                if (state.func_177230_c() == DSBlocks.VERTICAL_SLAB) {
                    if (!(((Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue() || face != ((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() || !((tileEntity = world.func_175625_s(pos)) instanceof SlabTileEntity) || player.func_70093_af() || face == state.func_177229_b((IProperty)VerticalSlabBlock.FACING) && ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null)) {
                        IBlockState newState = state.func_177226_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? face.func_176734_d() : face, verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState)) {
                            return;
                        }
                        if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState, player, face, tile -> {
                            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                                tile.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                tile.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                        }
                    }
                } else {
                    IVerticalSlabSupport blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)world, pos, state);
                    if (blockSupport == null) {
                        offset = true;
                        blockSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)world, pos = pos.func_177972_a(face), state = world.func_180495_p(pos));
                        if (blockSupport == null) {
                            return;
                        }
                        face = blockSupport.getDirection(event.getWorld(), pos, state);
                    }
                    if (DSConfig.SERVER.isBlacklistedVerticalSlab(state)) {
                        return;
                    }
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    EnumFacing direction = blockSupport.getDirection(event.getWorld(), pos, state);
                    if (face == direction) {
                        IBlockState finalState;
                        IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, direction.func_176734_d(), verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState)) {
                            return;
                        }
                        IBlockState newState = DSBlocks.VERTICAL_SLAB.func_176223_P().func_177226_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction).func_177226_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        if (PlacementHandler.placeSlab(world, pos, newState, player, face, arg_0 -> PlacementHandler.lambda$onItemUse$3(slabState, finalState = state, arg_0))) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                        }
                    }
                }
            } else {
                IBlockState newState;
                IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)world, pos, state);
                boolean verticalSlab = state.func_177230_c() == DSBlocks.VERTICAL_SLAB && (Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE) == false && (((SlabTileEntity)world.func_175625_s(pos)).getPositiveBlockInfo().getBlockState() != null ? face == ((EnumFacing)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() : face == state.func_177229_b((IProperty)VerticalSlabBlock.FACING));
                boolean offset = false;
                if (horizontalSlabSupport == null && !verticalSlab) {
                    IVerticalSlabSupport verticalSlabSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)world, pos, state);
                    if (verticalSlabSupport != null) {
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(state)) {
                            return;
                        }
                        EnumFacing direction = verticalSlabSupport.getDirection(world, pos, state);
                        if (face == direction) {
                            if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                return;
                            }
                            IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, BlockSlab.EnumBlockHalf.BOTTOM, horizontalSlabItemSupport);
                            IBlockState newState2 = DSBlocks.VERTICAL_SLAB.getStateForPlacement(world, pos, face, (float)rayTraceResult.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)rayTraceResult.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)rayTraceResult.field_72307_f.field_72449_c - (float)pos.func_177952_p(), 0, (EntityLivingBase)player, hand).func_177226_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, pos, newState2, player, face, state, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                            }
                            return;
                        }
                    }
                    BlockPos newPos = pos.func_177972_a(face);
                    newState = world.func_180495_p(newPos);
                    offset = true;
                    verticalSlab = newState.func_177230_c() == DSBlocks.VERTICAL_SLAB && (Boolean)newState.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE) == false;
                    horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockAccess)world, newPos, newState);
                    if (horizontalSlabSupport == null && !verticalSlab) {
                        verticalSlabSupport = SlabSupport.getVerticalSlabSupport((IBlockAccess)world, newPos, newState);
                        if (verticalSlabSupport != null) {
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab(newState)) {
                                return;
                            }
                            EnumFacing direction = verticalSlabSupport.getDirection(world, newPos, newState);
                            IBlockState slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, BlockSlab.EnumBlockHalf.BOTTOM, horizontalSlabItemSupport);
                            IBlockState verticalSlabState = DSBlocks.VERTICAL_SLAB.getStateForPlacement(world, pos, face, (float)rayTraceResult.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)rayTraceResult.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)rayTraceResult.field_72307_f.field_72449_c - (float)pos.func_177952_p(), 0, (EntityLivingBase)player, hand).func_177226_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, player, face, newState, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                            }
                        } else if (PlacementHandler.shouldPlaceVerticalSlab(player, face) && event.getItemStack().func_77973_b() != DSItems.VERTICAL_SLAB) {
                            IBlockState slabState;
                            if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                                newState = state;
                                newPos = pos;
                                if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                    return;
                                }
                            } else if (!newState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                                return;
                            }
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, BlockSlab.EnumBlockHalf.BOTTOM, horizontalSlabItemSupport))) {
                                return;
                            }
                            if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                return;
                            }
                            IBlockState verticalSlabState = DSBlocks.VERTICAL_SLAB.getStateForPlacement(world, newPos, face, (float)rayTraceResult.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)rayTraceResult.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)rayTraceResult.field_72307_f.field_72449_c - (float)pos.func_177952_p(), 0, (EntityLivingBase)player, hand);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, player, face, tile -> tile.getPositiveBlockInfo().setBlockState(slabState))) {
                                PlacementHandler.finishBlockPlacement(world, newPos, slabState, player, stack, cancel);
                            }
                        }
                        return;
                    }
                    state = newState;
                    pos = newPos;
                    if (horizontalSlabSupport != null) {
                        EnumFacing enumFacing = face = horizontalSlabSupport.getHalf(world, pos, newState) == BlockSlab.EnumBlockHalf.BOTTOM ? EnumFacing.UP : EnumFacing.DOWN;
                    }
                }
                if (verticalSlab) {
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof SlabTileEntity && !player.func_70093_af() && (face != state.func_177229_b((IProperty)VerticalSlabBlock.FACING) || ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() == null)) {
                        SlabTileEntity tile2 = (SlabTileEntity)tileEntity;
                        IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, tile2.getPositiveBlockInfo().getBlockState() != null ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM, horizontalSlabItemSupport);
                        IBlockState newState3 = state.func_177226_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState)) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState3, player, face, t -> {
                            if (t.getPositiveBlockInfo().getBlockState() != null) {
                                t.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                t.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                        }
                        return;
                    }
                }
                if (horizontalSlabSupport == null) {
                    return;
                }
                if (DSConfig.SERVER.isBlacklistedHorizontalSlab(state)) {
                    return;
                }
                BlockSlab.EnumBlockHalf half = horizontalSlabSupport.getHalf(world, pos, state);
                if (half == null) {
                    return;
                }
                if (!DSConfig.SERVER.replaceSameSlab && horizontalSlabItemSupport.equals(horizontalSlabSupport) && horizontalSlabSupport.areSame(world, pos, state, stack)) {
                    return;
                }
                if (face == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || face == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) {
                    TileEntity tileEntity;
                    IBlockState finalState1;
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    IBlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, half == BlockSlab.EnumBlockHalf.BOTTOM ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM, horizontalSlabItemSupport);
                    if (DSConfig.SERVER.isBlacklistedHorizontalSlab(slabState)) {
                        return;
                    }
                    newState = DSBlocks.DOUBLE_SLAB.getStateForPlacement(world, pos, face, (float)rayTraceResult.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)rayTraceResult.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)rayTraceResult.field_72307_f.field_72449_c - (float)pos.func_177952_p(), 0, (EntityLivingBase)player, hand);
                    if (PlacementHandler.placeSlab(world, pos, newState, player, face, arg_0 -> PlacementHandler.lambda$onItemUse$6(half, finalState1 = state, tileEntity = world.func_175625_s(pos), slabState, arg_0))) {
                        PlacementHandler.finishBlockPlacement(world, pos, slabState, player, stack, cancel);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onItemUse$6(BlockSlab.EnumBlockHalf half, IBlockState finalState1, TileEntity tileEntity, IBlockState slabState, SlabTileEntity tile) {
        if (half == BlockSlab.EnumBlockHalf.BOTTOM) {
            tile.getNegativeBlockInfo().setBlockState(finalState1);
            tile.getNegativeBlockInfo().setTileEntity(tileEntity);
            tile.getPositiveBlockInfo().setBlockState(slabState);
        } else {
            tile.getNegativeBlockInfo().setBlockState(slabState);
            tile.getPositiveBlockInfo().setBlockState(finalState1);
            tile.getPositiveBlockInfo().setTileEntity(tileEntity);
        }
    }

    private static /* synthetic */ void lambda$onItemUse$3(IBlockState slabState, IBlockState finalState, SlabTileEntity tile) {
        tile.getPositiveBlockInfo().setBlockState(slabState);
        tile.getNegativeBlockInfo().setBlockState(finalState);
    }
}

