/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.tileentity;

import cjminecraft.doubleslabs.api.BlockInfo;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IStateContainer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class SlabTileEntity
extends TileEntity
implements IStateContainer,
ITickable {
    protected final BlockInfo negativeBlockInfo = new BlockInfo(this, false);
    protected final BlockInfo positiveBlockInfo = new BlockInfo(this, true);

    public void func_145839_a(NBTTagCompound nbt) {
        this.negativeBlockInfo.deserializeNBT(nbt.func_74775_l("negativeBlock"));
        this.positiveBlockInfo.deserializeNBT(nbt.func_74775_l("positiveBlock"));
        super.func_145839_a(nbt);
        this.markDirtyClient();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("negativeBlock", (NBTBase)this.negativeBlockInfo.serializeNBT());
        nbt.func_74782_a("positiveBlock", (NBTBase)this.positiveBlockInfo.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.func_145839_a(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound getTileData() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected void markDirtyFast() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175664_x(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.positiveBlockInfo.setWorld(worldIn);
        this.negativeBlockInfo.setWorld(worldIn);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.positiveBlockInfo.setPos(posIn);
        this.negativeBlockInfo.setPos(posIn);
    }

    @Override
    public IBlockInfo getPositiveBlockInfo() {
        return this.positiveBlockInfo;
    }

    @Override
    public IBlockInfo getNegativeBlockInfo() {
        return this.negativeBlockInfo;
    }

    public void onLoad() {
        this.negativeBlockInfo.onLoad();
        this.positiveBlockInfo.onLoad();
    }

    public void onChunkUnload() {
        this.negativeBlockInfo.onChunkUnloaded();
        this.positiveBlockInfo.onChunkUnloaded();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.negativeBlockInfo.remove();
        this.positiveBlockInfo.remove();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.negativeBlockInfo.validate();
        this.positiveBlockInfo.validate();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.negativeBlockInfo.updateContainingBlockInfo();
        this.positiveBlockInfo.updateContainingBlockInfo();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.negativeBlockInfo.hasCapability(capability, facing) || this.positiveBlockInfo.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.positiveBlockInfo.hasCapability(capability, facing)) {
            return this.positiveBlockInfo.getCapability(capability, facing);
        }
        return this.negativeBlockInfo.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            if (this.positiveBlockInfo.getTileEntity() != null && this.positiveBlockInfo.getTileEntity() instanceof ITickable) {
                if (this.positiveBlockInfo.getTileEntity().func_145831_w() == null) {
                    this.positiveBlockInfo.getTileEntity().func_145834_a(this.positiveBlockInfo.getWorld());
                }
                ((ITickable)this.positiveBlockInfo.getTileEntity()).func_73660_a();
            }
            if (this.negativeBlockInfo.getTileEntity() != null && this.negativeBlockInfo.getTileEntity() instanceof ITickable) {
                if (this.negativeBlockInfo.getTileEntity().func_145831_w() == null) {
                    this.negativeBlockInfo.getTileEntity().func_145834_a(this.negativeBlockInfo.getWorld());
                }
                ((ITickable)this.negativeBlockInfo.getTileEntity()).func_73660_a();
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

