/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class AnnotationUtil {
    private static ASMDataTable dataTable;
    public static final Predicate<Map<String, Object>> MODID_PREDICATE;

    public static void prepare(ASMDataTable table) {
        dataTable = table;
    }

    public static <T> List<T> getClassInstances(Class<?> annotation, Class<T> instance) {
        return AnnotationUtil.getClassInstances(annotation, instance, data -> true);
    }

    public static <T> List<T> getClassInstances(Class<?> annotation, Class<T> instance, Predicate<Map<String, Object>> filter) {
        return dataTable.getAll(annotation.getName()).stream().filter(data -> filter.test(data.getAnnotationInfo())).map(data -> {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (!instance.isAssignableFrom(clazz)) {
                    return null;
                }
                Class instanceClass = clazz.asSubclass(instance);
                return instanceClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static {
        MODID_PREDICATE = data -> {
            String modid = data.getOrDefault("modid", "");
            return modid.length() == 0 || Loader.isModLoaded((String)modid);
        };
    }
}

