/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class WorldWrapper
extends World
implements IWorldWrapper<World> {
    private World world;
    private boolean positive;
    private BlockPos pos;
    private IStateContainer container;

    public WorldWrapper(World world) {
        super(world.func_72912_H(), world.field_73011_w.func_186058_p(), (world1, dimension) -> world.func_72863_F(), world.func_217381_Z(), world.field_72995_K);
        this.world = world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public void setPositive(boolean positive) {
        this.positive = positive;
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public IStateContainer getStateContainer() {
        return this.container;
    }

    @Override
    public void setStateContainer(IStateContainer container) {
        this.container = container;
    }

    public BlockState func_180495_p(BlockPos pos) {
        return pos.equals((Object)this.pos) ? (this.positive ? this.container.getPositiveBlockInfo().getBlockState() : this.container.getNegativeBlockInfo().getBlockState()) : super.func_180495_p(pos);
    }

    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.world.func_184148_a(player, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_217384_a(@Nullable PlayerEntity playerIn, Entity entityIn, SoundEvent eventIn, SoundCategory categoryIn, float volume, float pitch) {
        this.world.func_217384_a(playerIn, entityIn, eventIn, categoryIn, volume, pitch);
    }

    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.world.func_184138_a(pos, oldState, newState, flags);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return pos.equals((Object)this.pos) ? (this.positive ? this.container.getPositiveBlockInfo().getTileEntity() : this.container.getNegativeBlockInfo().getTileEntity()) : super.func_175625_s(pos);
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(tileEntityIn);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(tileEntityIn);
            }
        } else {
            super.func_175690_a(pos, tileEntityIn);
        }
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return this.world.func_73045_a(id);
    }

    @Nullable
    public MapData func_217406_a(String mapName) {
        return this.world.func_217406_a(mapName);
    }

    public void func_217399_a(MapData mapDataIn) {
        this.world.func_217399_a(mapDataIn);
    }

    public int func_217395_y() {
        return this.world.func_217395_y();
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        this.world.func_175715_c(breakerId, pos, progress);
    }

    public Scoreboard func_96441_U() {
        return this.world.func_96441_U();
    }

    public RecipeManager func_199532_z() {
        return this.world.func_199532_z();
    }

    public NetworkTagManager func_205772_D() {
        return this.world.func_205772_D();
    }

    public ITickList<Block> func_205220_G_() {
        return this.world.func_205220_G_();
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.world.func_205219_F_();
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
        this.world.func_217378_a(player, type, pos, data);
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return this.world.func_217369_A();
    }

    public boolean func_201670_d() {
        return this.world.func_201670_d();
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return this.world.func_73046_m();
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.world.func_175726_f(pos);
    }

    public Chunk func_212866_a_(int chunkX, int chunkZ) {
        return this.world.func_212866_a_(chunkX, chunkZ);
    }

    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return this.world.func_217353_a(x, z, requiredStatus, nonnull);
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable Chunk chunk, BlockState blockstate, BlockState newState, int flags) {
        this.world.markAndNotifyBlock(pos, chunk, blockstate, newState, flags);
    }

    public void func_217393_a(BlockPos pos, BlockState blockStateIn, BlockState newState) {
        this.world.func_217393_a(pos, blockStateIn, newState);
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        return this.world.func_217377_a(pos, isMoving);
    }

    public boolean func_175656_a(BlockPos pos, BlockState state) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(state);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(state);
            }
            return true;
        }
        return this.world.func_175656_a(pos, state);
    }

    public void func_195593_d(BlockPos pos, Block blockIn) {
        this.world.func_195593_d(pos, blockIn);
    }

    public void func_175695_a(BlockPos pos, Block blockType, Direction skipSide) {
        this.world.func_175695_a(pos, blockType, skipSide);
    }

    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.world.func_190524_a(pos, blockIn, fromPos);
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.world.func_201676_a(heightmapType, x, z);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        return this.world.func_204610_c(pos);
    }

    public boolean func_72935_r() {
        return this.world.func_72935_r();
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.world.func_184133_a(player, pos, soundIn, category, volume, pitch);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.world.func_184134_a(x, y, z, soundIn, category, volume, pitch, distanceDelay);
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.world.func_195594_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.world.func_195590_a(particleData, forceAlwaysRender, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.world.func_195589_b(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_217404_b(IParticleData particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.world.func_217404_b(particleData, ignoreRange, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public float func_72929_e(float partialTicks) {
        return this.world.func_72929_e(partialTicks);
    }

    public boolean func_175700_a(TileEntity tile) {
        return this.world.func_175700_a(tile);
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        this.world.func_147448_a(tileEntityCollection);
    }

    public void func_217391_K() {
        this.world.func_217391_K();
    }

    public void func_217390_a(Consumer<Entity> consumerEntity, Entity entityIn) {
        this.world.func_217390_a(consumerEntity, entityIn);
    }

    public Explosion func_217385_a(@Nullable Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, Explosion.Mode modeIn) {
        return this.world.func_217385_a(entityIn, xIn, yIn, zIn, explosionRadius, modeIn);
    }

    public Explosion func_217398_a(@Nullable Entity entityIn, double xIn, double yIn, double zIn, float explosionRadius, boolean causesFire, Explosion.Mode modeIn) {
        return this.world.func_217398_a(entityIn, xIn, yIn, zIn, explosionRadius, causesFire, modeIn);
    }

    public String func_72827_u() {
        return this.world.func_72827_u();
    }

    public void func_175713_t(BlockPos pos) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setTileEntity(null);
            } else {
                this.container.getNegativeBlockInfo().setTileEntity(null);
            }
        } else {
            this.world.func_175713_t(pos);
        }
    }

    public boolean func_195588_v(BlockPos pos) {
        return this.world.func_195588_v(pos);
    }

    public boolean func_217400_a(BlockPos pos, Entity entityIn) {
        return this.world.func_217400_a(pos, entityIn);
    }

    public void func_72966_v() {
        this.world.func_72966_v();
    }

    public void func_72891_a(boolean hostile, boolean peaceful) {
        this.world.func_72891_a(hostile, peaceful);
    }

    public void close() throws IOException {
        super.close();
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return this.world.func_175674_a(entityIn, boundingBox, predicate);
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return this.world.func_175647_a(clazz, aabb, filter);
    }

    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        this.world.func_175646_b(pos, unusedTileEntity);
    }

    public int func_181545_F() {
        return this.world.func_181545_F();
    }

    public int func_175676_y(BlockPos pos) {
        return this.world.func_175676_y(pos);
    }

    public boolean func_175709_b(BlockPos pos, Direction side) {
        return this.world.func_175709_b(pos, side);
    }

    public int func_175651_c(BlockPos pos, Direction facing) {
        return this.world.func_175651_c(pos, facing);
    }

    public boolean func_175640_z(BlockPos pos) {
        return this.world.func_175640_z(pos);
    }

    public int func_175687_A(BlockPos pos) {
        return this.world.func_175687_A(pos);
    }

    public void func_72882_A() {
        this.world.func_72882_A();
    }

    public long func_82737_E() {
        return this.world.func_82737_E();
    }

    public long func_72820_D() {
        return this.world.func_72820_D();
    }

    public boolean func_175660_a(PlayerEntity player, BlockPos pos) {
        return this.world.func_175660_a(player, pos);
    }

    public void func_72960_a(Entity entityIn, byte state) {
        this.world.func_72960_a(entityIn, state);
    }

    public AbstractChunkProvider func_72863_F() {
        return this.world.func_72863_F();
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.world.func_175641_c(pos, blockIn, eventID, eventParam);
    }

    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.world.func_82736_K();
    }

    public float func_72819_i(float delta) {
        return this.world.func_72819_i(delta);
    }

    public void func_147442_i(float strength) {
        this.world.func_147442_i(strength);
    }

    public float func_72867_j(float delta) {
        return this.world.func_72867_j(delta);
    }

    public void func_72894_k(float strength) {
        this.world.func_72894_k(strength);
    }

    public boolean func_72911_I() {
        return this.world.func_72911_I();
    }

    public boolean func_72896_J() {
        return this.world.func_72896_J();
    }

    public boolean func_175727_C(BlockPos position) {
        return this.world.func_175727_C(position);
    }

    public boolean func_180502_D(BlockPos pos) {
        return this.world.func_180502_D(pos);
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        this.world.func_175669_a(id, pos, data);
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        return this.world.func_72914_a(report);
    }

    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable CompoundNBT compound) {
        this.world.func_92088_a(x, y, z, motionX, motionY, motionZ, compound);
    }

    public void func_175666_e(BlockPos pos, Block blockIn) {
        this.world.func_175666_e(pos, blockIn);
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.world.func_175649_E(pos);
    }

    public int func_175657_ab() {
        return this.world.func_175657_ab();
    }

    public WorldBorder func_175723_af() {
        return this.world.func_175723_af();
    }

    public void func_184135_a(IPacket<?> packetIn) {
        this.world.func_184135_a(packetIn);
    }

    public Random func_201674_k() {
        return this.world.func_201674_k();
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return this.world.func_217375_a(p_217375_1_, p_217375_2_);
    }

    public BlockPos func_217383_a(int p_217383_1_, int p_217383_2_, int p_217383_3_, int p_217383_4_) {
        return this.world.func_217383_a(p_217383_1_, p_217383_2_, p_217383_3_, p_217383_4_);
    }

    public boolean func_217402_u() {
        return this.world.func_217402_u();
    }

    public IProfiler func_217381_Z() {
        return this.world.func_217381_Z();
    }

    public double getMaxEntityRadius() {
        return this.world.getMaxEntityRadius();
    }

    public double increaseMaxEntityRadius(double value) {
        return this.world.increaseMaxEntityRadius(value);
    }

    public Difficulty func_175659_aa() {
        return this.world.func_175659_aa();
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return this.world.func_217354_b(chunkX, chunkZ);
    }

    public void func_217379_c(int type, BlockPos pos, int data) {
        this.world.func_217379_c(type, pos, data);
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        return this.world.func_195585_a(entityIn, shape);
    }

    public BlockPos func_205770_a(Heightmap.Type heightmapType, BlockPos pos) {
        return this.func_205770_a(heightmapType, pos);
    }

    public boolean func_217346_i(Entity p_226668_1_) {
        return this.world.func_217346_i(p_226668_1_);
    }

    public Stream<VoxelShape> func_223438_b(@Nullable Entity p_226666_1_, AxisAlignedBB p_226666_2_) {
        return this.world.func_223438_b(p_226666_1_, p_226666_2_);
    }

    public int func_217298_h(BlockPos pos) {
        return this.world.func_217298_h(pos);
    }

    public int func_201572_C() {
        return this.world.func_201572_C();
    }

    public int func_217301_I() {
        return this.world.func_217301_I();
    }

    public BlockRayTraceResult func_217299_a(RayTraceContext context) {
        return this.world.func_217299_a(context);
    }

    @Nullable
    public BlockRayTraceResult func_217296_a(Vec3d startVec, Vec3d endVec, BlockPos pos, VoxelShape shape, BlockState state) {
        return this.world.func_217296_a(startVec, endVec, pos, shape, state);
    }

    public List<Entity> func_72839_b(@Nullable Entity entityIn, AxisAlignedBB bb) {
        return this.world.func_72839_b(entityIn, bb);
    }

    public <T extends Entity> List<T> func_217357_a(Class<? extends T> p_217357_1_, AxisAlignedBB p_217357_2_) {
        return this.world.func_217357_a(p_217357_1_, p_217357_2_);
    }

    @Nullable
    public PlayerEntity func_190525_a(double x, double y, double z, double distance, @Nullable Predicate<Entity> predicate) {
        return this.world.func_190525_a(x, y, z, distance, predicate);
    }

    @Nullable
    public PlayerEntity func_217362_a(Entity entityIn, double distance) {
        return this.world.func_217362_a(entityIn, distance);
    }

    @Nullable
    public PlayerEntity func_217366_a(double x, double y, double z, double distance, boolean creativePlayers) {
        return this.world.func_217366_a(x, y, z, distance, creativePlayers);
    }

    public boolean func_217358_a(double x, double y, double z, double distance) {
        return this.world.func_217358_a(x, y, z, distance);
    }

    @Nullable
    public PlayerEntity func_217370_a(EntityPredicate predicate, LivingEntity target) {
        return this.world.func_217370_a(predicate, target);
    }

    @Nullable
    public PlayerEntity func_217372_a(EntityPredicate predicate, LivingEntity target, double p_217372_3_, double p_217372_5_, double p_217372_7_) {
        return this.world.func_217372_a(predicate, target, p_217372_3_, p_217372_5_, p_217372_7_);
    }

    @Nullable
    public PlayerEntity func_217359_a(EntityPredicate predicate, double x, double y, double z) {
        return this.world.func_217359_a(predicate, x, y, z);
    }

    @Nullable
    public <T extends LivingEntity> T func_217360_a(Class<? extends T> entityClazz, EntityPredicate p_217360_2_, @Nullable LivingEntity target, double x, double y, double z, AxisAlignedBB boundingBox) {
        return (T)this.world.func_217360_a(entityClazz, p_217360_2_, target, x, y, z, boundingBox);
    }

    @Nullable
    public <T extends LivingEntity> T func_225318_b(Class<? extends T> p_225318_1_, EntityPredicate p_225318_2_, @Nullable LivingEntity p_225318_3_, double p_225318_4_, double p_225318_6_, double p_225318_8_, AxisAlignedBB p_225318_10_) {
        return (T)this.world.func_225318_b(p_225318_1_, p_225318_2_, p_225318_3_, p_225318_4_, p_225318_6_, p_225318_8_, p_225318_10_);
    }

    @Nullable
    public <T extends LivingEntity> T func_217361_a(List<? extends T> entities, EntityPredicate predicate, @Nullable LivingEntity target, double x, double y, double z) {
        return (T)this.world.func_217361_a(entities, predicate, target, x, y, z);
    }

    public List<PlayerEntity> func_217373_a(EntityPredicate predicate, LivingEntity target, AxisAlignedBB box) {
        return this.world.func_217373_a(predicate, target, box);
    }

    public <T extends LivingEntity> List<T> func_217374_a(Class<? extends T> p_217374_1_, EntityPredicate p_217374_2_, LivingEntity p_217374_3_, AxisAlignedBB p_217374_4_) {
        return this.world.func_217374_a(p_217374_1_, p_217374_2_, p_217374_3_, p_217374_4_);
    }

    @Nullable
    public PlayerEntity func_217371_b(UUID uniqueIdIn) {
        return this.world.func_217371_b(uniqueIdIn);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.world.func_180494_b(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.world.func_175623_d(pos);
    }

    public float func_205052_D(BlockPos pos) {
        return this.world.func_205052_D(pos);
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return this.world.func_175627_a(pos, direction);
    }

    public IChunk func_217349_x(BlockPos pos) {
        return this.world.func_217349_x(pos);
    }

    public IChunk func_217348_a(int chunkX, int chunkZ, ChunkStatus requiredStatus) {
        return this.world.func_217348_a(chunkX, chunkZ, requiredStatus);
    }

    public boolean func_201671_F(BlockPos pos) {
        return this.world.func_201671_F(pos);
    }

    public boolean func_72953_d(AxisAlignedBB bb) {
        return this.world.func_72953_d(bb);
    }

    public int func_201696_r(BlockPos pos) {
        return this.world.func_201696_r(pos);
    }

    public int func_205049_d(BlockPos pos, int amount) {
        return this.world.func_205049_d(pos, amount);
    }

    public boolean func_175667_e(BlockPos pos) {
        return this.world.func_175667_e(pos);
    }

    public boolean isAreaLoaded(BlockPos center, int range) {
        return this.world.isAreaLoaded(center, range);
    }

    public boolean func_175707_a(BlockPos from, BlockPos to) {
        return this.world.func_175707_a(from, to);
    }

    public boolean func_217344_a(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return this.world.func_217344_a(fromX, fromY, fromZ, toX, toY, toZ);
    }

    public int func_175642_b(LightType lightTypeIn, BlockPos blockPosIn) {
        return this.world.func_175642_b(lightTypeIn, blockPosIn);
    }

    public int func_201669_a(BlockPos blockPosIn, int amount) {
        return this.world.func_201669_a(blockPosIn, amount);
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        return this.world.func_175655_b(pos, dropBlock);
    }

    public boolean func_217376_c(Entity entityIn) {
        return this.world.func_217376_c(entityIn);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.world.getCapability(cap, side);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return this.world.getCapability(cap);
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (pos.equals((Object)this.pos)) {
            if (this.positive) {
                this.container.getPositiveBlockInfo().setBlockState(newState);
            } else {
                this.container.getNegativeBlockInfo().setBlockState(newState);
            }
            return true;
        }
        return super.func_180501_a(pos, newState, flags);
    }

    protected void func_72947_a() {
        super.func_72947_a();
    }

    public void func_72974_f() {
        this.world.func_72974_f();
    }

    public BlockState func_184141_c(BlockPos pos) {
        return this.world.func_184141_c(pos);
    }

    public void func_195592_c(BlockPos pos, Block blockIn) {
        this.world.func_195592_c(pos, blockIn);
    }

    public boolean func_72829_c(AxisAlignedBB bb) {
        return this.world.func_72829_c(bb);
    }

    public boolean func_147470_e(AxisAlignedBB bb) {
        return this.world.func_147470_e(bb);
    }

    @Nullable
    public BlockState func_203067_a(AxisAlignedBB area, Block blockIn) {
        return this.world.func_203067_a(area, blockIn);
    }

    public boolean func_72875_a(AxisAlignedBB bb, Material materialIn) {
        return this.world.func_72875_a(bb, materialIn);
    }

    public Explosion func_217401_a(@Nullable Entity entityIn, @Nullable DamageSource damageSourceIn, double xIn, double yIn, double zIn, float explosionRadius, boolean causesFire, Explosion.Mode modeIn) {
        return this.world.func_217401_a(entityIn, damageSourceIn, xIn, yIn, zIn, explosionRadius, causesFire, modeIn);
    }

    public boolean func_175719_a(@Nullable PlayerEntity player, BlockPos pos, Direction side) {
        return this.world.func_175719_a(player, pos, side);
    }

    public void calculateInitialWeatherBody() {
        this.world.calculateInitialWeatherBody();
    }

    public World func_201672_e() {
        return this.world;
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public void func_82738_a(long worldTime) {
        this.world.func_82738_a(worldTime);
    }

    public long func_72905_C() {
        return this.world.func_72905_C();
    }

    public void func_72877_b(long time) {
        this.world.func_72877_b(time);
    }

    public BlockPos func_175694_M() {
        return this.world.func_175694_M();
    }

    public void func_175652_B(BlockPos pos) {
        this.world.func_175652_B(pos);
    }

    public boolean canMineBlockBody(PlayerEntity player, BlockPos pos) {
        return this.world.canMineBlockBody(player, pos);
    }

    public int func_72940_L() {
        return this.world.func_72940_L();
    }

    public Dimension func_201675_m() {
        return this.world.func_201675_m();
    }

    public float func_130001_d() {
        return this.world.func_130001_d();
    }

    public float func_72826_c(float partialTicks) {
        return this.world.func_72826_c(partialTicks);
    }

    public int func_72853_d() {
        return this.world.func_72853_d();
    }

    public Stream<VoxelShape> func_223439_a(@Nullable Entity entityIn, AxisAlignedBB aabb, Set<Entity> entitiesToIgnore) {
        return this.world.func_223439_a(entityIn, aabb, entitiesToIgnore);
    }

    public Stream<VoxelShape> func_217352_b(@Nullable Entity p_226667_1_, AxisAlignedBB p_226667_2_, Set<Entity> p_226667_3_) {
        return this.world.func_217352_b(p_226667_1_, p_226667_2_, p_226667_3_);
    }

    @Nullable
    public PlayerEntity func_217365_a(double x, double y, double z) {
        return this.world.func_217365_a(x, y, z);
    }

    public int getMaxHeight() {
        return this.world.getMaxHeight();
    }

    public Biome getBiomeBody(BlockPos pos) {
        return this.world.getBiomeBody(pos);
    }

    public void func_225319_b(BlockPos p_225319_1_, BlockState p_225319_2_, BlockState p_225319_3_) {
        this.world.func_225319_b(p_225319_1_, p_225319_2_, p_225319_3_);
    }

    public float func_72971_b(float partialTicks) {
        return this.world.func_72971_b(partialTicks);
    }

    public float getSunBrightnessBody(float partialTicks) {
        return this.world.getSunBrightnessBody(partialTicks);
    }

    public Vec3d func_217382_a(BlockPos p_217382_1_, float p_217382_2_) {
        return this.world.func_217382_a(p_217382_1_, p_217382_2_);
    }

    public Vec3d getSkyColorBody(BlockPos p_217382_1_, float p_217382_2_) {
        return this.world.getSkyColorBody(p_217382_1_, p_217382_2_);
    }

    public Vec3d func_72824_f(float partialTicks) {
        return this.world.func_72824_f(partialTicks);
    }

    public Vec3d getCloudColorBody(float partialTicks) {
        return this.world.getCloudColorBody(partialTicks);
    }

    public Vec3d func_72948_g(float partialTicks) {
        return this.world.func_72948_g(partialTicks);
    }

    public float func_72880_h(float partialTicks) {
        return this.world.func_72880_h(partialTicks);
    }

    public float getStarBrightnessBody(float partialTicks) {
        return this.world.getStarBrightnessBody(partialTicks);
    }

    public ChunkStatus func_217342_O() {
        return this.world.func_217342_O();
    }

    public List<Entity> func_217394_a(@Nullable EntityType<?> type, AxisAlignedBB boundingBox, Predicate<? super Entity> predicate) {
        return this.world.func_217394_a(type, boundingBox, predicate);
    }

    public <T extends Entity> List<T> func_225316_b(Class<? extends T> p_225316_1_, AxisAlignedBB p_225316_2_, @Nullable Predicate<? super T> p_225316_3_) {
        return this.world.func_225316_b(p_225316_1_, p_225316_2_, p_225316_3_);
    }

    public double func_72919_O() {
        return this.world.func_72919_O();
    }

    public int func_175658_ac() {
        return this.world.func_175658_ac();
    }

    public void func_175702_c(int lastLightningBoltIn) {
        this.world.func_175702_c(lastLightningBoltIn);
    }

    @Nullable
    public BlockPos func_211157_a(String name, BlockPos pos, int radius, boolean p_211157_4_) {
        return this.world.func_211157_a(name, pos, radius, p_211157_4_);
    }
}

