/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.engineersdecor;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@SlabSupportProvider(modid="engineersdecor")
public class EngineersDecorSlabSupport
implements IHorizontalSlabSupport {
    private final Class<?> slab;
    private final IntegerProperty parts;

    public EngineersDecorSlabSupport() {
        IntegerProperty parts;
        Class<?> slab;
        try {
            slab = Class.forName("wile.engineersdecor.blocks.BlockDecorSlab");
            parts = (IntegerProperty)slab.getField("PARTS").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            parts = null;
        }
        this.slab = slab;
        this.parts = parts;
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return this.slab != null && block.getClass().equals(this.slab);
    }

    @Override
    public boolean isHorizontalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null && state.func_177230_c().getClass().equals(this.slab) && (Integer)state.func_177229_b((IProperty)this.parts) < 2;
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof BlockItem && ((BlockItem)item).func_179223_d().getClass().equals(this.slab);
    }

    @Override
    public SlabType getHalf(World world, BlockPos pos, BlockState state) {
        return this.slab != null && (Integer)state.func_177229_b((IProperty)this.parts) == 0 ? SlabType.BOTTOM : SlabType.TOP;
    }

    @Override
    public BlockState getStateForHalf(World world, BlockPos pos, BlockState state, SlabType half) {
        return this.slab == null ? state : (BlockState)state.func_206870_a((IProperty)this.parts, (Comparable)Integer.valueOf(half == SlabType.BOTTOM ? 0 : 1));
    }
}

