/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.client.proxy.ClientProxy;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.RaisedCampfireBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Quat4f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientConstants {
    private static final Map<BlockState, Map<Direction, IBakedModel>> VERTICAL_SLAB_MODELS = Maps.newIdentityHashMap();
    private static final Map<Item, IBakedModel> VERTICAL_SLAB_ITEM_MODELS = Maps.newIdentityHashMap();
    private static final TRSRTransformation TRANSFORMATION_2D = new TRSRTransformation(null, ClientConstants.quaternionConvert(new Quaternion(new Vector3f(0.0f, 0.0f, -1.0f), 90.0f, true)), null, null);
    public static final int TINT_OFFSET = 1000;

    private static Quat4f quaternionConvert(Quaternion quat) {
        return new Quat4f(quat.func_195889_a(), quat.func_195891_b(), quat.func_195893_c(), quat.func_195894_d());
    }

    public static boolean isTransparent(BlockState state) {
        return !state.func_185904_a().func_76218_k() || !state.func_200132_m();
    }

    public static IBakedModel getFallbackModel() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
    }

    public static IBakedModel getVerticalModel(BlockState state, Direction direction) {
        Map<Direction, IBakedModel> map = VERTICAL_SLAB_MODELS.get(state);
        if (map != null) {
            return map.getOrDefault(direction, ClientConstants.getFallbackModel());
        }
        return ClientConstants.getFallbackModel();
    }

    public static IBakedModel getVerticalModel(Item item) {
        return VERTICAL_SLAB_ITEM_MODELS.getOrDefault(item, ClientConstants.getFallbackModel());
    }

    public static IBakedModel bake(ModelLoader modelLoader, IUnbakedModel baseModel, ResourceLocation location, boolean uvlock, ISprite transform) {
        if (baseModel instanceof VariantList) {
            VariantList model = (VariantList)baseModel;
            if (model.func_188114_a().isEmpty()) {
                return null;
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (Variant variant : model.func_188114_a()) {
                IBakedModel ibakedmodel = modelLoader.getBakedModel(variant.func_188046_a(), transform, ModelLoader.defaultTextureGetter(), DefaultVertexFormats.field_176599_b);
                builder.func_177677_a(ibakedmodel, variant.func_188047_d());
            }
            return builder.func_209614_a();
        }
        return baseModel.bake((ModelBakery)modelLoader, ModelLoader.defaultTextureGetter(), transform, DefaultVertexFormats.field_176599_b);
    }

    public static void bakeVerticalSlabModels(ModelLoader modelLoader) {
        VERTICAL_SLAB_MODELS.clear();
        VERTICAL_SLAB_ITEM_MODELS.clear();
        ForgeRegistries.BLOCKS.forEach(block -> {
            if (SlabSupport.isHorizontalSlab(block)) {
                boolean raisedCampfire = block instanceof RaisedCampfireBlock;
                boolean uvlock = DSConfig.CLIENT.uvlock((Block)block);
                block.func_176194_O().func_177619_a().forEach(state -> {
                    ModelResourceLocation resourceLocation = BlockModelShapes.func_209554_c((BlockState)state);
                    try {
                        EnumMap map = Maps.newEnumMap(Direction.class);
                        IUnbakedModel model = modelLoader.func_209597_a((ResourceLocation)resourceLocation);
                        if (raisedCampfire) {
                            map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)TRSRTransformation.from((ModelRotation)ModelRotation.X90_Y180).compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock)));
                            map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)TRSRTransformation.from((ModelRotation)ModelRotation.X90_Y270).compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock)));
                            map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)TRSRTransformation.from((ModelRotation)ModelRotation.X90_Y0).compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock)));
                            map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)TRSRTransformation.from((ModelRotation)ModelRotation.X90_Y90).compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock)));
                        } else {
                            map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)ModelRotation.X90_Y180.func_188048_b(), uvlock)));
                            map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)ModelRotation.X90_Y270.func_188048_b(), uvlock)));
                            map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)ModelRotation.X90_Y0.func_188048_b(), uvlock)));
                            map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)ModelRotation.X90_Y90.func_188048_b(), uvlock)));
                        }
                        VERTICAL_SLAB_MODELS.put((BlockState)state, map);
                    }
                    catch (Exception e) {
                        DoubleSlabs.LOGGER.warn("Failed to generate vertical slab model for: {}", (Object)resourceLocation.toString());
                        DoubleSlabs.LOGGER.catching((Throwable)e);
                    }
                });
            }
        });
        ForgeRegistries.ITEMS.forEach(item -> {
            if (SlabSupport.isHorizontalSlab(item)) {
                boolean uvlock = item instanceof BlockItem ? DSConfig.CLIENT.uvlock(((BlockItem)item).func_179223_d()) : DSConfig.CLIENT.uvlock((Item)item);
                ModelResourceLocation resourceLocation = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
                try {
                    boolean is3d;
                    IUnbakedModel model = modelLoader.func_209597_a((ResourceLocation)resourceLocation);
                    boolean bl = is3d = model instanceof BlockModel && ((BlockModel)model).func_178311_c();
                    if (is3d) {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ISprite)new BasicState((IModelState)ModelRotation.X90_Y0.func_188048_b(), uvlock)));
                    } else {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, modelLoader.getBakedModel((ResourceLocation)resourceLocation, (ISprite)new BasicState((IModelState)TRANSFORMATION_2D, uvlock), ModelLoader.defaultTextureGetter(), DefaultVertexFormats.field_176599_b));
                    }
                }
                catch (Exception e) {
                    DoubleSlabs.LOGGER.warn("Failed to generate vertical slab item model for: {}", (Object)resourceLocation.toString());
                    DoubleSlabs.LOGGER.catching((Throwable)e);
                }
            }
        });
        DoubleSlabs.LOGGER.debug("Loaded vertical slab models!");
    }
}

