/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.handlers;

import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class ClientRenderHandler {
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<IProperty<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty<?> prop = entry.getKey();
            return prop.func_177701_a() + "=" + this.getPropertyName(prop, entry.getValue());
        }

        private <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
            return property.func_177702_a(entry);
        }
    };

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlockHighlight(DrawBlockHighlightEvent.HighlightBlock event) {
        BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.getTarget().func_216350_a());
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_() || Minecraft.func_71410_x().field_71439_g.func_184812_l_() && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            double z;
            double y;
            double x;
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.lineWidth((float)Math.max(2.5f, (float)Minecraft.func_71410_x().field_195558_d.func_198109_k() / 1920.0f * 2.5f));
            GlStateManager.disableTexture();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.matrixMode((int)5889);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.999f);
            if (state.func_177230_c() == DSBlocks.DOUBLE_SLAB.get()) {
                x = (double)event.getTarget().func_216350_a().func_177958_n() - event.getInfo().func_216785_c().field_72450_a;
                y = (double)event.getTarget().func_216350_a().func_177956_o() - event.getInfo().func_216785_c().field_72448_b;
                z = (double)event.getTarget().func_216350_a().func_177952_p() - event.getInfo().func_216785_c().field_72449_c;
                if (event.getTarget().func_216347_e().field_72448_b - (double)event.getTarget().func_216350_a().func_177956_o() > 0.5) {
                    WorldRenderer.func_189694_a((double)x, (double)(y + 0.5), (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                } else {
                    WorldRenderer.func_189694_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 0.5), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                }
                event.setCanceled(true);
            }
            if (state.func_177230_c() == DSBlocks.VERTICAL_SLAB.get() && ((Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue()) {
                x = (double)event.getTarget().func_216350_a().func_177958_n() - event.getInfo().func_216785_c().field_72450_a;
                y = (double)event.getTarget().func_216350_a().func_177956_o() - event.getInfo().func_216785_c().field_72448_b;
                z = (double)event.getTarget().func_216350_a().func_177952_p() - event.getInfo().func_216785_c().field_72449_c;
                switch (((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176740_k()) {
                    case X: {
                        if (event.getTarget().func_216347_e().field_72450_a - (double)event.getTarget().func_216350_a().func_177958_n() > 0.5) {
                            WorldRenderer.func_189694_a((double)(x + 0.5), (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            WorldRenderer.func_189694_a((double)x, (double)y, (double)z, (double)(x + 0.5), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                    case Z: {
                        if (event.getTarget().func_216347_e().field_72449_c - (double)event.getTarget().func_216350_a().func_177952_p() > 0.5) {
                            WorldRenderer.func_189694_a((double)x, (double)y, (double)(z + 0.5), (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        } else {
                            WorldRenderer.func_189694_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 0.5), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                        }
                        event.setCanceled(true);
                        break;
                    }
                }
            }
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableTexture();
            GlStateManager.disableBlend();
        }
    }

    private static String stateToString(@Nullable BlockState state) {
        if (state == null) {
            return TextFormatting.RED + "null";
        }
        return state.func_177230_c().getRegistryName().toString() + "[" + state.func_206871_b().entrySet().stream().map(MAP_ENTRY_TO_STRING).collect(Collectors.joining(",")) + "]";
    }

    private static String tileToString(@Nullable TileEntity tile) {
        if (tile == null) {
            return TextFormatting.RED + "null";
        }
        String data = tile.getTileData().toString();
        return ForgeRegistries.TILE_ENTITIES.getKey((IForgeRegistryEntry)tile.func_200662_C()).toString() + data;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlayText(RenderGameOverlayEvent.Text event) {
        BlockPos pos;
        TileEntity tileEntity;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && (tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos = ((BlockRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216350_a())) instanceof SlabTileEntity) {
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            event.getRight().add("");
            event.getRight().add("Slab Types");
            event.getRight().add("Positive Block: " + ClientRenderHandler.stateToString(tile.getPositiveBlockInfo().getBlockState()));
            event.getRight().add("Positive Tile: " + ClientRenderHandler.tileToString(tile.getPositiveBlockInfo().getTileEntity()));
            event.getRight().add("Negative Block: " + ClientRenderHandler.stateToString(tile.getNegativeBlockInfo().getBlockState()));
            event.getRight().add("Negative Tile: " + ClientRenderHandler.tileToString(tile.getNegativeBlockInfo().getTileEntity()));
        }
    }
}

