/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class VerticalSlabBakedModel
extends DynamicSlabBakedModel {
    public static final VerticalSlabBakedModel INSTANCE = new VerticalSlabBakedModel();
    public static final ModelProperty<Boolean> ROTATE_POSITIVE = new ModelProperty();
    public static final ModelProperty<Boolean> ROTATE_NEGATIVE = new ModelProperty();
    private final Map<BlockState, IBakedModel> models = new HashMap<BlockState, IBakedModel>();

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        if (state != null && extraData.hasProperty(POSITIVE_BLOCK) && extraData.hasProperty(NEGATIVE_BLOCK)) {
            IBakedModel model2;
            IHorizontalSlabSupport horizontalSlabSupport;
            IBlockInfo positiveBlock = (IBlockInfo)extraData.getData(POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extraData.getData(NEGATIVE_BLOCK);
            assert (positiveBlock != null);
            assert (negativeBlock != null);
            BlockState positiveState = positiveBlock.getBlockState();
            BlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null && negativeState == null) {
                return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
            }
            boolean positiveTransparent = positiveState == null || ClientConstants.isTransparent(positiveState);
            boolean negativeTransparent = negativeState == null || ClientConstants.isTransparent(negativeState);
            boolean shouldCull = positiveState != null && negativeState != null && DSConfig.CLIENT.shouldCull(positiveState.func_177230_c()) && DSConfig.CLIENT.shouldCull(negativeState.func_177230_c()) && (!positiveTransparent || !negativeTransparent || positiveState.func_177230_c() == negativeState.func_177230_c());
            boolean renderHalves = extraData.hasProperty(RENDER_POSITIVE) && extraData.getData(RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extraData.getData(RENDER_POSITIVE) != false;
            Direction direction = (Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
            if (positiveState != null && negativeState != null && VerticalSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockReader)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                BlockState doubleState = horizontalSlabSupport.getStateForHalf(positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, SlabType.DOUBLE);
                if (doubleState.canRenderInLayer(MinecraftForgeClient.getRenderLayer()) || MinecraftForgeClient.getRenderLayer() == null) {
                    IBakedModel model3 = ClientConstants.getVerticalModel(doubleState, direction);
                    return model3.getQuads(doubleState, side, rand, (IModelData)EmptyModelData.INSTANCE);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!(renderHalves && !renderPositive || positiveState == null || !positiveState.canRenderInLayer(MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = !extraData.hasProperty(ROTATE_POSITIVE) || (Boolean)extraData.getData(ROTATE_POSITIVE) != false ? ClientConstants.getVerticalModel(positiveState, direction) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(positiveState);
                List<BakedQuad> positiveQuads = this.getQuadsForState(positiveBlock, model2, side, rand);
                if (shouldCull && (!negativeTransparent && !positiveTransparent || positiveTransparent && !negativeTransparent || positiveTransparent && negativeTransparent)) {
                    positiveQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction.func_176734_d());
                }
                quads.addAll(positiveQuads);
            }
            if (!(renderHalves && renderPositive || negativeState == null || !negativeState.canRenderInLayer(MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = !extraData.hasProperty(ROTATE_NEGATIVE) || (Boolean)extraData.getData(ROTATE_NEGATIVE) != false ? ClientConstants.getVerticalModel(negativeState, direction) : Minecraft.func_71410_x().func_175602_ab().func_184389_a(negativeState);
                List<BakedQuad> negativeQuads = this.getQuadsForState(negativeBlock, model2, side, rand);
                if (shouldCull && (!positiveTransparent && !negativeTransparent || negativeTransparent && !positiveTransparent || positiveTransparent && negativeTransparent)) {
                    negativeQuads.removeIf(bakedQuad -> bakedQuad.func_178210_d() == direction);
                }
                quads.addAll(negativeQuads);
            }
            return quads;
        }
        if (MinecraftForgeClient.getRenderLayer() == null && (model = this.models.get(state)) != null) {
            return model.getQuads(state, side, rand, extraData);
        }
        return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
    }

    public void addModel(IBakedModel model, BlockState state) {
        this.models.put(state, model);
    }

    public IBakedModel getModel(BlockState state) {
        return this.models.get(state);
    }

    private boolean rotateModel(IModelData modelData, ModelProperty<IBlockInfo> property, IEnviromentBlockReader world, BlockPos pos) {
        IVerticalSlabSupport support;
        IBlockInfo blockInfo;
        if (modelData.hasProperty(property) && (blockInfo = (IBlockInfo)modelData.getData(property)) != null && blockInfo.getBlockState() != null && (support = SlabSupport.getVerticalSlabSupport((IBlockReader)world, pos, blockInfo.getBlockState())) != null) {
            return support.rotateModel((IBlockReader)blockInfo.getWorld(), pos, blockInfo.getBlockState());
        }
        return true;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IEnviromentBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IModelData modelData = super.getModelData(world, pos, state, tileData);
        modelData.setData(ROTATE_POSITIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)POSITIVE_BLOCK, world, pos));
        modelData.setData(ROTATE_NEGATIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)NEGATIVE_BLOCK, world, pos));
        return modelData;
    }
}

