/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class DynamicSlabBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public DynamicSlabBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return true;
    }

    public static Optional<SlabTileEntity> getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof SlabTileEntity ? Optional.of((SlabTileEntity)tile) : Optional.empty();
    }

    public static Optional<IBlockInfo> getAvailable(IBlockReader world, BlockPos pos) {
        return DynamicSlabBlock.getTile(world, pos).flatMap(tile -> Optional.of(tile.getPositiveBlockInfo().getBlockState() != null ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo()));
    }

    public static int min(IBlockReader world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : Integer.MAX_VALUE, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(IBlockReader world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 2.147483647E9, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(IBlockReader world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : 0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : 0)).orElse(0);
    }

    public static float maxFloat(IBlockReader world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(IBlockReader world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> (tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0) + (tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(IBlockReader world, BlockPos pos, Consumer<IBlockInfo> consumer) {
        DynamicSlabBlock.getTile(world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getPositiveBlockInfo());
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getNegativeBlockInfo());
            }
            return null;
        });
    }

    public static boolean both(IBlockReader world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    public static boolean either(IBlockReader world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) || tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SlabTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(true) : super.func_204507_t(state);
    }

    public boolean func_204509_a(@Nonnull IWorld world, @Nonnull BlockPos pos, BlockState state, @Nonnull IFluidState fluidState) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> {
            if (i.getBlockState().func_177230_c() instanceof IWaterLoggable) {
                ((IWaterLoggable)i.getBlockState().func_177230_c()).func_204509_a((IWorld)i.getWorld(), pos, i.getBlockState(), fluidState);
            }
        });
        return super.func_204509_a(world, pos, state, fluidState);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return super.func_204510_a(world, pos, state, fluid) && DynamicSlabBlock.either(world, pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()));
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        IFluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        if (blockstate.func_177230_c() == this) {
            return (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a && DynamicSlabBlock.either((IBlockReader)context.func_195991_k(), blockpos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()))));
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type == PathType.WATER && world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return DynamicSlabBlock.maxFloat((IBlockReader)world, pos, i -> i.getBlockState().getExplosionResistance((IWorldReader)i.getWorld(), pos, exploder, explosion));
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        return DynamicSlabBlock.max((IBlockReader)world, pos, i -> i.getBlockState().getLightValue((IEnviromentBlockReader)i.getWorld(), pos));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return null;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (tileEntity instanceof SlabTileEntity) {
            LootContext.Builder newBuilder;
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                newBuilder = builder.func_216015_a(LootParameters.field_216287_g, (Object)tile.getPositiveBlockInfo().getBlockState());
                if (tile.getPositiveBlockInfo().getTileEntity() != null) {
                    newBuilder = newBuilder.func_216015_a(LootParameters.field_216288_h, (Object)tile.getPositiveBlockInfo().getTileEntity());
                }
                drops.addAll(tile.getPositiveBlockInfo().getBlockState().func_215693_a(newBuilder));
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                newBuilder = builder.func_216015_a(LootParameters.field_216287_g, (Object)tile.getNegativeBlockInfo().getBlockState());
                if (tile.getNegativeBlockInfo().getTileEntity() != null) {
                    newBuilder = newBuilder.func_216015_a(LootParameters.field_216288_h, (Object)tile.getNegativeBlockInfo().getTileEntity());
                }
                drops.addAll(tile.getNegativeBlockInfo().getBlockState().func_215693_a(newBuilder));
            }
        }
        return drops;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (player.func_184812_l_()) {
            DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_196947_b(i.getWorld(), pos, Blocks.field_150350_a.func_176223_P(), false));
            super.func_176208_a(world, pos, state, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return DynamicSlabBlock.getTile((IBlockReader)world, pos).map(tile -> {
                if (tintIndex >= 1000) {
                    return tile.getPositiveBlockInfo().getBlockState() != null ? Minecraft.func_71410_x().func_184125_al().func_216860_a(tile.getPositiveBlockInfo().getBlockState(), world, pos, tintIndex) : -1;
                }
                return tile.getNegativeBlockInfo().getBlockState() != null ? Minecraft.func_71410_x().func_184125_al().func_216860_a(tile.getNegativeBlockInfo().getBlockState(), world, pos, tintIndex) : -1;
            }).orElse(-1);
        };
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        super.func_196265_a(state, world, pos, random);
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_196944_b(world, pos, random));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_177230_c().func_180655_c(i.getBlockState(), i.getWorld(), pos, rand));
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().canConnectRedstone((IBlockReader)i.getWorld(), pos, side));
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_185911_a((IBlockReader)i.getWorld(), pos, side));
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().func_185893_b((IBlockReader)i.getWorld(), pos, side));
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return DynamicSlabBlock.max((IBlockReader)world, pos, i -> i.getBlockState().func_185888_a(i.getWorld(), pos));
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return DynamicSlabBlock.addFloat((IBlockReader)world, pos, i -> i.getBlockState().getEnchantPowerBonus((IWorldReader)i.getWorld(), pos));
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getFireSpreadSpeed((IBlockReader)i.getWorld(), pos, face));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getFlammability((IBlockReader)i.getWorld(), pos, face));
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isBurning((IBlockReader)i.getWorld(), pos));
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isFertile((IBlockReader)i.getWorld(), pos));
    }

    public boolean isFireSource(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isFireSource((IBlockReader)i.getWorld(), pos, side));
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isFlammable((IBlockReader)i.getWorld(), pos, face));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_215697_a(i.getWorld(), pos, i.getBlockState().func_177230_c(), fromPos, isMoving));
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().onNeighborChange((IWorldReader)i.getWorld(), pos, neighbor));
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random rand) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_196940_a(world, pos, rand));
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_177230_c().func_180652_a(i.getWorld(), pos, explosion));
    }

    public void func_176224_k(World world, BlockPos pos) {
        DynamicSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176224_k(tile.getPositiveBlockInfo().getWorld(), pos);
            }
        });
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return DynamicSlabBlock.maxFloat((IBlockReader)world, pos, i -> i.getBlockState().getSlipperiness((IWorldReader)i.getWorld(), pos, entity));
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getPositiveBlockInfo().getBlockState().canSustainPlant((IBlockReader)tile.getPositiveBlockInfo().getWorld(), pos, facing, plantable)).orElse(false);
    }

    public void func_196248_b(BlockState state, IWorld world, BlockPos pos, int flags) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_196948_b((IWorld)i.getWorld(), pos, flags));
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_215705_a(i.getWorld(), pos, oldState, isMoving));
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        return DynamicSlabBlock.either((IBlockReader)world, pos, i -> i.getBlockState().func_189547_a(i.getWorld(), pos, id, param));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return DynamicSlabBlock.either((IBlockReader)world, pos, i -> i.getBlockState().isLadder((IWorldReader)i.getWorld(), pos, entity));
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isBed((IBlockReader)i.getWorld(), pos, (LivingEntity)player));
    }

    public void onPlantGrow(BlockState state, IWorld world, BlockPos pos, BlockPos source) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_177230_c().onPlantGrow(i.getBlockState(), (IWorld)i.getWorld(), pos, source));
    }

    public boolean isPortalFrame(BlockState state, IWorldReader world, BlockPos pos) {
        return DynamicSlabBlock.either((IBlockReader)world, pos, i -> i.getBlockState().isPortalFrame((IWorldReader)i.getWorld(), pos));
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return DynamicSlabBlock.max((IBlockReader)world, pos, i -> i.getBlockState().getExpDrop((IWorldReader)i.getWorld(), pos, fortune, silktouch));
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return DynamicSlabBlock.getAvailable((IBlockReader)world, pos).map(i -> i.getBlockState().getSoundType((IWorldReader)i.getWorld(), pos, null)).orElse(super.getSoundType(state, world, pos, entity));
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        ArrayList result = new ArrayList();
        DynamicSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> {
            float[] positiveBlockColours = null;
            float[] negativeBlockColours = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockColours = tile.getPositiveBlockInfo().getBlockState().getBeaconColorMultiplier((IWorldReader)tile.getPositiveBlockInfo().getWorld(), pos, beaconPos);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockColours = tile.getNegativeBlockInfo().getBlockState().getBeaconColorMultiplier((IWorldReader)tile.getNegativeBlockInfo().getWorld(), pos, beaconPos);
            }
            if (positiveBlockColours != null) {
                for (float colour : positiveBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
            if (negativeBlockColours != null) {
                for (float colour : negativeBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
        });
        if (result.size() == 0) {
            return null;
        }
        float[] colours = new float[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            colours[i] = ((Float)result.get(i)).floatValue();
        }
        return colours;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> {
            PathNodeType positiveBlockNodeType = null;
            PathNodeType negativeBlockNodeType = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockNodeType = tile.getPositiveBlockInfo().getBlockState().getAiPathNodeType((IBlockReader)tile.getPositiveBlockInfo().getWorld(), pos, entity);
            }
            if (positiveBlockNodeType != null) {
                return positiveBlockNodeType;
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockNodeType = tile.getNegativeBlockInfo().getBlockState().getAiPathNodeType((IBlockReader)tile.getNegativeBlockInfo().getWorld(), pos, entity);
            }
            return negativeBlockNodeType;
        }).orElse(super.getAiPathNodeType(state, world, pos, entity));
    }

    public void catchFire(BlockState state, World world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().catchFire(i.getWorld(), pos, face, igniter));
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return DynamicSlabBlock.both(world, pos, i -> i.getBlockState().canEntityDestroy((IBlockReader)i.getWorld(), pos, entity));
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().onBlockExploded(i.getWorld(), pos, explosion));
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }
}

