/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.common.tileentity.RaisedCampfireTileEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.registries.ForgeRegistries;

public class RaisedCampfireBlock
extends CampfireBlock {
    private static final VoxelShape NEW_SHAPE = field_220100_a.func_197751_a(0.0, 0.5, 0.0);
    private final int fireDamage;
    private Block parent;
    private ResourceLocation parentLocation;

    public RaisedCampfireBlock(Block parent, int fireDamage, Block.Properties properties) {
        super(properties);
        this.parent = parent;
        this.fireDamage = fireDamage;
    }

    public RaisedCampfireBlock(ResourceLocation parentLocation, int fireDamage, Block.Properties properties) {
        super(properties);
        this.parentLocation = parentLocation;
        this.fireDamage = fireDamage;
    }

    private Optional<Block> getParent() {
        if (this.parent == null && this.parentLocation != null) {
            this.parent = (Block)ForgeRegistries.BLOCKS.getValue(this.parentLocation);
        }
        return this.parent != null ? Optional.of(this.parent) : Optional.empty();
    }

    public Item func_199767_j() {
        return this.getParent().map(Block::func_199767_j).orElseGet(() -> super.func_199767_j());
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return this.getParent().map(b -> b.func_185473_a(worldIn, pos, state)).orElseGet(() -> super.func_185473_a(worldIn, pos, state));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return this.getParent().map(b -> b.func_220076_a(state, builder)).orElseGet(() -> super.func_220076_a(state, builder));
    }

    public void func_176199_a(World world, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)field_220101_b)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_76372_a, (float)this.fireDamage);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && ((Boolean)state.func_177229_b((IProperty)field_220101_b)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_76372_a, (float)this.fireDamage);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return NEW_SHAPE;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new RaisedCampfireTileEntity();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Blocks.field_222433_lV);
    }
}

