/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.container;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.PlayerInventoryWrapper;
import cjminecraft.doubleslabs.common.init.DSContainers;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class WrappedContainer
extends Container {
    public final Container wrapped;
    public final World world;
    private final boolean positive;

    public WrappedContainer(int id, PlayerInventory playerInventory, PlayerEntity player, INamedContainerProvider provider, IBlockInfo blockInfo) {
        super((ContainerType)DSContainers.WRAPPED_CONTAINER.get(), id);
        this.positive = blockInfo.isPositive();
        this.world = blockInfo.getWorld();
        PlayerInventoryWrapper playerInventoryWrapper = new PlayerInventoryWrapper(playerInventory, blockInfo.getWorld());
        this.wrapped = provider.createMenu(id, (PlayerInventory)playerInventoryWrapper, playerInventoryWrapper.field_70458_d);
    }

    public WrappedContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        super((ContainerType)DSContainers.WRAPPED_CONTAINER.get(), id);
        BlockPos pos = buffer.func_179259_c();
        this.positive = buffer.readBoolean();
        SlabTileEntity tile = (SlabTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        this.world = this.positive ? tile.getPositiveBlockInfo().getWorld() : tile.getNegativeBlockInfo().getWorld();
        PlayerInventoryWrapper playerInventoryWrapper = new PlayerInventoryWrapper(playerInventory, this.world);
        this.wrapped = ((ContainerType)ForgeRegistries.CONTAINERS.getValue(buffer.func_192575_l())).create(id, (PlayerInventory)playerInventoryWrapper, buffer);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.wrapped.func_75145_c(playerIn);
    }

    public void func_75132_a(IContainerListener listener) {
        this.wrapped.func_75132_a(listener);
    }

    public void func_82847_b(IContainerListener listener) {
        this.wrapped.func_82847_b(listener);
    }

    public NonNullList<ItemStack> func_75138_a() {
        return this.wrapped.func_75138_a();
    }

    public void func_75142_b() {
        this.wrapped.func_75142_b();
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        return this.wrapped.func_75140_a(playerIn, id);
    }

    public Slot func_75139_a(int slotId) {
        return this.wrapped.func_75139_a(slotId);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return this.wrapped.func_82846_b(playerIn, index);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        return this.wrapped.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.wrapped.func_94530_a(stack, slotIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.wrapped.func_75134_a(playerIn);
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.wrapped.func_75130_a(inventoryIn);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        this.wrapped.func_75141_a(slotID, stack);
    }

    public void func_190896_a(List<ItemStack> stacks) {
        this.wrapped.func_190896_a(stacks);
    }

    public void func_75137_b(int id, int data) {
        this.wrapped.func_75137_b(id, data);
    }

    public short func_75136_a(PlayerInventory invPlayer) {
        return this.wrapped.func_75136_a(invPlayer);
    }

    public boolean func_75129_b(PlayerEntity player) {
        return this.wrapped.func_75129_b(player);
    }

    public void func_75128_a(PlayerEntity player, boolean canCraft) {
        this.wrapped.func_75128_a(player, canCraft);
    }

    public boolean func_94531_b(Slot slotIn) {
        return this.wrapped.func_94531_b(slotIn);
    }
}

